/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.resultset.core;

import com.espertech.esper.common.client.annotation.HintEnum;
import com.espertech.esper.common.client.configuration.Configuration;
import com.espertech.esper.common.internal.compile.stage1.spec.OutputLimitLimitType;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import java.lang.annotation.Annotation;

public enum ResultSetProcessorOutputConditionType {
    SNAPSHOT,
    POLICY_FIRST,
    POLICY_LASTALL_UNORDERED,
    POLICY_NONFIRST;


    public static ResultSetProcessorOutputConditionType getConditionType(OutputLimitLimitType displayLimit, boolean isAggregated, boolean hasOrderBy, boolean hasOptHint, boolean isGrouped) {
        if (displayLimit == OutputLimitLimitType.SNAPSHOT) {
            return SNAPSHOT;
        }
        if (displayLimit == OutputLimitLimitType.FIRST && !isGrouped) {
            return POLICY_FIRST;
        }
        if (!isAggregated && !isGrouped && displayLimit == OutputLimitLimitType.LAST) {
            return POLICY_LASTALL_UNORDERED;
        }
        if (hasOptHint && displayLimit == OutputLimitLimitType.ALL && !hasOrderBy) {
            return POLICY_LASTALL_UNORDERED;
        }
        if (hasOptHint && displayLimit == OutputLimitLimitType.LAST && !hasOrderBy) {
            return POLICY_LASTALL_UNORDERED;
        }
        return POLICY_NONFIRST;
    }

    public static boolean getOutputLimitOpt(Annotation[] annotations, Configuration configuration, boolean hasOrderBy) throws ExprValidationException {
        if (hasOrderBy) {
            if (ResultSetProcessorOutputConditionType.hasOptHintEnable(annotations)) {
                throw new ExprValidationException("The " + (Object)((Object)HintEnum.ENABLE_OUTPUTLIMIT_OPT) + " hint is not supported with order-by");
            }
            return false;
        }
        boolean opt = configuration.getCompiler().getViewResources().isOutputLimitOpt();
        if (annotations == null) {
            return opt;
        }
        return opt ? HintEnum.DISABLE_OUTPUTLIMIT_OPT.getHint(annotations) == null : ResultSetProcessorOutputConditionType.hasOptHintEnable(annotations);
    }

    private static boolean hasOptHintEnable(Annotation[] annotations) {
        return HintEnum.ENABLE_OUTPUTLIMIT_OPT.getHint(annotations) != null;
    }
}

