/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.resultset.rowpergrouprollup;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.MultiKeyArrayOfKeys;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.epl.agg.core.AggregationGroupByRollupLevel;
import com.espertech.esper.common.internal.epl.resultset.rowpergrouprollup.ResultSetProcessorRowPerGroupRollup;
import com.espertech.esper.common.internal.epl.resultset.rowpergrouprollup.ResultSetProcessorRowPerGroupRollupOutputLastHelper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ResultSetProcessorRowPerGroupRollupOutputLastHelperImpl
implements ResultSetProcessorRowPerGroupRollupOutputLastHelper {
    private final ResultSetProcessorRowPerGroupRollup processor;
    private final Map<Object, EventBean[]>[] outputLimitGroupRepsPerLevel;
    private final Map<Object, EventBean>[] groupRepsOutputLastUnordRStream;

    public ResultSetProcessorRowPerGroupRollupOutputLastHelperImpl(ResultSetProcessorRowPerGroupRollup processor, int levelCount) {
        int i;
        this.processor = processor;
        this.outputLimitGroupRepsPerLevel = new LinkedHashMap[levelCount];
        for (i = 0; i < levelCount; ++i) {
            this.outputLimitGroupRepsPerLevel[i] = new LinkedHashMap<Object, EventBean[]>();
        }
        if (processor.isSelectRStream()) {
            this.groupRepsOutputLastUnordRStream = new LinkedHashMap[levelCount];
            for (i = 0; i < levelCount; ++i) {
                this.groupRepsOutputLastUnordRStream[i] = new LinkedHashMap<Object, EventBean>();
            }
        } else {
            this.groupRepsOutputLastUnordRStream = null;
        }
    }

    @Override
    public void processView(EventBean[] newData, EventBean[] oldData, boolean isGenerateSynthetic) {
        Object groupKey;
        Object groupKeyComplete;
        EventBean[] eventsPerStream;
        Object[] groupKeysPerLevel = new Object[this.processor.getGroupByRollupDesc().getLevels().length];
        if (newData != null) {
            for (EventBean aNewData : newData) {
                eventsPerStream = new EventBean[]{aNewData};
                groupKeyComplete = this.processor.generateGroupKeySingle(eventsPerStream, true);
                for (AggregationGroupByRollupLevel level : this.processor.getGroupByRollupDesc().getLevels()) {
                    groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                    this.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, eventsPerStream);
                    if (!this.processor.isSelectRStream() || this.groupRepsOutputLastUnordRStream[level.getLevelNumber()].containsKey(groupKey)) continue;
                    this.processor.generateOutputBatchedMapUnsorted(false, groupKey, level, eventsPerStream, true, isGenerateSynthetic, this.groupRepsOutputLastUnordRStream[level.getLevelNumber()]);
                }
                this.processor.getAggregationService().applyEnter(eventsPerStream, groupKeysPerLevel, this.processor.getAgentInstanceContext());
            }
        }
        if (oldData != null) {
            for (EventBean anOldData : oldData) {
                eventsPerStream = new EventBean[]{anOldData};
                groupKeyComplete = this.processor.generateGroupKeySingle(eventsPerStream, false);
                for (AggregationGroupByRollupLevel level : this.processor.getGroupByRollupDesc().getLevels()) {
                    groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                    this.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, eventsPerStream);
                    if (!this.processor.isSelectRStream() || this.groupRepsOutputLastUnordRStream[level.getLevelNumber()].containsKey(groupKey)) continue;
                    this.processor.generateOutputBatchedMapUnsorted(false, groupKey, level, eventsPerStream, false, isGenerateSynthetic, this.groupRepsOutputLastUnordRStream[level.getLevelNumber()]);
                }
                this.processor.getAggregationService().applyLeave(eventsPerStream, groupKeysPerLevel, this.processor.getAgentInstanceContext());
            }
        }
    }

    @Override
    public void processJoin(Set<MultiKeyArrayOfKeys<EventBean>> newEvents, Set<MultiKeyArrayOfKeys<EventBean>> oldEvents, boolean isGenerateSynthetic) {
        Object groupKey;
        Object groupKeyComplete;
        Object[] groupKeysPerLevel = new Object[this.processor.getGroupByRollupDesc().getLevels().length];
        if (newEvents != null) {
            for (MultiKeyArrayOfKeys<EventBean> newEvent : newEvents) {
                EventBean[] aNewData = newEvent.getArray();
                groupKeyComplete = this.processor.generateGroupKeySingle(aNewData, true);
                for (AggregationGroupByRollupLevel level : this.processor.getGroupByRollupDesc().getLevels()) {
                    groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                    this.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, aNewData);
                    if (!this.processor.isSelectRStream() || this.groupRepsOutputLastUnordRStream[level.getLevelNumber()].containsKey(groupKey)) continue;
                    this.processor.generateOutputBatchedMapUnsorted(false, groupKey, level, aNewData, true, isGenerateSynthetic, this.groupRepsOutputLastUnordRStream[level.getLevelNumber()]);
                }
                this.processor.getAggregationService().applyEnter(aNewData, groupKeysPerLevel, this.processor.getAgentInstanceContext());
            }
        }
        if (oldEvents != null) {
            for (MultiKeyArrayOfKeys<EventBean> oldEvent : oldEvents) {
                EventBean[] aOldData = oldEvent.getArray();
                groupKeyComplete = this.processor.generateGroupKeySingle(aOldData, false);
                for (AggregationGroupByRollupLevel level : this.processor.getGroupByRollupDesc().getLevels()) {
                    groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                    this.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, aOldData);
                    if (!this.processor.isSelectRStream() || this.groupRepsOutputLastUnordRStream[level.getLevelNumber()].containsKey(groupKey)) continue;
                    this.processor.generateOutputBatchedMapUnsorted(false, groupKey, level, aOldData, false, isGenerateSynthetic, this.groupRepsOutputLastUnordRStream[level.getLevelNumber()]);
                }
                this.processor.getAggregationService().applyLeave(aOldData, groupKeysPerLevel, this.processor.getAgentInstanceContext());
            }
        }
    }

    @Override
    public UniformPair<EventBean[]> outputView(boolean isSynthesize) {
        return this.output(isSynthesize, false);
    }

    @Override
    public UniformPair<EventBean[]> outputJoin(boolean isSynthesize) {
        return this.output(isSynthesize, true);
    }

    @Override
    public void destroy() {
    }

    private UniformPair<EventBean[]> output(boolean isSynthesize, boolean isJoin) {
        ArrayList<EventBean> newEvents = new ArrayList<EventBean>(4);
        for (AggregationGroupByRollupLevel level : this.processor.getGroupByRollupDesc().getLevels()) {
            Map<Object, EventBean[]> groupGenerators = this.outputLimitGroupRepsPerLevel[level.getLevelNumber()];
            for (Map.Entry<Object, EventBean[]> entry : groupGenerators.entrySet()) {
                this.processor.generateOutputBatched(entry.getKey(), level, entry.getValue(), true, isSynthesize, newEvents, null);
            }
        }
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        for (Map<Object, EventBean[]> outputLimitGroupRepsPerLevelItem : this.outputLimitGroupRepsPerLevel) {
            outputLimitGroupRepsPerLevelItem.clear();
        }
        EventBean[] oldEventsArr = null;
        if (this.groupRepsOutputLastUnordRStream != null) {
            ArrayList<EventBean> oldEventList = new ArrayList<EventBean>(4);
            for (Map<Object, EventBean> map : this.groupRepsOutputLastUnordRStream) {
                oldEventList.addAll(map.values());
            }
            if (!oldEventList.isEmpty()) {
                oldEventsArr = oldEventList.toArray(new EventBean[oldEventList.size()]);
                for (Map<Object, EventBean> map : this.groupRepsOutputLastUnordRStream) {
                    map.clear();
                }
            }
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<Object>(newEventsArr, oldEventsArr);
    }
}

