/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.resultset.select.eval;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectExprForgeContext;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectExprProcessorCodegenSymbol;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectExprProcessorForge;
import com.espertech.esper.common.internal.event.core.BaseNestableEventUtil;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.core.WriteablePropertyDescriptor;
import com.espertech.esper.common.internal.event.json.compiletime.JsonUnderlyingField;
import com.espertech.esper.common.internal.event.json.core.JsonEventType;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceCompileTime;
import com.espertech.esper.common.internal.util.TypeWidenerException;
import com.espertech.esper.common.internal.util.TypeWidenerFactory;
import com.espertech.esper.common.internal.util.TypeWidenerSPI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class SelectEvalStreamWUndRecastJsonFactory {
    public static SelectExprProcessorForge make(EventType[] eventTypes, SelectExprForgeContext selectExprForgeContext, int streamNumber, EventType targetType, ExprNode[] exprNodes, ClasspathImportServiceCompileTime classpathImportService, String statementName) throws ExprValidationException {
        JsonEventType jsonResultType = (JsonEventType)targetType;
        JsonEventType jsonStreamType = (JsonEventType)eventTypes[streamNumber];
        if (jsonResultType.isDeepEqualsConsiderOrder(jsonStreamType) && selectExprForgeContext.getExprForges().length == 0) {
            return new JsonInsertProcessorStraightFieldAssign(streamNumber, jsonStreamType, jsonResultType);
        }
        Set<WriteablePropertyDescriptor> writables = EventTypeUtility.getWriteableProperties(jsonResultType, true, false);
        ArrayList<Item> items = new ArrayList<Item>();
        ArrayList<WriteablePropertyDescriptor> written = new ArrayList<WriteablePropertyDescriptor>();
        for (WriteablePropertyDescriptor writeable : writables) {
            boolean setTwoTypeFound;
            Object setTwoType;
            String propertyName = writeable.getPropertyName();
            JsonUnderlyingField fieldSource = jsonStreamType.getDetail().getFieldDescriptors().get(propertyName);
            JsonUnderlyingField fieldTarget = jsonResultType.getDetail().getFieldDescriptors().get(propertyName);
            if (fieldSource == null) continue;
            Object setOneType = jsonStreamType.getTypes().get(propertyName);
            ExprValidationException message = BaseNestableEventUtil.comparePropType(propertyName, setOneType, setTwoType = jsonResultType.getTypes().get(propertyName), setTwoTypeFound = jsonResultType.getTypes().containsKey(propertyName), jsonResultType.getName());
            if (message != null) {
                throw new ExprValidationException(message.getMessage(), message);
            }
            items.add(new Item(fieldTarget, fieldSource, null, null));
            written.add(writeable);
        }
        for (int i = 0; i < selectExprForgeContext.getExprForges().length; ++i) {
            TypeWidenerSPI widener;
            String columnName = selectExprForgeContext.getColumnNames()[i];
            ExprForge forge = selectExprForgeContext.getExprForges()[i];
            ExprNode exprNode = exprNodes[i];
            WriteablePropertyDescriptor writable = SelectEvalStreamWUndRecastJsonFactory.findWritable(columnName, writables);
            if (writable == null) {
                throw new ExprValidationException("Failed to find column '" + columnName + "' in target type '" + jsonResultType.getName() + "'");
            }
            JsonUnderlyingField fieldTarget = jsonResultType.getDetail().getFieldDescriptors().get(writable.getPropertyName());
            try {
                widener = TypeWidenerFactory.getCheckPropertyAssignType(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(exprNode), exprNode.getForge().getEvaluationType(), writable.getType(), columnName, false, null, statementName);
            }
            catch (TypeWidenerException ex) {
                throw new ExprValidationException(ex.getMessage(), ex);
            }
            items.add(new Item(fieldTarget, null, forge, widener));
            written.add(writable);
        }
        Item[] itemsArr = items.toArray(new Item[0]);
        return new JsonInsertProcessorExpressions(streamNumber, itemsArr, jsonStreamType, jsonResultType);
    }

    private static WriteablePropertyDescriptor findWritable(String columnName, Set<WriteablePropertyDescriptor> writables) {
        for (WriteablePropertyDescriptor writable : writables) {
            if (!writable.getPropertyName().equals(columnName)) continue;
            return writable;
        }
        return null;
    }

    private static class Item {
        private final JsonUnderlyingField toField;
        private final JsonUnderlyingField optionalFromField;
        private final ExprForge forge;
        private final TypeWidenerSPI optionalWidener;
        private ExprEvaluator evaluatorAssigned;

        private Item(JsonUnderlyingField toField, JsonUnderlyingField optionalFromField, ExprForge forge, TypeWidenerSPI optionalWidener) {
            if (toField == null) {
                throw new IllegalArgumentException("Null to-field");
            }
            this.toField = toField;
            this.optionalFromField = optionalFromField;
            this.forge = forge;
            this.optionalWidener = optionalWidener;
        }

        public JsonUnderlyingField getToField() {
            return this.toField;
        }

        public JsonUnderlyingField getOptionalFromField() {
            return this.optionalFromField;
        }

        public ExprForge getForge() {
            return this.forge;
        }

        public TypeWidenerSPI getOptionalWidener() {
            return this.optionalWidener;
        }

        public ExprEvaluator getEvaluatorAssigned() {
            return this.evaluatorAssigned;
        }

        public void setEvaluatorAssigned(ExprEvaluator evaluatorAssigned) {
            this.evaluatorAssigned = evaluatorAssigned;
        }
    }

    private static class JsonInsertProcessorExpressions
    implements SelectExprProcessorForge {
        private final int underlyingStreamNumber;
        private final Item[] items;
        private final JsonEventType sourceType;
        private final JsonEventType resultType;

        private JsonInsertProcessorExpressions(int underlyingStreamNumber, Item[] items, JsonEventType sourceType, JsonEventType resultType) {
            this.underlyingStreamNumber = underlyingStreamNumber;
            this.items = items;
            this.sourceType = sourceType;
            this.resultType = resultType;
        }

        @Override
        public EventType getResultEventType() {
            return this.resultType;
        }

        @Override
        public CodegenMethod processCodegen(CodegenExpression resultEventType, CodegenExpression eventBeanFactory, CodegenMethodScope codegenMethodScope, SelectExprProcessorCodegenSymbol selectSymbol, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethod methodNode = codegenMethodScope.makeChild(EventBean.class, this.getClass(), (CodegenScope)codegenClassScope);
            CodegenExpressionRef refEPS = exprSymbol.getAddEPS(methodNode);
            CodegenBlock block = methodNode.getBlock().declareVar(this.sourceType.getUnderlyingType(), "src", CodegenExpressionBuilder.castUnderlying(this.sourceType.getUnderlyingType(), CodegenExpressionBuilder.arrayAtIndex(refEPS, CodegenExpressionBuilder.constant(this.underlyingStreamNumber)))).declareVar(this.resultType.getUnderlyingType(), "und", CodegenExpressionBuilder.newInstance(this.resultType.getUnderlyingType(), new CodegenExpression[0]));
            for (Item item : this.items) {
                CodegenExpression value;
                if (item.getOptionalFromField() != null) {
                    block.assignRef("und." + item.getToField().getFieldName(), (CodegenExpression)CodegenExpressionBuilder.ref("src." + item.getOptionalFromField().getFieldName()));
                    continue;
                }
                if (item.getOptionalWidener() != null) {
                    value = item.forge.evaluateCodegen(item.forge.getEvaluationType(), methodNode, exprSymbol, codegenClassScope);
                    value = item.getOptionalWidener().widenCodegen(value, methodNode, codegenClassScope);
                } else {
                    value = item.forge.evaluateCodegen(Object.class, methodNode, exprSymbol, codegenClassScope);
                }
                block.assignRef("und." + item.getToField().getFieldName(), value);
            }
            methodNode.getBlock().methodReturn(CodegenExpressionBuilder.exprDotMethod(eventBeanFactory, "adapterForTypedJson", CodegenExpressionBuilder.ref("und"), resultEventType));
            return methodNode;
        }
    }

    private static class JsonInsertProcessorStraightFieldAssign
    implements SelectExprProcessorForge {
        private final int underlyingStreamNumber;
        private final JsonEventType sourceType;
        private final JsonEventType resultType;

        private JsonInsertProcessorStraightFieldAssign(int underlyingStreamNumber, JsonEventType sourceType, JsonEventType resultType) {
            this.underlyingStreamNumber = underlyingStreamNumber;
            this.sourceType = sourceType;
            this.resultType = resultType;
        }

        @Override
        public EventType getResultEventType() {
            return this.resultType;
        }

        @Override
        public CodegenMethod processCodegen(CodegenExpression resultEventType, CodegenExpression eventBeanFactory, CodegenMethodScope codegenMethodScope, SelectExprProcessorCodegenSymbol selectSymbol, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethod methodNode = codegenMethodScope.makeChild(EventBean.class, this.getClass(), (CodegenScope)codegenClassScope);
            CodegenExpressionRef refEPS = exprSymbol.getAddEPS(methodNode);
            methodNode.getBlock().declareVar(this.resultType.getUnderlyingType(), "und", CodegenExpressionBuilder.newInstance(this.resultType.getUnderlyingType(), new CodegenExpression[0])).declareVar(this.sourceType.getUnderlyingType(), "src", CodegenExpressionBuilder.castUnderlying(this.sourceType.getUnderlyingType(), CodegenExpressionBuilder.arrayAtIndex(refEPS, CodegenExpressionBuilder.constant(this.underlyingStreamNumber))));
            for (Map.Entry<String, JsonUnderlyingField> sourceFieldEntry : this.sourceType.getDetail().getFieldDescriptors().entrySet()) {
                JsonUnderlyingField targetField = this.resultType.getDetail().getFieldDescriptors().get(sourceFieldEntry.getKey());
                methodNode.getBlock().assignRef("und." + targetField.getFieldName(), (CodegenExpression)CodegenExpressionBuilder.ref("src." + sourceFieldEntry.getValue().getFieldName()));
            }
            methodNode.getBlock().methodReturn(CodegenExpressionBuilder.exprDotMethod(eventBeanFactory, "adapterForTypedJson", CodegenExpressionBuilder.ref("und"), resultEventType));
            return methodNode;
        }
    }
}

