/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.rowrecog.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage1.spec.MatchRecognizeSkipEnum;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceMgmtCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.epl.agg.core.AggregationService;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceFactory;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogDesc;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogHelper;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogIteratorResult;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogMultimatchState;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogNFAViewFactory;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogNFAViewScheduleCallback;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogNFAViewScheduler;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogNFAViewService;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogNFAViewServiceVisitor;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogPartitionTerminationStateComparator;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogPreviousStrategy;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogPreviousStrategyImpl;
import com.espertech.esper.common.internal.epl.rowrecog.nfa.RowRecogNFAState;
import com.espertech.esper.common.internal.epl.rowrecog.nfa.RowRecogNFAStateEndEval;
import com.espertech.esper.common.internal.epl.rowrecog.nfa.RowRecogNFAStateEntry;
import com.espertech.esper.common.internal.epl.rowrecog.state.RowRecogPartitionState;
import com.espertech.esper.common.internal.epl.rowrecog.state.RowRecogPartitionStateRepo;
import com.espertech.esper.common.internal.epl.rowrecog.state.RowRecogPartitionStateRepoGroupMeta;
import com.espertech.esper.common.internal.epl.rowrecog.state.RowRecogStatePoolStmtSvc;
import com.espertech.esper.common.internal.epl.rowrecog.state.RowRecogStateRepoFactory;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventBean;
import com.espertech.esper.common.internal.event.core.ObjectArrayBackedEventBean;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowRecogNFAView
extends ViewSupport
implements AgentInstanceMgmtCallback,
RowRecogNFAViewService,
RowRecogNFAViewScheduleCallback {
    private static final Logger log = LoggerFactory.getLogger(RowRecogNFAView.class);
    private static final boolean IS_DEBUG = false;
    private final RowRecogNFAViewFactory factory;
    protected final AgentInstanceContext agentInstanceContext;
    protected final RowRecogNFAViewScheduler scheduler;
    private final RowRecogPreviousStrategyImpl rowRecogPreviousStrategy;
    private final ObjectArrayBackedEventBean compositeEventBean;
    protected RowRecogPartitionStateRepo regexPartitionStateRepo;
    private LinkedHashSet<EventBean> windowMatchedEventset;
    private final ObjectArrayBackedEventBean defineMultimatchEventBean;

    public RowRecogNFAView(RowRecogNFAViewFactory factory, AgentInstanceContext agentInstanceContext, RowRecogNFAViewScheduler scheduler) {
        this.factory = factory;
        RowRecogDesc desc = factory.getDesc();
        this.scheduler = scheduler;
        this.agentInstanceContext = agentInstanceContext;
        EventType compositeEventType = desc.getCompositeEventType();
        this.compositeEventBean = new ObjectArrayEventBean(new Object[compositeEventType.getPropertyNames().length], compositeEventType);
        EventType multimatchEventType = desc.getMultimatchEventType();
        this.defineMultimatchEventBean = multimatchEventType == null ? null : agentInstanceContext.getEventBeanTypedEventFactory().adapterForTypedObjectArray(new Object[multimatchEventType.getPropertyNames().length], multimatchEventType);
        this.windowMatchedEventset = new LinkedHashSet();
        this.rowRecogPreviousStrategy = desc.getPreviousRandomAccessIndexes() != null ? new RowRecogPreviousStrategyImpl(desc.getPreviousRandomAccessIndexes(), factory.getDesc().isUnbound()) : null;
        RowRecogStateRepoFactory repoFactory = agentInstanceContext.getRowRecogStateRepoFactory();
        RowRecogPartitionTerminationStateComparator terminationStateCompare = new RowRecogPartitionTerminationStateComparator(desc.getMultimatchStreamNumToVariable(), desc.getVariableStreams());
        if (desc.getPartitionEvalMayNull() == null) {
            this.regexPartitionStateRepo = repoFactory.makeSingle(this.rowRecogPreviousStrategy, agentInstanceContext, this, desc.isHasInterval(), terminationStateCompare);
        } else {
            RowRecogPartitionStateRepoGroupMeta stateRepoGroupMeta = new RowRecogPartitionStateRepoGroupMeta(desc.isHasInterval(), desc.getPartitionEvalMayNull(), agentInstanceContext);
            this.regexPartitionStateRepo = repoFactory.makePartitioned(this.rowRecogPreviousStrategy, stateRepoGroupMeta, agentInstanceContext, this, desc.isHasInterval(), terminationStateCompare);
        }
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        this.updateInternal(newData, oldData, true);
    }

    @Override
    public void stop(AgentInstanceStopServices services) {
        if (this.scheduler != null) {
            this.scheduler.removeSchedule();
        }
        if (this.factory.isTrackMaxStates()) {
            int size = this.regexPartitionStateRepo.getStateCount();
            RowRecogStatePoolStmtSvc poolSvc = this.agentInstanceContext.getStatementContext().getRowRecogStatePoolStmtSvc();
            poolSvc.getRuntimeSvc().decreaseCount(this.agentInstanceContext, size);
            poolSvc.getStmtHandler().decreaseCount(size);
        }
        this.regexPartitionStateRepo.destroy();
    }

    /*
     * WARNING - void declaration
     */
    private void updateInternal(EventBean[] newData, EventBean[] oldData, boolean postOutput) {
        RowRecogDesc desc = this.factory.getDesc();
        if (desc.isIterateOnly()) {
            if (oldData != null) {
                this.regexPartitionStateRepo.removeOld(oldData, false, new boolean[oldData.length]);
            }
            if (newData != null) {
                void var7_11;
                EventBean[] eventBeanArray = newData;
                int n = eventBeanArray.length;
                boolean bl = false;
                while (var7_11 < n) {
                    EventBean newEvent = eventBeanArray[var7_11];
                    RowRecogPartitionState partitionState = this.regexPartitionStateRepo.getState(newEvent, true);
                    if (partitionState != null && partitionState.getRandomAccess() != null) {
                        partitionState.getRandomAccess().newEventPrepare(newEvent);
                    }
                    ++var7_11;
                }
            }
            return;
        }
        if (oldData != null) {
            boolean isOutOfSequenceRemove = false;
            EventBean first = null;
            if (!this.windowMatchedEventset.isEmpty()) {
                first = (EventBean)this.windowMatchedEventset.iterator().next();
            }
            boolean[] blArray = new boolean[oldData.length];
            int count = 0;
            for (EventBean oldEvent : oldData) {
                boolean removed = this.windowMatchedEventset.remove(oldEvent);
                if (!removed) continue;
                if (oldEvent != first && first != null) {
                    isOutOfSequenceRemove = true;
                }
                blArray[count++] = true;
                if (this.windowMatchedEventset.isEmpty()) continue;
                first = (EventBean)this.windowMatchedEventset.iterator().next();
            }
            if (isOutOfSequenceRemove) {
                if (this.factory.isTrackMaxStates()) {
                    int size = this.regexPartitionStateRepo.getStateCount();
                    RowRecogStatePoolStmtSvc poolSvc = this.agentInstanceContext.getStatementContext().getRowRecogStatePoolStmtSvc();
                    poolSvc.getRuntimeSvc().decreaseCount(this.agentInstanceContext, size);
                    poolSvc.getStmtHandler().decreaseCount(size);
                }
                this.regexPartitionStateRepo = this.regexPartitionStateRepo.copyForIterate(true);
                Iterator<EventBean> parentEvents = this.getParent().iterator();
                RowRecogIteratorResult iteratorResult = this.processIterator(true, parentEvents, this.regexPartitionStateRepo);
                this.regexPartitionStateRepo.setEventSequenceNum(iteratorResult.getEventSequenceNum());
            } else {
                int numRemoved = this.regexPartitionStateRepo.removeOld(oldData, this.windowMatchedEventset.isEmpty(), blArray);
                if (this.factory.isTrackMaxStates()) {
                    RowRecogStatePoolStmtSvc poolSvc = this.agentInstanceContext.getStatementContext().getRowRecogStatePoolStmtSvc();
                    poolSvc.getRuntimeSvc().decreaseCount(this.agentInstanceContext, numRemoved);
                    poolSvc.getStmtHandler().decreaseCount(numRemoved);
                }
            }
        }
        if (newData == null) {
            return;
        }
        List<RowRecogNFAStateEntry> endStates = new ArrayList<RowRecogNFAStateEntry>();
        List<RowRecogNFAStateEntry> terminationStatesAll = null;
        for (EventBean newEvent : newData) {
            List<RowRecogNFAStateEntry> terminationStates;
            ArrayList<RowRecogNFAStateEntry> nextStates = new ArrayList<RowRecogNFAStateEntry>(2);
            int eventSequenceNumber = this.regexPartitionStateRepo.incrementAndGetEventSequenceNum();
            RowRecogPartitionState partitionState = this.regexPartitionStateRepo.getState(newEvent, true);
            Iterator<RowRecogNFAStateEntry> currentStatesIterator = partitionState.getCurrentStatesIterator();
            this.agentInstanceContext.getInstrumentationProvider().qRegEx(newEvent, partitionState);
            if (partitionState.getRandomAccess() != null) {
                partitionState.getRandomAccess().newEventPrepare(newEvent);
            }
            if ((terminationStates = this.step(false, currentStatesIterator, newEvent, nextStates, endStates, !desc.isUnbound(), eventSequenceNumber, partitionState.getOptionalKeys())) != null) {
                if (terminationStatesAll == null) {
                    terminationStatesAll = terminationStates;
                } else {
                    terminationStatesAll.addAll(terminationStates);
                }
            }
            partitionState.setCurrentStates(nextStates);
            this.agentInstanceContext.getInstrumentationProvider().aRegEx(partitionState, endStates, terminationStates);
        }
        if (endStates.isEmpty() && (!desc.isOrTerminated() || terminationStatesAll == null)) {
            return;
        }
        if (!desc.isAllMatches()) {
            endStates = this.rankEndStatesMultiPartition(endStates);
        }
        if (desc.isHasInterval()) {
            Iterator<RowRecogNFAStateEntry> iterator = endStates.iterator();
            while (iterator.hasNext()) {
                RowRecogNFAStateEntry endState = iterator.next();
                this.agentInstanceContext.getInstrumentationProvider().qRegIntervalState(endState, this.factory.getDesc().getVariableStreams(), this.factory.getDesc().getMultimatchStreamNumToVariable(), this.agentInstanceContext.getStatementContext().getSchedulingService().getTime());
                RowRecogPartitionState partitionState = this.regexPartitionStateRepo.getState(endState.getPartitionKey());
                if (partitionState == null) {
                    log.warn("Null partition state encountered, skipping row");
                    this.agentInstanceContext.getInstrumentationProvider().aRegIntervalState(false);
                    continue;
                }
                boolean scheduleDelivery = !desc.isOrTerminated() ? true : endState.getState().getNextStates().length != 1 || !(endState.getState().getNextStates()[0] instanceof RowRecogNFAStateEndEval);
                if (scheduleDelivery) {
                    long matchBeginTime = endState.getMatchBeginEventTime();
                    long current = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
                    long deltaFromStart = current - matchBeginTime;
                    long deltaUntil = this.computeScheduleForwardDelta(current, deltaFromStart);
                    if (this.regexPartitionStateRepo.getScheduleState().containsKey(matchBeginTime)) {
                        this.scheduleCallback(deltaUntil, endState);
                        this.agentInstanceContext.getInstrumentationProvider().aRegIntervalState(true);
                        iterator.remove();
                        continue;
                    }
                    if (deltaFromStart < deltaUntil) {
                        this.scheduleCallback(deltaUntil, endState);
                        this.agentInstanceContext.getInstrumentationProvider().aRegIntervalState(true);
                        iterator.remove();
                        continue;
                    }
                    this.agentInstanceContext.getInstrumentationProvider().aRegIntervalState(false);
                    continue;
                }
                this.agentInstanceContext.getInstrumentationProvider().aRegIntervalState(false);
            }
            if (desc.isOrTerminated() && terminationStatesAll != null) {
                for (RowRecogNFAStateEntry terminationState : terminationStatesAll) {
                    RowRecogPartitionState partitionState = this.regexPartitionStateRepo.getState(terminationState.getPartitionKey());
                    if (partitionState == null) {
                        log.warn("Null partition state encountered, skipping row");
                        continue;
                    }
                    this.removeScheduleAddEndState(terminationState, endStates);
                }
                if (!desc.isAllMatches()) {
                    endStates = this.rankEndStatesMultiPartition(endStates);
                }
            }
            if (endStates.isEmpty()) {
                return;
            }
        } else if (desc.getSkip() == MatchRecognizeSkipEnum.PAST_LAST_ROW) {
            for (RowRecogNFAStateEntry endState : endStates) {
                RowRecogPartitionState partitionState = this.regexPartitionStateRepo.getState(endState.getPartitionKey());
                if (partitionState == null) {
                    log.warn("Null partition state encountered, skipping row");
                    continue;
                }
                Iterator<RowRecogNFAStateEntry> stateIter = partitionState.getCurrentStatesIterator();
                while (stateIter.hasNext()) {
                    RowRecogNFAStateEntry currentState = stateIter.next();
                    if (currentState.getMatchBeginEventSeqNo() > endState.getMatchEndEventSeqNo()) continue;
                    stateIter.remove();
                }
            }
        } else if (desc.getSkip() == MatchRecognizeSkipEnum.TO_NEXT_ROW) {
            for (RowRecogNFAStateEntry endState : endStates) {
                RowRecogPartitionState partitionState = this.regexPartitionStateRepo.getState(endState.getPartitionKey());
                if (partitionState == null) {
                    log.warn("Null partition state encountered, skipping row");
                    continue;
                }
                Iterator<RowRecogNFAStateEntry> stateIter = partitionState.getCurrentStatesIterator();
                while (stateIter.hasNext()) {
                    RowRecogNFAStateEntry currentState = stateIter.next();
                    if (currentState.getMatchBeginEventSeqNo() > endState.getMatchBeginEventSeqNo()) continue;
                    stateIter.remove();
                }
            }
        }
        EventBean[] eventBeanArray = new EventBean[endStates.size()];
        int count = 0;
        for (RowRecogNFAStateEntry endState : endStates) {
            RowRecogPartitionState state;
            this.agentInstanceContext.getInstrumentationProvider().qRegMeasure(endState, this.factory.getDesc().getVariableStreams(), this.factory.getDesc().getMultimatchStreamNumToVariable());
            eventBeanArray[count] = this.generateOutputRow(endState);
            this.agentInstanceContext.getInstrumentationProvider().aRegMeasure(eventBeanArray[count]);
            ++count;
            if (endState.getPartitionKey() == null || !(state = this.regexPartitionStateRepo.getState(endState.getPartitionKey())).isEmptyCurrentState() || state.getRandomAccess() != null) continue;
            this.regexPartitionStateRepo.removeState(endState.getPartitionKey());
        }
        if (postOutput) {
            this.agentInstanceContext.getInstrumentationProvider().qRegOut(eventBeanArray);
            this.child.update(eventBeanArray, null);
            this.agentInstanceContext.getInstrumentationProvider().aRegOut();
        }
    }

    private long computeScheduleForwardDelta(long current, long deltaFromStart) {
        this.agentInstanceContext.getInstrumentationProvider().qRegIntervalValue();
        long result = this.factory.getDesc().getIntervalCompute().deltaAdd(current, null, true, null);
        this.agentInstanceContext.getInstrumentationProvider().aRegIntervalValue(result);
        return result - deltaFromStart;
    }

    private RowRecogNFAStateEntry rankEndStates(List<RowRecogNFAStateEntry> endStates) {
        Collections.sort(endStates, RowRecogHelper.END_STATE_COMPARATOR);
        RowRecogNFAStateEntry found = null;
        int min = Integer.MAX_VALUE;
        boolean multipleMinimums = false;
        for (RowRecogNFAStateEntry state : endStates) {
            if (state.getMatchBeginEventSeqNo() < min) {
                found = state;
                min = state.getMatchBeginEventSeqNo();
                continue;
            }
            if (state.getMatchBeginEventSeqNo() != min) continue;
            multipleMinimums = true;
        }
        if (!multipleMinimums) {
            Collections.singletonList(found);
        }
        int[] best = null;
        found = null;
        for (RowRecogNFAStateEntry state : endStates) {
            if (state.getMatchBeginEventSeqNo() != min) continue;
            if (best == null) {
                best = state.getGreedycountPerState();
                found = state;
                continue;
            }
            int[] current = state.getGreedycountPerState();
            if (!this.compare(current, best)) continue;
            best = current;
            found = state;
        }
        return found;
    }

    private boolean compare(int[] current, int[] best) {
        for (RowRecogNFAState state : this.factory.getAllStates()) {
            if (state.isGreedy() == null || !(state.isGreedy() != false ? current[state.getNodeNumFlat()] > best[state.getNodeNumFlat()] : current[state.getNodeNumFlat()] < best[state.getNodeNumFlat()])) continue;
            return true;
        }
        return false;
    }

    private RowRecogIteratorResult processIterator(boolean isOutOfSeqDelete, Iterator<EventBean> events, RowRecogPartitionStateRepo regexPartitionStateRepo) {
        ArrayList<RowRecogNFAStateEntry> endStates = new ArrayList<RowRecogNFAStateEntry>();
        int eventSequenceNumber = 0;
        while (events.hasNext()) {
            ArrayList<RowRecogNFAStateEntry> nextStates = new ArrayList<RowRecogNFAStateEntry>(2);
            EventBean theEvent = events.next();
            ++eventSequenceNumber;
            RowRecogPartitionState partitionState = regexPartitionStateRepo.getState(theEvent, false);
            Iterator<RowRecogNFAStateEntry> currentStates = partitionState.getCurrentStatesIterator();
            if (partitionState.getRandomAccess() != null) {
                partitionState.getRandomAccess().existingEventPrepare(theEvent);
            }
            this.step(!isOutOfSeqDelete, currentStates, theEvent, nextStates, endStates, false, eventSequenceNumber, partitionState.getOptionalKeys());
            partitionState.setCurrentStates(nextStates);
        }
        return new RowRecogIteratorResult(endStates, eventSequenceNumber);
    }

    @Override
    public EventType getEventType() {
        return this.factory.getDesc().getRowEventType();
    }

    @Override
    public Iterator<EventBean> iterator() {
        RowRecogPartitionStateRepo regexPartitionStateRepoNew;
        if (this.factory.getDesc().isUnbound()) {
            return CollectionUtil.NULL_EVENT_ITERATOR;
        }
        Iterator<EventBean> it = this.parent.iterator();
        RowRecogIteratorResult iteratorResult = this.processIterator(false, it, regexPartitionStateRepoNew = this.regexPartitionStateRepo.copyForIterate(false));
        List<RowRecogNFAStateEntry> endStates = iteratorResult.getEndStates();
        if (endStates.isEmpty()) {
            return CollectionUtil.NULL_EVENT_ITERATOR;
        }
        endStates = this.rankEndStatesMultiPartition(endStates);
        ArrayList<EventBean> output = new ArrayList<EventBean>();
        for (RowRecogNFAStateEntry endState : endStates) {
            output.add(this.generateOutputRow(endState));
        }
        return output.iterator();
    }

    @Override
    public void accept(RowRecogNFAViewServiceVisitor visitor) {
        this.regexPartitionStateRepo.accept(visitor);
    }

    private List<RowRecogNFAStateEntry> rankEndStatesMultiPartition(List<RowRecogNFAStateEntry> endStates) {
        List<RowRecogNFAStateEntry> entries;
        if (endStates.isEmpty()) {
            return endStates;
        }
        if (endStates.size() == 1) {
            return endStates;
        }
        if (this.factory.getDesc().getPartitionEvalMayNull() == null) {
            return this.rankEndStatesWithinPartitionByStart(endStates);
        }
        LinkedHashMap<Object, Object> perPartition = new LinkedHashMap<Object, Object>();
        for (RowRecogNFAStateEntry endState : endStates) {
            Object value = perPartition.get(endState.getPartitionKey());
            if (value == null) {
                perPartition.put(endState.getPartitionKey(), endState);
                continue;
            }
            if (value instanceof List) {
                entries = (ArrayList<RowRecogNFAStateEntry>)value;
                entries.add(endState);
                continue;
            }
            entries = new ArrayList<RowRecogNFAStateEntry>();
            entries.add((RowRecogNFAStateEntry)value);
            entries.add(endState);
            perPartition.put(endState.getPartitionKey(), entries);
        }
        ArrayList<RowRecogNFAStateEntry> finalEndStates = new ArrayList<RowRecogNFAStateEntry>();
        for (Map.Entry entry : perPartition.entrySet()) {
            if (entry.getValue() instanceof RowRecogNFAStateEntry) {
                finalEndStates.add((RowRecogNFAStateEntry)entry.getValue());
                continue;
            }
            entries = (List)entry.getValue();
            finalEndStates.addAll(this.rankEndStatesWithinPartitionByStart(entries));
        }
        return finalEndStates;
    }

    private List<RowRecogNFAStateEntry> rankEndStatesWithinPartitionByStart(List<RowRecogNFAStateEntry> endStates) {
        Integer[] keys;
        if (endStates.isEmpty()) {
            return endStates;
        }
        if (endStates.size() == 1) {
            return endStates;
        }
        RowRecogDesc rowRecogDesc = this.factory.getDesc();
        TreeMap<Integer, Object> endStatesPerBeginEvent = new TreeMap<Integer, Object>();
        for (RowRecogNFAStateEntry entry : endStates) {
            ArrayList<RowRecogNFAStateEntry> entries;
            Integer beginNum = entry.getMatchBeginEventSeqNo();
            Object value = endStatesPerBeginEvent.get(beginNum);
            if (value == null) {
                endStatesPerBeginEvent.put(beginNum, entry);
                continue;
            }
            if (value instanceof List) {
                entries = (ArrayList<RowRecogNFAStateEntry>)value;
                entries.add(entry);
                continue;
            }
            entries = new ArrayList<RowRecogNFAStateEntry>();
            entries.add((RowRecogNFAStateEntry)value);
            entries.add(entry);
            endStatesPerBeginEvent.put(beginNum, entries);
        }
        if (endStatesPerBeginEvent.size() == 1) {
            List endStatesUnranked = (List)endStatesPerBeginEvent.values().iterator().next();
            if (rowRecogDesc.isAllMatches()) {
                return endStatesUnranked;
            }
            RowRecogNFAStateEntry chosen = this.rankEndStates(endStatesUnranked);
            return Collections.singletonList(chosen);
        }
        ArrayList<RowRecogNFAStateEntry> endStatesRanked = new ArrayList<RowRecogNFAStateEntry>();
        Set keyset = endStatesPerBeginEvent.keySet();
        for (Integer key : keys = keyset.toArray(new Integer[keyset.size()])) {
            RowRecogNFAStateEntry entryTaken;
            Object value = endStatesPerBeginEvent.remove(key);
            if (value == null) continue;
            if (value instanceof List) {
                List endStatesUnranked = (List)value;
                if (endStatesUnranked.isEmpty()) continue;
                entryTaken = this.rankEndStates(endStatesUnranked);
                if (rowRecogDesc.isAllMatches()) {
                    endStatesRanked.addAll(endStatesUnranked);
                } else {
                    endStatesRanked.add(entryTaken);
                }
            } else {
                entryTaken = (RowRecogNFAStateEntry)value;
                endStatesRanked.add(entryTaken);
            }
            if (entryTaken == null) continue;
            if (rowRecogDesc.getSkip() == MatchRecognizeSkipEnum.PAST_LAST_ROW) {
                int skipPastRow = entryTaken.getMatchEndEventSeqNo();
                this.removeSkippedEndStates(endStatesPerBeginEvent, skipPastRow);
                continue;
            }
            if (rowRecogDesc.getSkip() != MatchRecognizeSkipEnum.TO_NEXT_ROW) continue;
            int skipPastRow = entryTaken.getMatchBeginEventSeqNo();
            this.removeSkippedEndStates(endStatesPerBeginEvent, skipPastRow);
        }
        return endStatesRanked;
    }

    private void removeSkippedEndStates(TreeMap<Integer, Object> endStatesPerEndEvent, int skipPastRow) {
        for (Map.Entry<Integer, Object> entry : endStatesPerEndEvent.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof List) {
                List endStatesUnranked = (List)value;
                Iterator it = endStatesUnranked.iterator();
                while (it.hasNext()) {
                    RowRecogNFAStateEntry endState = (RowRecogNFAStateEntry)it.next();
                    if (endState.getMatchBeginEventSeqNo() > skipPastRow) continue;
                    it.remove();
                }
                continue;
            }
            RowRecogNFAStateEntry endState = (RowRecogNFAStateEntry)value;
            if (endState.getMatchBeginEventSeqNo() > skipPastRow) continue;
            endStatesPerEndEvent.put(entry.getKey(), null);
        }
    }

    private List<RowRecogNFAStateEntry> step(boolean skipTrackMaxState, Iterator<RowRecogNFAStateEntry> currentStatesIterator, EventBean theEvent, List<RowRecogNFAStateEntry> nextStates, List<RowRecogNFAStateEntry> endStates, boolean isRetainEventSet, int currentEventSequenceNumber, Object partitionKey) {
        RowRecogDesc rowRecogDesc = this.factory.getDesc();
        ArrayList<RowRecogNFAStateEntry> terminationStates = null;
        while (currentStatesIterator.hasNext()) {
            RowRecogNFAState[] nextStatesFromHere;
            RowRecogNFAStateEntry currentState = currentStatesIterator.next();
            this.agentInstanceContext.getInstrumentationProvider().qRegExState(currentState, this.factory.getDesc().getVariableStreams(), this.factory.getDesc().getMultimatchStreamNumToVariable());
            if (this.factory.isTrackMaxStates() && !skipTrackMaxState) {
                RowRecogStatePoolStmtSvc poolSvc = this.agentInstanceContext.getStatementContext().getRowRecogStatePoolStmtSvc();
                poolSvc.getRuntimeSvc().decreaseCount(this.agentInstanceContext);
                poolSvc.getStmtHandler().decreaseCount();
            }
            EventBean[] eventsPerStream = currentState.getEventsPerStream();
            int currentStateStreamNum = currentState.getState().getStreamNum();
            eventsPerStream[currentStateStreamNum] = theEvent;
            if (rowRecogDesc.isDefineAsksMultimatches()) {
                eventsPerStream[rowRecogDesc.getNumEventsEventsPerStreamDefine() - 1] = this.getMultimatchState(currentState);
            }
            if (currentState.getState().matches(eventsPerStream, this.agentInstanceContext)) {
                if (isRetainEventSet) {
                    this.windowMatchedEventset.add(theEvent);
                }
                boolean copy = (nextStatesFromHere = currentState.getState().getNextStates()).length > 1;
                for (RowRecogNFAState next : nextStatesFromHere) {
                    EventBean[] eventsForState = eventsPerStream;
                    RowRecogMultimatchState[] multimatches = currentState.getOptionalMultiMatches();
                    int[] greedyCounts = currentState.getGreedycountPerState();
                    if (copy) {
                        eventsForState = new EventBean[eventsForState.length];
                        System.arraycopy(eventsPerStream, 0, eventsForState, 0, eventsForState.length);
                        int[] greedyCountsCopy = new int[greedyCounts.length];
                        System.arraycopy(greedyCounts, 0, greedyCountsCopy, 0, greedyCounts.length);
                        greedyCounts = greedyCountsCopy;
                        if (rowRecogDesc.isCollectMultimatches()) {
                            multimatches = this.deepCopy(multimatches);
                        }
                    }
                    if (rowRecogDesc.isCollectMultimatches() && currentState.getState().isMultiple()) {
                        multimatches = this.addTag(currentState.getState().getStreamNum(), theEvent, multimatches);
                        eventsForState[currentStateStreamNum] = null;
                    }
                    if (currentState.getState().isGreedy() != null && currentState.getState().isGreedy().booleanValue()) {
                        int n = currentState.getState().getNodeNumFlat();
                        greedyCounts[n] = greedyCounts[n] + 1;
                    }
                    RowRecogNFAStateEntry entry = new RowRecogNFAStateEntry(currentState.getMatchBeginEventSeqNo(), currentState.getMatchBeginEventTime(), currentState.getState(), eventsForState, greedyCounts, multimatches, partitionKey);
                    if (next instanceof RowRecogNFAStateEndEval) {
                        entry.setMatchEndEventSeqNo(currentEventSequenceNumber);
                        endStates.add(entry);
                        continue;
                    }
                    if (this.factory.isTrackMaxStates() && !skipTrackMaxState) {
                        RowRecogStatePoolStmtSvc poolSvc = this.agentInstanceContext.getStatementContext().getRowRecogStatePoolStmtSvc();
                        boolean allow = poolSvc.getRuntimeSvc().tryIncreaseCount(this.agentInstanceContext);
                        if (!allow) continue;
                        poolSvc.getStmtHandler().increaseCount();
                        entry.setState(next);
                        nextStates.add(entry);
                        continue;
                    }
                    entry.setState(next);
                    nextStates.add(entry);
                }
                this.agentInstanceContext.getInstrumentationProvider().aRegExState(nextStates, this.factory.getDesc().getVariableStreams(), this.factory.getDesc().getMultimatchStreamNumToVariable());
                continue;
            }
            this.agentInstanceContext.getInstrumentationProvider().aRegExState(Collections.emptyList(), this.factory.getDesc().getVariableStreams(), this.factory.getDesc().getMultimatchStreamNumToVariable());
            if (!rowRecogDesc.isOrTerminated()) continue;
            eventsPerStream[currentStateStreamNum] = null;
            nextStatesFromHere = currentState.getState().getNextStates();
            RowRecogNFAState theEndState = null;
            for (RowRecogNFAState next : nextStatesFromHere) {
                if (!(next instanceof RowRecogNFAStateEndEval)) continue;
                theEndState = next;
            }
            if (theEndState == null) continue;
            RowRecogNFAStateEntry entry = new RowRecogNFAStateEntry(currentState.getMatchBeginEventSeqNo(), currentState.getMatchBeginEventTime(), theEndState, eventsPerStream, currentState.getGreedycountPerState(), currentState.getOptionalMultiMatches(), partitionKey);
            if (terminationStates == null) {
                terminationStates = new ArrayList<RowRecogNFAStateEntry>();
            }
            terminationStates.add(entry);
        }
        for (RowRecogNFAState startState : this.factory.getStartStates()) {
            this.agentInstanceContext.getInstrumentationProvider().qRegExStateStart(startState, this.factory.getDesc().getVariableStreams(), this.factory.getDesc().getMultimatchStreamNumToVariable());
            EventBean[] eventsPerStream = new EventBean[rowRecogDesc.getNumEventsEventsPerStreamDefine()];
            int currentStateStreamNum = startState.getStreamNum();
            eventsPerStream[currentStateStreamNum] = theEvent;
            if (startState.matches(eventsPerStream, this.agentInstanceContext)) {
                RowRecogNFAState[] nextStatesFromHere;
                if (isRetainEventSet) {
                    this.windowMatchedEventset.add(theEvent);
                }
                boolean copy = (nextStatesFromHere = startState.getNextStates()).length > 1;
                for (RowRecogNFAState next : nextStatesFromHere) {
                    if (this.factory.isTrackMaxStates() && !skipTrackMaxState) {
                        RowRecogStatePoolStmtSvc poolSvc = this.agentInstanceContext.getStatementContext().getRowRecogStatePoolStmtSvc();
                        boolean allow = poolSvc.getRuntimeSvc().tryIncreaseCount(this.agentInstanceContext);
                        if (!allow) continue;
                        poolSvc.getStmtHandler().increaseCount();
                    }
                    EventBean[] eventsForState = eventsPerStream;
                    RowRecogMultimatchState[] multimatches = rowRecogDesc.isCollectMultimatches() ? new RowRecogMultimatchState[rowRecogDesc.getMultimatchVariablesArray().length] : null;
                    int[] greedyCounts = new int[this.factory.getAllStates().length];
                    if (copy) {
                        eventsForState = new EventBean[eventsForState.length];
                        System.arraycopy(eventsPerStream, 0, eventsForState, 0, eventsForState.length);
                        int[] greedyCountsCopy = new int[greedyCounts.length];
                        System.arraycopy(greedyCounts, 0, greedyCountsCopy, 0, greedyCounts.length);
                        greedyCounts = greedyCountsCopy;
                    }
                    if (rowRecogDesc.isCollectMultimatches() && startState.isMultiple()) {
                        multimatches = this.addTag(startState.getStreamNum(), theEvent, multimatches);
                        eventsForState[currentStateStreamNum] = null;
                    }
                    if (startState.isGreedy() != null && startState.isGreedy().booleanValue()) {
                        int n = startState.getNodeNumFlat();
                        greedyCounts[n] = greedyCounts[n] + 1;
                    }
                    long time = 0L;
                    if (rowRecogDesc.isHasInterval()) {
                        time = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
                    }
                    RowRecogNFAStateEntry entry = new RowRecogNFAStateEntry(currentEventSequenceNumber, time, startState, eventsForState, greedyCounts, multimatches, partitionKey);
                    if (next instanceof RowRecogNFAStateEndEval) {
                        entry.setMatchEndEventSeqNo(currentEventSequenceNumber);
                        endStates.add(entry);
                        continue;
                    }
                    entry.setState(next);
                    nextStates.add(entry);
                }
            }
            this.agentInstanceContext.getInstrumentationProvider().aRegExStateStart(nextStates, this.factory.getDesc().getVariableStreams(), this.factory.getDesc().getMultimatchStreamNumToVariable());
        }
        return terminationStates;
    }

    private ObjectArrayBackedEventBean getMultimatchState(RowRecogNFAStateEntry currentState) {
        if (currentState.getOptionalMultiMatches() == null || !currentState.getState().isExprRequiresMultimatchState()) {
            return null;
        }
        Object[] props = this.defineMultimatchEventBean.getProperties();
        RowRecogMultimatchState[] states = currentState.getOptionalMultiMatches();
        for (int i = 0; i < props.length; ++i) {
            RowRecogMultimatchState state = states[i];
            props[i] = state == null ? null : state.getShrinkEventArray();
        }
        return this.defineMultimatchEventBean;
    }

    private RowRecogMultimatchState[] deepCopy(RowRecogMultimatchState[] multimatchStates) {
        if (multimatchStates == null) {
            return null;
        }
        RowRecogMultimatchState[] copy = new RowRecogMultimatchState[multimatchStates.length];
        for (int i = 0; i < copy.length; ++i) {
            if (multimatchStates[i] == null) continue;
            copy[i] = new RowRecogMultimatchState(multimatchStates[i]);
        }
        return copy;
    }

    private RowRecogMultimatchState[] addTag(int streamNum, EventBean theEvent, RowRecogMultimatchState[] multimatches) {
        int index;
        RowRecogMultimatchState state;
        if (multimatches == null) {
            multimatches = new RowRecogMultimatchState[this.factory.getDesc().getMultimatchVariablesArray().length];
        }
        if ((state = multimatches[index = this.factory.getDesc().getMultimatchStreamNumToVariable()[streamNum]]) == null) {
            multimatches[index] = new RowRecogMultimatchState(theEvent);
            return multimatches;
        }
        multimatches[index].add(theEvent);
        return multimatches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventBean generateOutputRow(RowRecogNFAStateEntry entry) {
        AggregationServiceFactory[] aggregationServiceFactories = this.factory.getDesc().getAggregationServiceFactories();
        if (aggregationServiceFactories != null) {
            AggregationService[] aggregationServices = new AggregationService[aggregationServiceFactories.length];
            for (int i = 0; i < aggregationServices.length; ++i) {
                if (aggregationServiceFactories[i] == null) continue;
                aggregationServices[i] = aggregationServiceFactories[i].makeService(this.agentInstanceContext, this.agentInstanceContext.getClasspathImportServiceRuntime(), false, null, null);
                this.factory.getDesc().getAggregationResultFutureAssignables()[i].assign(aggregationServices[i]);
            }
            RowRecogNFAViewFactory rowRecogNFAViewFactory = this.factory;
            synchronized (rowRecogNFAViewFactory) {
                return this.generateOutputRowUnderLockIfRequired(entry, aggregationServices);
            }
        }
        return this.generateOutputRowUnderLockIfRequired(entry, null);
    }

    private EventBean generateOutputRowUnderLockIfRequired(RowRecogNFAStateEntry entry, AggregationService[] aggregationServices) {
        Object[] rowDataRaw = this.compositeEventBean.getProperties();
        for (Map.Entry<String, Pair<Integer, Boolean>> entry2 : this.factory.getDesc().getVariableStreams().entrySet()) {
            if (entry2.getValue().getSecond().booleanValue()) continue;
            int index = entry2.getValue().getFirst();
            rowDataRaw[index] = entry.getEventsPerStream()[index];
        }
        int[] multimatchVariableToStreamNum = this.factory.getDesc().getMultimatchVariableToStreamNum();
        if (entry.getOptionalMultiMatches() != null) {
            RowRecogMultimatchState[] rowRecogMultimatchStateArray = entry.getOptionalMultiMatches();
            for (int i = 0; i < rowRecogMultimatchStateArray.length; ++i) {
                EventBean[] multimatchEvents;
                int streamNum = multimatchVariableToStreamNum[i];
                if (rowRecogMultimatchStateArray[i] == null) {
                    rowDataRaw[streamNum] = null;
                    continue;
                }
                rowDataRaw[streamNum] = multimatchEvents = rowRecogMultimatchStateArray[i].getShrinkEventArray();
                if (aggregationServices == null || aggregationServices[streamNum] == null) continue;
                EventBean[] eventsPerStream = entry.getEventsPerStream();
                EventBean[] eventBeanArray = multimatchEvents;
                int n = eventBeanArray.length;
                for (int j = 0; j < n; ++j) {
                    EventBean multimatchEvent;
                    eventsPerStream[streamNum] = multimatchEvent = eventBeanArray[j];
                    aggregationServices[streamNum].applyEnter(eventsPerStream, null, this.agentInstanceContext);
                }
            }
        } else {
            for (int index : multimatchVariableToStreamNum) {
                rowDataRaw[index] = null;
            }
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int columnNum = 0;
        EventBean[] eventsPerStream = new EventBean[1];
        String[] columnNames = this.factory.getDesc().getColumnNames();
        for (ExprEvaluator expression : this.factory.getDesc().getColumnEvaluators()) {
            eventsPerStream[0] = this.compositeEventBean;
            Object result = expression.evaluate(eventsPerStream, true, this.agentInstanceContext);
            hashMap.put(columnNames[columnNum], result);
            ++columnNum;
        }
        return this.agentInstanceContext.getStatementContext().getEventBeanTypedEventFactory().adapterForTypedMap(hashMap, this.factory.getDesc().getRowEventType());
    }

    private void scheduleCallback(long timeDelta, RowRecogNFAStateEntry endState) {
        long matchBeginTime = endState.getMatchBeginEventTime();
        if (this.regexPartitionStateRepo.getScheduleState().isEmpty()) {
            this.regexPartitionStateRepo.getScheduleState().putOrAdd(matchBeginTime, endState);
            this.scheduler.addSchedule(timeDelta);
        } else {
            long currentFirstKey;
            boolean newEntry = this.regexPartitionStateRepo.getScheduleState().putOrAdd(matchBeginTime, endState);
            if (newEntry && (currentFirstKey = this.regexPartitionStateRepo.getScheduleState().firstKey()) > matchBeginTime) {
                this.scheduler.changeSchedule(timeDelta);
            }
        }
    }

    private void removeScheduleAddEndState(RowRecogNFAStateEntry terminationState, List<RowRecogNFAStateEntry> foundEndStates) {
        long matchBeginTime = terminationState.getMatchBeginEventTime();
        boolean removedOne = this.regexPartitionStateRepo.getScheduleState().findRemoveAddToList(matchBeginTime, terminationState, foundEndStates);
        if (removedOne && this.regexPartitionStateRepo.getScheduleState().isEmpty()) {
            this.scheduler.removeSchedule();
        }
    }

    @Override
    public void triggered() {
        long cutOffTime;
        long firstKey;
        long currentTime = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        long intervalMSec = this.computeScheduleBackwardDelta(currentTime);
        if (this.regexPartitionStateRepo.getScheduleState().isEmpty()) {
            return;
        }
        List<RowRecogNFAStateEntry> indicatables = new ArrayList<RowRecogNFAStateEntry>();
        while ((firstKey = this.regexPartitionStateRepo.getScheduleState().firstKey()) <= (cutOffTime = currentTime - intervalMSec)) {
            this.regexPartitionStateRepo.getScheduleState().removeAddRemoved(firstKey, indicatables);
            if (!this.regexPartitionStateRepo.getScheduleState().isEmpty()) continue;
            break;
        }
        if (!this.regexPartitionStateRepo.getScheduleState().isEmpty()) {
            long msecAfterCurrentTime = this.regexPartitionStateRepo.getScheduleState().firstKey() + intervalMSec - this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
            this.scheduler.addSchedule(msecAfterCurrentTime);
        }
        if (!this.factory.getDesc().isAllMatches()) {
            indicatables = this.rankEndStatesMultiPartition(indicatables);
        }
        EventBean[] outBeans = new EventBean[indicatables.size()];
        int count = 0;
        for (RowRecogNFAStateEntry endState : indicatables) {
            this.agentInstanceContext.getInstrumentationProvider().qRegMeasure(endState, this.factory.getDesc().getVariableStreams(), this.factory.getDesc().getMultimatchStreamNumToVariable());
            outBeans[count] = this.generateOutputRow(endState);
            this.agentInstanceContext.getInstrumentationProvider().aRegMeasure(outBeans[count]);
            ++count;
        }
        this.agentInstanceContext.getInstrumentationProvider().qRegOut(outBeans);
        this.child.update(outBeans, null);
        this.agentInstanceContext.getInstrumentationProvider().aRegOut();
    }

    private long computeScheduleBackwardDelta(long currentTime) {
        this.agentInstanceContext.getInstrumentationProvider().qRegIntervalValue();
        long result = this.factory.getDesc().getIntervalCompute().deltaSubtract(currentTime, null, true, null);
        this.agentInstanceContext.getInstrumentationProvider().aRegIntervalValue(result);
        return result;
    }

    @Override
    public RowRecogPreviousStrategy getPreviousEvaluationStrategy() {
        return this.rowRecogPreviousStrategy;
    }

    public RowRecogNFAViewFactory getFactory() {
        return this.factory;
    }
}

