/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.rowrecog.core;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.configuration.runtime.ConfigurationRuntimeMatchRecognize;
import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogDesc;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogNFAView;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogNFAViewSchedulerImpl;
import com.espertech.esper.common.internal.epl.rowrecog.nfa.RowRecogNFAState;
import com.espertech.esper.common.internal.epl.rowrecog.nfa.RowRecogNFAStateBase;
import com.espertech.esper.common.internal.epl.rowrecog.nfa.RowRecogNFAStateEndEval;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.View;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewFactoryContext;

public class RowRecogNFAViewFactory
implements ViewFactory {
    private RowRecogDesc desc;
    private boolean trackMaxStates;
    private RowRecogNFAState[] startStates;
    private RowRecogNFAState[] allStates;
    protected DataInputOutputSerde<Object> partitionKeySerde;
    protected int scheduleCallbackId;

    public void setDesc(RowRecogDesc desc) {
        this.desc = desc;
    }

    public void setScheduleCallbackId(int scheduleCallbackId) {
        this.scheduleCallbackId = scheduleCallbackId;
    }

    public RowRecogDesc getDesc() {
        return this.desc;
    }

    @Override
    public void setEventType(EventType eventType) {
    }

    @Override
    public EventType getEventType() {
        return this.desc.getRowEventType();
    }

    @Override
    public void init(ViewFactoryContext viewFactoryContext, EPStatementInitServices services) {
        ConfigurationRuntimeMatchRecognize matchRecognize = services.getRuntimeSettingsService().getConfigurationRuntime().getMatchRecognize();
        this.trackMaxStates = matchRecognize != null && matchRecognize.getMaxStates() != null;
        this.startStates = new RowRecogNFAState[this.desc.getStartStates().length];
        for (int i = 0; i < this.desc.getStartStates().length; ++i) {
            this.startStates[i] = this.desc.getStatesOrdered()[this.desc.getStartStates()[i]];
        }
        for (Pair<Integer, int[]> stateLink : this.desc.getNextStatesPerState()) {
            RowRecogNFAStateBase state = this.desc.getStatesOrdered()[stateLink.getFirst()];
            RowRecogNFAState[] nextStates = new RowRecogNFAState[stateLink.getSecond().length];
            state.setNextStates(nextStates);
            for (int i = 0; i < stateLink.getSecond().length; ++i) {
                int nextNum = stateLink.getSecond()[i];
                RowRecogNFAStateBase nextState = nextNum == -1 ? new RowRecogNFAStateEndEval() : this.desc.getStatesOrdered()[nextNum];
                nextStates[i] = nextState;
            }
        }
        this.allStates = this.desc.getStatesOrdered();
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        RowRecogNFAViewSchedulerImpl scheduler = null;
        if (this.desc.isHasInterval()) {
            scheduler = new RowRecogNFAViewSchedulerImpl();
        }
        RowRecogNFAView view = new RowRecogNFAView(this, agentInstanceViewFactoryContext.getAgentInstanceContext(), scheduler);
        if (scheduler != null) {
            scheduler.setScheduleCallback(agentInstanceViewFactoryContext.getAgentInstanceContext(), view);
        }
        return view;
    }

    public boolean isTrackMaxStates() {
        return this.trackMaxStates;
    }

    public RowRecogNFAState[] getStartStates() {
        return this.startStates;
    }

    public RowRecogNFAState[] getAllStates() {
        return this.allStates;
    }

    public DataInputOutputSerde<Object> getPartitionKeySerde() {
        return this.partitionKeySerde;
    }

    public int getScheduleCallbackId() {
        return this.scheduleCallbackId;
    }

    @Override
    public String getViewName() {
        return "rowrecog";
    }
}

