/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.rowrecog.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogMultimatchState;
import com.espertech.esper.common.internal.epl.rowrecog.nfa.RowRecogNFAStateEndEval;
import com.espertech.esper.common.internal.epl.rowrecog.nfa.RowRecogNFAStateEntry;
import com.espertech.esper.common.internal.epl.rowrecog.nfa.RowRecogNFAStateForge;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class RowRecogNFAViewUtil {
    protected static EventBean[] getMultimatchArray(int[] multimatchStreamNumToVariable, RowRecogNFAStateEntry state, int stream) {
        if (state.getOptionalMultiMatches() == null) {
            return null;
        }
        int index = multimatchStreamNumToVariable[stream];
        RowRecogMultimatchState multiMatches = state.getOptionalMultiMatches()[index];
        if (multiMatches == null) {
            return null;
        }
        return multiMatches.getShrinkEventArray();
    }

    protected static String printStates(List<RowRecogNFAStateEntry> states, Map<Integer, String> streamsVariables, LinkedHashMap<String, Pair<Integer, Boolean>> variableStreams, int[] multimatchStreamNumToVariable) {
        StringBuilder buf = new StringBuilder();
        String delimiter = "";
        for (RowRecogNFAStateEntry state : states) {
            buf.append(delimiter);
            buf.append(state.getState().getNodeNumNested());
            buf.append("{");
            EventBean[] eventsPerStream = state.getEventsPerStream();
            if (eventsPerStream == null) {
                buf.append("null");
            } else {
                String eventDelimiter = "";
                for (Map.Entry<Integer, String> streamVariable : streamsVariables.entrySet()) {
                    boolean single;
                    buf.append(eventDelimiter);
                    buf.append(streamVariable.getValue());
                    buf.append('=');
                    boolean bl = single = variableStreams.get(streamVariable.getValue()).getSecond() == false;
                    if (single) {
                        if (eventsPerStream[streamVariable.getKey()] == null) {
                            buf.append("null");
                        } else {
                            buf.append(eventsPerStream[streamVariable.getKey()].getUnderlying());
                        }
                    } else {
                        int streamNum = state.getState().getStreamNum();
                        int index = multimatchStreamNumToVariable[streamNum];
                        if (state.getOptionalMultiMatches() == null) {
                            buf.append("null-mm");
                        } else if (state.getOptionalMultiMatches()[index] == null) {
                            buf.append("no-entry");
                        } else {
                            buf.append("{");
                            String arrayEventDelimiter = "";
                            EventBean[] multiMatch = state.getOptionalMultiMatches()[index].getBuffer();
                            int count = state.getOptionalMultiMatches()[index].getCount();
                            for (int i = 0; i < count; ++i) {
                                buf.append(arrayEventDelimiter);
                                buf.append(multiMatch[i].getUnderlying());
                                arrayEventDelimiter = ", ";
                            }
                            buf.append("}");
                        }
                    }
                    eventDelimiter = ", ";
                }
            }
            buf.append("}");
            delimiter = ", ";
        }
        return buf.toString();
    }

    protected static String print(RowRecogNFAStateForge[] states) {
        StringWriter writer = new StringWriter();
        PrintWriter buf = new PrintWriter(writer);
        Stack<RowRecogNFAStateForge> currentStack = new Stack<RowRecogNFAStateForge>();
        RowRecogNFAViewUtil.print(Arrays.asList(states), buf, 0, currentStack);
        return writer.toString();
    }

    protected static void print(List<RowRecogNFAStateForge> states, PrintWriter writer, int indent, Stack<RowRecogNFAStateForge> currentStack) {
        for (RowRecogNFAStateForge state : states) {
            RowRecogNFAViewUtil.indent(writer, indent);
            if (currentStack.contains(state)) {
                writer.println("(self)");
                continue;
            }
            writer.println(RowRecogNFAViewUtil.printState(state));
            currentStack.push(state);
            RowRecogNFAViewUtil.print(state.getNextStates(), writer, indent + 4, currentStack);
            currentStack.pop();
        }
    }

    private static String printState(RowRecogNFAStateForge state) {
        if (state instanceof RowRecogNFAStateEndEval) {
            return "#" + state.getNodeNumNested();
        }
        return "#" + state.getNodeNumNested() + " " + state.getVariableName() + " s" + state.getStreamNum() + " defined as " + state;
    }

    private static void indent(PrintWriter writer, int indent) {
        for (int i = 0; i < indent; ++i) {
            writer.append(' ');
        }
    }
}

