/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.rowrecog.state;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogMultimatchState;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogPreviousStrategyImpl;
import com.espertech.esper.common.internal.epl.rowrecog.nfa.RowRecogNFAStateEntry;
import com.espertech.esper.common.internal.epl.rowrecog.state.RowRecogPartitionState;
import com.espertech.esper.common.internal.epl.rowrecog.state.RowRecogStateRandomAccess;
import com.espertech.esper.common.internal.epl.rowrecog.state.RowRecogStateRandomAccessImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RowRecogPartitionStateImpl
implements RowRecogPartitionState {
    private RowRecogStateRandomAccess randomAccess;
    private List<RowRecogNFAStateEntry> currentStates = new ArrayList<RowRecogNFAStateEntry>();
    private Object optionalKeys;

    public RowRecogPartitionStateImpl(RowRecogStateRandomAccess randomAccess, Object optionalKeys) {
        this.randomAccess = randomAccess;
        this.optionalKeys = optionalKeys;
    }

    public RowRecogPartitionStateImpl(RowRecogPreviousStrategyImpl getter, List<RowRecogNFAStateEntry> currentStates) {
        this(getter, currentStates, null);
    }

    public RowRecogPartitionStateImpl(RowRecogPreviousStrategyImpl getter, List<RowRecogNFAStateEntry> currentStates, Object optionalKeys) {
        if (getter != null) {
            this.randomAccess = new RowRecogStateRandomAccessImpl(getter);
        }
        this.currentStates = currentStates;
        this.optionalKeys = optionalKeys;
    }

    @Override
    public RowRecogStateRandomAccess getRandomAccess() {
        return this.randomAccess;
    }

    @Override
    public Iterator<RowRecogNFAStateEntry> getCurrentStatesIterator() {
        return this.currentStates.iterator();
    }

    @Override
    public void setCurrentStates(List<RowRecogNFAStateEntry> currentStates) {
        this.currentStates = currentStates;
    }

    @Override
    public Object getOptionalKeys() {
        return this.optionalKeys;
    }

    public void removeEventFromPrev(EventBean[] oldEvents) {
        if (this.randomAccess != null) {
            this.randomAccess.remove(oldEvents);
        }
    }

    public void removeEventFromPrev(EventBean oldEvent) {
        if (this.randomAccess != null) {
            this.randomAccess.remove(oldEvent);
        }
    }

    public int removeEventFromState(EventBean oldEvent) {
        int currentSize = this.currentStates.size();
        List<RowRecogNFAStateEntry> keepList = RowRecogPartitionStateImpl.removeEventFromState(oldEvent, this.currentStates.iterator());
        if (this.randomAccess != null) {
            this.randomAccess.remove(oldEvent);
        }
        this.currentStates = keepList;
        return currentSize - keepList.size();
    }

    @Override
    public int getNumStates() {
        return this.currentStates.size();
    }

    public void clearCurrentStates() {
        this.currentStates.clear();
    }

    @Override
    public List<RowRecogNFAStateEntry> getCurrentStatesForPrint() {
        return this.currentStates;
    }

    @Override
    public boolean isEmptyCurrentState() {
        return this.currentStates.isEmpty();
    }

    public static List<RowRecogNFAStateEntry> removeEventFromState(EventBean oldEvent, Iterator<RowRecogNFAStateEntry> states) {
        ArrayList<RowRecogNFAStateEntry> keepList = new ArrayList<RowRecogNFAStateEntry>();
        while (states.hasNext()) {
            RowRecogMultimatchState[] multimatch;
            EventBean[] state;
            RowRecogNFAStateEntry entry = states.next();
            boolean keep = true;
            for (EventBean aState : state = entry.getEventsPerStream()) {
                if (aState == null || !aState.equals(oldEvent)) continue;
                keep = false;
                break;
            }
            if (keep && (multimatch = entry.getOptionalMultiMatches()) != null) {
                for (RowRecogMultimatchState aMultimatch : multimatch) {
                    if (aMultimatch == null || !aMultimatch.containsEvent(oldEvent)) continue;
                    keep = false;
                    break;
                }
            }
            if (!keep) continue;
            keepList.add(entry);
        }
        return keepList;
    }
}

