/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.script.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.compile.stage1.spec.ExpressionScriptProvided;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoCast;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationEval;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeInnerNodeProvider;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCompare;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitorWithParent;
import com.espertech.esper.common.internal.epl.script.core.ExpressionNodeScriptCompiler;
import com.espertech.esper.common.internal.epl.script.core.ExpressionScriptCompiled;
import com.espertech.esper.common.internal.epl.script.core.ScriptCodegenFieldSharable;
import com.espertech.esper.common.internal.epl.script.core.ScriptDescriptorCompileTime;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.settings.ClasspathExtensionClassEmpty;
import com.espertech.esper.common.internal.settings.ClasspathImportException;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class ExprNodeScript
extends ExprNodeBase
implements ExprForge,
ExprEnumerationForge,
ExprNodeInnerNodeProvider {
    public static final String CONTEXT_BINDING_NAME = "epl";
    private final String defaultDialect;
    private final ExpressionScriptProvided script;
    private List<ExprNode> parameters;
    private ScriptDescriptorCompileTime scriptDescriptor;
    private EventType eventTypeCollection;

    public ExprNodeScript(String defaultDialect, ExpressionScriptProvided script, List<ExprNode> parameters) {
        this.defaultDialect = defaultDialect;
        this.script = script;
        this.parameters = parameters;
    }

    @Override
    public ExprForge getForge() {
        return this;
    }

    @Override
    public List<ExprNode> getAdditionalNodes() {
        return this.parameters;
    }

    public List<ExprNode> getParameters() {
        return this.parameters;
    }

    public String getEventTypeNameAnnotation() {
        return this.script.getOptionalEventTypeName();
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        writer.append(this.script.getName());
        ExprNodeUtilityPrint.toExpressionStringIncludeParen(this.parameters, writer);
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    public ExpressionScriptProvided getScript() {
        return this.script;
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (this == node) {
            return true;
        }
        if (node == null || this.getClass() != node.getClass()) {
            return false;
        }
        ExprNodeScript that = (ExprNodeScript)node;
        if (this.script != null ? !this.script.equals(that.script) : that.script != null) {
            return false;
        }
        return ExprNodeUtilityCompare.deepEquals(this.parameters, that.parameters);
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        Class<Object> returnType;
        if (this.script.getParameterNames().length != this.parameters.size()) {
            throw new ExprValidationException("Invalid number of parameters for script '" + this.script.getName() + "', expected " + this.script.getParameterNames().length + " parameters but received " + this.parameters.size() + " parameters");
        }
        if (!validationContext.getStatementCompileTimeService().getConfiguration().getCompiler().getScripts().isEnabled()) {
            throw new ExprValidationException("Script compilation has been disabled by configuration");
        }
        ArrayList<ExprNode> validatedParameters = new ArrayList<ExprNode>();
        for (ExprNode expr : this.parameters) {
            validatedParameters.add(ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.SCRIPTPARAMS, expr, validationContext));
        }
        ExprForge[] forges = new ExprForge[this.script.getParameterNames().length];
        for (int i = 0; i < this.script.getParameterNames().length; ++i) {
            forges[i] = ((ExprNode)validatedParameters.get(i)).getForge();
        }
        this.parameters = validatedParameters;
        Class[] parameterTypes = ExprNodeUtilityQuery.getExprResultTypes(forges);
        String dialect = this.script.getOptionalDialect() == null ? this.defaultDialect : this.script.getOptionalDialect();
        ExpressionScriptCompiled compiled = ExpressionNodeScriptCompiler.compileScript(dialect, this.script.getName(), this.script.getExpression(), this.script.getParameterNames(), parameterTypes, this.script.getCompiledBuf(), validationContext.getClasspathImportService());
        Class<Object> declaredReturnType = this.getDeclaredReturnType(this.script.getOptionalReturnTypeName(), validationContext);
        if (this.script.isOptionalReturnTypeIsArray() && declaredReturnType != null) {
            declaredReturnType = JavaClassHelper.getArrayType(declaredReturnType);
        }
        if (compiled.getKnownReturnType() == null && this.script.getOptionalReturnTypeName() == null) {
            returnType = Object.class;
        } else if (compiled.getKnownReturnType() != null) {
            if (declaredReturnType == null) {
                returnType = compiled.getKnownReturnType();
            } else {
                Class knownReturnType = compiled.getKnownReturnType();
                if (!(declaredReturnType.isArray() && knownReturnType.isArray() || JavaClassHelper.isAssignmentCompatible(knownReturnType, declaredReturnType))) {
                    throw new ExprValidationException("Return type and declared type not compatible for script '" + this.script.getName() + "', known return type is " + knownReturnType.getName() + " versus declared return type " + declaredReturnType.getName());
                }
                returnType = declaredReturnType;
            }
        } else {
            returnType = declaredReturnType;
        }
        if (returnType == null) {
            returnType = Object.class;
        }
        this.eventTypeCollection = null;
        if (this.script.getOptionalEventTypeName() != null) {
            if (returnType.isArray() && returnType.getComponentType() == EventBean.class) {
                this.eventTypeCollection = EventTypeUtility.requireEventType("Script", this.script.getName(), this.script.getOptionalEventTypeName(), validationContext.getStatementCompileTimeService().getEventTypeCompileTimeResolver());
            } else {
                throw new ExprValidationException(EventTypeUtility.disallowedAtTypeMessage());
            }
        }
        this.scriptDescriptor = new ScriptDescriptorCompileTime(this.script.getOptionalDialect(), this.script.getName(), this.script.getExpression(), this.script.getParameterNames(), this.parameters.toArray(new ExprNode[0]), returnType, this.defaultDialect);
        return null;
    }

    @Override
    public void accept(ExprNodeVisitor visitor) {
        super.accept(visitor);
        ExprNodeUtilityQuery.acceptParams(visitor, this.parameters);
    }

    @Override
    public void accept(ExprNodeVisitorWithParent visitor) {
        super.accept(visitor);
        ExprNodeUtilityQuery.acceptParams(visitor, this.parameters);
    }

    @Override
    public void acceptChildnodes(ExprNodeVisitorWithParent visitor, ExprNode parent) {
        super.acceptChildnodes(visitor, parent);
        ExprNodeUtilityQuery.acceptParams(visitor, this.parameters, this);
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return new ExprEvaluator(){

            @Override
            public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                throw ExprNodeUtilityMake.makeUnsupportedCompileTime();
            }
        };
    }

    @Override
    public Class getEvaluationType() {
        return this.scriptDescriptor.getReturnType();
    }

    @Override
    public ExprForgeConstantType getForgeConstantType() {
        return ExprForgeConstantType.NONCONST;
    }

    @Override
    public ExprNodeRenderable getForgeRenderable() {
        return this;
    }

    @Override
    public Class getComponentTypeCollection() throws ExprValidationException {
        Class returnType = this.scriptDescriptor.getReturnType();
        if (returnType.isArray()) {
            return returnType.getComponentType();
        }
        return null;
    }

    @Override
    public EventType getEventTypeCollection(StatementRawInfo statementRawInfo, StatementCompileTimeServices compileTimeServices) throws ExprValidationException {
        return this.eventTypeCollection;
    }

    @Override
    public EventType getEventTypeSingle(StatementRawInfo statementRawInfo, StatementCompileTimeServices compileTimeServices) throws ExprValidationException {
        return null;
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol symbols, CodegenClassScope codegenClassScope) {
        return CodegenLegoCast.castSafeFromObjectType(requiredType, this.makeEval("evaluate", codegenMethodScope, symbols, codegenClassScope));
    }

    @Override
    public CodegenExpression evaluateGetROCollectionEventsCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol symbols, CodegenClassScope codegenClassScope) {
        return this.makeEval("evaluateGetROCollectionEvents", codegenMethodScope, symbols, codegenClassScope);
    }

    @Override
    public CodegenExpression evaluateGetROCollectionScalarCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol symbols, CodegenClassScope codegenClassScope) {
        return this.makeEval("evaluateGetROCollectionScalar", codegenMethodScope, symbols, codegenClassScope);
    }

    @Override
    public CodegenExpression evaluateGetEventBeanCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol symbols, CodegenClassScope codegenClassScope) {
        return this.makeEval("evaluateGetEventBean", codegenMethodScope, symbols, codegenClassScope);
    }

    private CodegenExpression makeEval(String method, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol symbols, CodegenClassScope codegenClassScope) {
        CodegenExpressionField eval = this.getField(codegenClassScope);
        return CodegenExpressionBuilder.exprDotMethod(eval, method, symbols.getAddEPS(codegenMethodScope), symbols.getAddIsNewData(codegenMethodScope), symbols.getAddExprEvalCtx(codegenMethodScope));
    }

    public CodegenExpressionField getField(CodegenClassScope codegenClassScope) {
        return codegenClassScope.getPackageScope().addOrGetFieldSharable(new ScriptCodegenFieldSharable(this.scriptDescriptor, codegenClassScope));
    }

    @Override
    public ExprEnumerationEval getExprEvaluatorEnumeration() {
        throw ExprNodeUtilityMake.makeUnsupportedCompileTime();
    }

    private Class getDeclaredReturnType(String returnTypeName, ExprValidationContext validationContext) throws ExprValidationException {
        if (returnTypeName == null) {
            return null;
        }
        if (returnTypeName.equals("void")) {
            return null;
        }
        Class returnType = JavaClassHelper.getClassForSimpleName(returnTypeName, validationContext.getClasspathImportService().getClassForNameProvider());
        if (returnType != null) {
            return returnType;
        }
        if (returnTypeName.equals("EventBean")) {
            return EventBean.class;
        }
        try {
            return validationContext.getClasspathImportService().resolveClass(returnTypeName, false, ClasspathExtensionClassEmpty.INSTANCE);
        }
        catch (ClasspathImportException e1) {
            throw new ExprValidationException("Failed to resolve return type '" + returnTypeName + "' specified for script '" + this.script.getName() + "'");
        }
    }
}

