/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.script.mvel;

import com.espertech.esper.common.internal.compile.stage1.spec.ExpressionScriptProvided;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.script.core.ExpressionScriptCompiled;
import com.espertech.esper.common.internal.epl.script.mvel.ExpressionScriptCompiledMVEL;
import com.espertech.esper.common.internal.epl.script.mvel.MVELInvoker;
import com.espertech.esper.common.internal.settings.ClasspathImportService;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MVELHelper {
    private static final Logger log = LoggerFactory.getLogger(MVELHelper.class);

    public static void verifyScript(ExpressionScriptProvided script, ClasspathImportService classpathImportService) throws ExprValidationException {
        Object parserContext = MVELInvoker.newParserContext(classpathImportService);
        try {
            MVELInvoker.analysisCompile(script.getExpression(), parserContext, classpathImportService);
        }
        catch (InvocationTargetException ex) {
            throw MVELHelper.handleTargetException(script.getName(), ex);
        }
        catch (Exception ex) {
            throw MVELHelper.handleGeneralException(script.getName(), ex);
        }
        Map<String, Class> scriptRequiredInputs = MVELInvoker.getParserContextInputs(parserContext);
        for (Map.Entry<String, Class> input : scriptRequiredInputs.entrySet()) {
            int index;
            if (input.getKey().toLowerCase(Locale.ENGLISH).trim().equals("epl") || (index = CollectionUtil.findItem(script.getParameterNames(), input.getKey())) != -1) continue;
            throw new ExprValidationException("For script '" + script.getName() + "' the variable '" + input.getKey() + "' has not been declared and is not a parameter");
        }
    }

    public static ExpressionScriptCompiled compile(String scriptName, String expression, Map<String, Class> mvelInputParamTypes, ClasspathImportService classpathImportService) throws ExprValidationException {
        Object executable;
        Object parserContext = MVELInvoker.newParserContext(classpathImportService);
        MVELInvoker.setParserContextStrongTyping(parserContext);
        MVELInvoker.setParserContextInputs(parserContext, mvelInputParamTypes);
        try {
            executable = MVELInvoker.compileExpression(expression, parserContext);
        }
        catch (InvocationTargetException ex) {
            throw MVELHelper.handleTargetException(scriptName, ex);
        }
        catch (Exception ex) {
            throw MVELHelper.handleGeneralException(scriptName, ex);
        }
        return new ExpressionScriptCompiledMVEL(executable);
    }

    private static ExprValidationException handleTargetException(String scriptName, InvocationTargetException ex) {
        Throwable mvelException = ex.getTargetException();
        String message = "Exception compiling MVEL script '" + scriptName + "': " + mvelException.getMessage();
        log.info(message, mvelException);
        return new ExprValidationException(message, mvelException);
    }

    private static ExprValidationException handleGeneralException(String scriptName, Exception ex) {
        String message = "Exception compiling MVEL script '" + scriptName + "': " + ex.getMessage();
        log.info(message, (Throwable)ex);
        return new ExprValidationException(message, ex);
    }
}

