/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.spatial.quadtree.mxciffilterindex;

import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcif.MXCIFQuadTree;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcif.MXCIFQuadTreeNode;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcif.MXCIFQuadTreeNodeBranch;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcif.MXCIFQuadTreeNodeLeaf;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxciffilterindex.XYWHRectangleWValue;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcifrowindex.XYWHRectangleMultiType;
import java.util.Collection;
import java.util.function.Consumer;

public class MXCIFQuadTreeFilterIndexTraverse {
    public static void traverse(MXCIFQuadTree<Object> quadtree, Consumer<Object> consumer) {
        MXCIFQuadTreeFilterIndexTraverse.traverse(quadtree.getRoot(), consumer);
    }

    public static void traverse(MXCIFQuadTreeNode<Object> node, Consumer<Object> consumer) {
        if (node instanceof MXCIFQuadTreeNodeLeaf) {
            MXCIFQuadTreeNodeLeaf leaf = (MXCIFQuadTreeNodeLeaf)node;
            MXCIFQuadTreeFilterIndexTraverse.traverseData(leaf.getData(), consumer);
            return;
        }
        MXCIFQuadTreeNodeBranch branch = (MXCIFQuadTreeNodeBranch)node;
        MXCIFQuadTreeFilterIndexTraverse.traverseData(branch.getData(), consumer);
        MXCIFQuadTreeFilterIndexTraverse.traverse(branch.getNw(), consumer);
        MXCIFQuadTreeFilterIndexTraverse.traverse(branch.getNe(), consumer);
        MXCIFQuadTreeFilterIndexTraverse.traverse(branch.getSw(), consumer);
        MXCIFQuadTreeFilterIndexTraverse.traverse(branch.getSe(), consumer);
    }

    private static void traverseData(Object data, Consumer<Object> consumer) {
        if (data == null) {
            return;
        }
        if (!(data instanceof Collection)) {
            MXCIFQuadTreeFilterIndexTraverse.visit(data, consumer);
            return;
        }
        Collection collection = (Collection)data;
        for (Object datapoint : collection) {
            MXCIFQuadTreeFilterIndexTraverse.visit(datapoint, consumer);
        }
    }

    private static void visit(Object data, Consumer<Object> consumer) {
        XYWHRectangleMultiType multiType;
        if (data instanceof XYWHRectangleWValue) {
            consumer.accept(((XYWHRectangleWValue)data).getValue());
        } else if (data instanceof XYWHRectangleMultiType && (multiType = (XYWHRectangleMultiType)data).getMultityped() instanceof Collection) {
            Collection collection = (Collection)multiType.getMultityped();
            for (Object datapoint : collection) {
                MXCIFQuadTreeFilterIndexTraverse.visit(datapoint, consumer);
            }
        }
    }
}

