/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.spatial.quadtree.prqdrowindex;

import com.espertech.esper.common.internal.epl.spatial.quadtree.core.QuadrantEnum;
import com.espertech.esper.common.internal.epl.spatial.quadtree.pointregion.PointRegionQuadTree;
import com.espertech.esper.common.internal.epl.spatial.quadtree.pointregion.PointRegionQuadTreeNode;
import com.espertech.esper.common.internal.epl.spatial.quadtree.pointregion.PointRegionQuadTreeNodeBranch;
import com.espertech.esper.common.internal.epl.spatial.quadtree.pointregion.PointRegionQuadTreeNodeLeaf;
import com.espertech.esper.common.internal.epl.spatial.quadtree.prqdrowindex.XYPointMultiType;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class PointRegionQuadTreeRowIndexRemove {
    public static void remove(double x, double y, Object value, PointRegionQuadTree<Object> tree) {
        PointRegionQuadTreeNode<Object> root = tree.getRoot();
        PointRegionQuadTreeNode<Object> replacement = PointRegionQuadTreeRowIndexRemove.removeFromNode(x, y, value, root, tree);
        tree.setRoot(replacement);
    }

    private static PointRegionQuadTreeNode<Object> removeFromNode(double x, double y, Object value, PointRegionQuadTreeNode<Object> node, PointRegionQuadTree<Object> tree) {
        if (node instanceof PointRegionQuadTreeNodeLeaf) {
            PointRegionQuadTreeNodeLeaf leaf = (PointRegionQuadTreeNodeLeaf)node;
            boolean removed = PointRegionQuadTreeRowIndexRemove.removeFromPoints(x, y, value, leaf.getPoints());
            if (removed) {
                leaf.decCount();
                if (leaf.getCount() == 0) {
                    leaf.setPoints(null);
                }
            }
            return leaf;
        }
        PointRegionQuadTreeNodeBranch branch = (PointRegionQuadTreeNodeBranch)node;
        QuadrantEnum quadrant = node.getBb().getQuadrant(x, y);
        if (quadrant == QuadrantEnum.NW) {
            branch.setNw(PointRegionQuadTreeRowIndexRemove.removeFromNode(x, y, value, branch.getNw(), tree));
        } else if (quadrant == QuadrantEnum.NE) {
            branch.setNe(PointRegionQuadTreeRowIndexRemove.removeFromNode(x, y, value, branch.getNe(), tree));
        } else if (quadrant == QuadrantEnum.SW) {
            branch.setSw(PointRegionQuadTreeRowIndexRemove.removeFromNode(x, y, value, branch.getSw(), tree));
        } else {
            branch.setSe(PointRegionQuadTreeRowIndexRemove.removeFromNode(x, y, value, branch.getSe(), tree));
        }
        if (!(branch.getNw() instanceof PointRegionQuadTreeNodeLeaf && branch.getNe() instanceof PointRegionQuadTreeNodeLeaf && branch.getSw() instanceof PointRegionQuadTreeNodeLeaf && branch.getSe() instanceof PointRegionQuadTreeNodeLeaf)) {
            return branch;
        }
        PointRegionQuadTreeNodeLeaf nwLeaf = (PointRegionQuadTreeNodeLeaf)branch.getNw();
        PointRegionQuadTreeNodeLeaf neLeaf = (PointRegionQuadTreeNodeLeaf)branch.getNe();
        PointRegionQuadTreeNodeLeaf swLeaf = (PointRegionQuadTreeNodeLeaf)branch.getSw();
        PointRegionQuadTreeNodeLeaf seLeaf = (PointRegionQuadTreeNodeLeaf)branch.getSe();
        int total = nwLeaf.getCount() + neLeaf.getCount() + swLeaf.getCount() + seLeaf.getCount();
        if (total >= tree.getLeafCapacity()) {
            return branch;
        }
        LinkedList<XYPointMultiType> collection = new LinkedList<XYPointMultiType>();
        int count = PointRegionQuadTreeRowIndexRemove.mergeChildNodes(collection, nwLeaf.getPoints());
        count += PointRegionQuadTreeRowIndexRemove.mergeChildNodes(collection, neLeaf.getPoints());
        count += PointRegionQuadTreeRowIndexRemove.mergeChildNodes(collection, swLeaf.getPoints());
        return new PointRegionQuadTreeNodeLeaf<Object>(branch.getBb(), branch.getLevel(), collection, count += PointRegionQuadTreeRowIndexRemove.mergeChildNodes(collection, seLeaf.getPoints()));
    }

    private static boolean removeFromPoints(double x, double y, Object value, Object points) {
        if (points == null) {
            return false;
        }
        if (!(points instanceof Collection)) {
            boolean removed;
            XYPointMultiType point = (XYPointMultiType)points;
            return point.getX() == x && point.getY() == y && (removed = point.remove(value));
        }
        Collection collection = (Collection)points;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            boolean removed;
            XYPointMultiType point = (XYPointMultiType)it.next();
            if (point.getX() != x || point.getY() != y || !(removed = point.remove(value))) continue;
            if (point.isEmpty()) {
                it.remove();
            }
            return true;
        }
        return false;
    }

    private static int mergeChildNodes(Collection<XYPointMultiType> target, Object points) {
        if (points == null) {
            return 0;
        }
        if (points instanceof XYPointMultiType) {
            XYPointMultiType p = (XYPointMultiType)points;
            target.add(p);
            return p.count();
        }
        Collection coll = (Collection)points;
        int total = 0;
        for (XYPointMultiType p : coll) {
            target.add(p);
            total += p.count();
        }
        return total;
    }
}

