/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.subselect;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage1.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecBase;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecOptions;
import com.espertech.esper.common.internal.compile.stage1.spec.TableQueryStreamSpec;
import com.espertech.esper.common.internal.compile.stage2.FilterStreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.SelectClauseElementCompiled;
import com.espertech.esper.common.internal.compile.stage2.SelectClauseExprCompiledSpec;
import com.espertech.esper.common.internal.compile.stage2.SelectClauseSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompiled;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNode;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeUtil;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContextBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationMemberNameQualifiedSubquery;
import com.espertech.esper.common.internal.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.common.internal.epl.namedwindow.path.NamedWindowMetaData;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.common.internal.epl.subselect.SubselectUtil;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.epl.util.EPLValidationUtil;
import com.espertech.esper.common.internal.statement.helper.EPStatementStartMethodHelperValidate;
import com.espertech.esper.common.internal.view.access.ViewResourceDelegateExpr;
import com.espertech.esper.common.internal.view.core.ViewFactoryForge;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeArgs;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeDesc;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeUtil;
import com.espertech.esper.common.internal.view.core.ViewProcessingException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SubSelectHelperFilters {
    public static List<StmtClassForgeableFactory> handleSubselectSelectClauses(ExprSubselectNode subselect, EventType outerEventType, String outerEventTypeName, String outerStreamName, LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) throws ExprValidationException {
        EventType eventType;
        List<StmtClassForgeableFactory> additionalForgeables;
        List<ViewFactoryForge> viewForges;
        String subselecteventTypeName;
        StreamSpecCompiled filterStreamSpec;
        block19: {
            if (subselect.getSubselectNumber() == -1) {
                throw new IllegalStateException("Subselect is unassigned");
            }
            StatementSpecCompiled statementSpec = subselect.getStatementSpecCompiled();
            filterStreamSpec = statementSpec.getStreamSpecs()[0];
            try {
                String namedWindowName;
                ViewFactoryForgeDesc viewForgeDesc;
                Iterator<Map.Entry<String, Pair<EventType, String>>> namedSpec;
                ViewFactoryForgeArgs args = new ViewFactoryForgeArgs(-1, true, subselect.getSubselectNumber(), StreamSpecOptions.DEFAULT, null, statementRawInfo, services);
                StreamSpecCompiled streamSpec = statementSpec.getStreamSpecs()[0];
                if (streamSpec instanceof FilterStreamSpecCompiled) {
                    FilterStreamSpecCompiled filterStreamSpecCompiled = (FilterStreamSpecCompiled)statementSpec.getStreamSpecs()[0];
                    subselecteventTypeName = filterStreamSpecCompiled.getFilterSpecCompiled().getFilterForEventTypeName();
                    if (filterStreamSpec.getViewSpecs().length == 0) {
                        throw new ExprValidationException("Subqueries require one or more views to limit the stream, consider declaring a length or time window");
                    }
                    ViewFactoryForgeDesc viewForgeDesc2 = ViewFactoryForgeUtil.createForges(filterStreamSpecCompiled.getViewSpecs(), args, filterStreamSpecCompiled.getFilterSpecCompiled().getResultEventType());
                    viewForges = viewForgeDesc2.getForges();
                    additionalForgeables = viewForgeDesc2.getMultikeyForges();
                    eventType = viewForges.isEmpty() ? filterStreamSpecCompiled.getFilterSpecCompiled().getResultEventType() : viewForges.get(viewForges.size() - 1).getEventType();
                    subselect.setRawEventType(eventType);
                    break block19;
                }
                if (streamSpec instanceof NamedWindowConsumerStreamSpec) {
                    namedSpec = (NamedWindowConsumerStreamSpec)statementSpec.getStreamSpecs()[0];
                    NamedWindowMetaData namedWindow = ((NamedWindowConsumerStreamSpec)((Object)namedSpec)).getNamedWindow();
                    viewForgeDesc = ViewFactoryForgeUtil.createForges(((StreamSpecBase)((Object)namedSpec)).getViewSpecs(), args, namedWindow.getEventType());
                    viewForges = viewForgeDesc.getForges();
                    additionalForgeables = viewForgeDesc.getMultikeyForges();
                    subselecteventTypeName = namedWindowName = namedWindow.getEventType().getName();
                    EPLValidationUtil.validateContextName(false, namedWindowName, namedWindow.getContextName(), statementRawInfo.getContextName(), true);
                    subselect.setRawEventType(namedWindow.getEventType());
                    eventType = namedWindow.getEventType();
                    break block19;
                }
                if (streamSpec instanceof TableQueryStreamSpec) {
                    namedSpec = (TableQueryStreamSpec)statementSpec.getStreamSpecs()[0];
                    TableMetaData table = ((TableQueryStreamSpec)((Object)namedSpec)).getTable();
                    viewForgeDesc = ViewFactoryForgeUtil.createForges(((StreamSpecBase)((Object)namedSpec)).getViewSpecs(), args, table.getInternalEventType());
                    viewForges = viewForgeDesc.getForges();
                    additionalForgeables = viewForgeDesc.getMultikeyForges();
                    subselecteventTypeName = namedWindowName = table.getTableName();
                    EPLValidationUtil.validateContextName(false, namedWindowName, table.getOptionalContextName(), statementRawInfo.getContextName(), true);
                    subselect.setRawEventType(table.getInternalEventType());
                    eventType = table.getInternalEventType();
                    break block19;
                }
                throw new IllegalStateException("Unexpected stream spec " + streamSpec);
            }
            catch (ViewProcessingException ex) {
                throw new ExprValidationException("Failed to validate subexpression: " + ex.getMessage(), ex);
            }
        }
        String subexpressionStreamName = SubselectUtil.getStreamName(filterStreamSpec.getOptionalStreamName(), subselect.getSubselectNumber());
        if (filterStreamSpec instanceof NamedWindowConsumerStreamSpec | filterStreamSpec instanceof TableQueryStreamSpec) {
            EPStatementStartMethodHelperValidate.validateNoDataWindowOnNamedWindow(viewForges);
        }
        LinkedHashMap<String, Pair<EventType, String>> namesAndTypes = new LinkedHashMap<String, Pair<EventType, String>>();
        namesAndTypes.put(subexpressionStreamName, new Pair<EventType, String>(eventType, subselecteventTypeName));
        namesAndTypes.put(outerStreamName, new Pair<EventType, String>(outerEventType, outerEventTypeName));
        if (taggedEventTypes != null) {
            for (Map.Entry<String, Pair<EventType, String>> entry : taggedEventTypes.entrySet()) {
                namesAndTypes.put(entry.getKey(), new Pair<EventType, String>(entry.getValue().getFirst(), entry.getValue().getSecond()));
            }
        }
        if (arrayEventTypes != null) {
            for (Map.Entry<String, Pair<EventType, String>> entry : arrayEventTypes.entrySet()) {
                namesAndTypes.put(entry.getKey(), new Pair<EventType, String>(entry.getValue().getFirst(), entry.getValue().getSecond()));
            }
        }
        StreamTypeServiceImpl subselectTypeService = new StreamTypeServiceImpl(namesAndTypes, true, true);
        ViewResourceDelegateExpr viewResourceDelegateSubselect = new ViewResourceDelegateExpr();
        subselect.setFilterSubqueryStreamTypes(subselectTypeService);
        SelectClauseSpecCompiled selectClauseSpec = subselect.getStatementSpecCompiled().getSelectClauseCompiled();
        if (selectClauseSpec.getSelectExprList().length > 0) {
            if (selectClauseSpec.getSelectExprList().length > 1) {
                throw new ExprValidationException("Subquery multi-column select is not allowed in this context.");
            }
            SelectClauseElementCompiled element = selectClauseSpec.getSelectExprList()[0];
            if (element instanceof SelectClauseExprCompiledSpec) {
                SelectClauseExprCompiledSpec compiled = (SelectClauseExprCompiledSpec)element;
                ExprNode selectExpression = compiled.getSelectExpression();
                ExprValidationContext validationContext = new ExprValidationContextBuilder(subselectTypeService, statementRawInfo, services).withViewResourceDelegate(viewResourceDelegateSubselect).withAllowBindingConsumption(true).withMemberName(new ExprValidationMemberNameQualifiedSubquery(subselect.getSubselectNumber())).build();
                selectExpression = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.SUBQUERYSELECT, selectExpression, validationContext);
                subselect.setSelectClause(new ExprNode[]{selectExpression});
                subselect.setSelectAsNames(new String[]{compiled.getAssignedName()});
                LinkedList<ExprAggregateNode> aggExprNodes = new LinkedList<ExprAggregateNode>();
                ExprAggregateNodeUtil.getAggregatesBottomUp(selectExpression, aggExprNodes);
                if (aggExprNodes.size() > 0) {
                    for (ExprAggregateNode aggNode : aggExprNodes) {
                        List<Pair<Integer, String>> propertiesNodesAggregated = ExprNodeUtilityQuery.getExpressionProperties(aggNode, true);
                        for (Pair<Integer, String> pair : propertiesNodesAggregated) {
                            if (pair.getFirst() == 0) continue;
                            throw new ExprValidationException("Subselect aggregation function cannot aggregate across correlated properties");
                        }
                    }
                    List<Pair<Integer, String>> propertiesNotAggregated = ExprNodeUtilityQuery.getExpressionProperties(selectExpression, false);
                    for (Pair<Integer, String> pair : propertiesNotAggregated) {
                        if (pair.getFirst() != 0) continue;
                        throw new ExprValidationException("Subselect properties must all be within aggregation functions");
                    }
                }
            }
        }
        return additionalForgeables;
    }
}

