/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.subselect;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.context.activator.ViewableActivationResult;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceMgmtCallback;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.lookup.LookupStrategyDesc;
import com.espertech.esper.common.internal.epl.lookup.SubordTableLookupStrategy;
import com.espertech.esper.common.internal.epl.subselect.SubSelectFactory;
import com.espertech.esper.common.internal.epl.subselect.SubSelectFactoryResult;
import com.espertech.esper.common.internal.epl.subselect.SubSelectStrategyRealization;
import com.espertech.esper.common.internal.epl.subselect.SubselectAggregationPreprocessorBase;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SubSelectHelperStart {
    public static Map<Integer, SubSelectFactoryResult> startSubselects(Map<Integer, SubSelectFactory> subselects, AgentInstanceContext agentInstanceContext, List<AgentInstanceMgmtCallback> stopCallbacks, boolean isRecoveringResilient) {
        if (subselects == null || subselects.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Integer, SubSelectFactoryResult> subselectStrategies = new HashMap<Integer, SubSelectFactoryResult>();
        for (Map.Entry<Integer, SubSelectFactory> subselectEntry : subselects.entrySet()) {
            SubSelectFactory factory = subselectEntry.getValue();
            ViewableActivationResult subselectActivationResult = factory.getActivator().activate(agentInstanceContext, true, isRecoveringResilient);
            stopCallbacks.add(subselectActivationResult.getStopCallback());
            SubSelectStrategyRealization realization = factory.getStrategyFactory().instantiate(subselectActivationResult.getViewable(), agentInstanceContext, stopCallbacks, subselectEntry.getKey(), isRecoveringResilient);
            final SubordTableLookupStrategy lookupStrategyDefault = realization.getLookupStrategy();
            final SubselectAggregationPreprocessorBase aggregationPreprocessor = realization.getSubselectAggregationPreprocessor();
            SubordTableLookupStrategy lookupStrategy = lookupStrategyDefault;
            if (aggregationPreprocessor != null) {
                lookupStrategy = new SubordTableLookupStrategy(){

                    @Override
                    public Collection<EventBean> lookup(EventBean[] events, ExprEvaluatorContext context) {
                        Collection<EventBean> matchingEvents = lookupStrategyDefault.lookup(events, context);
                        aggregationPreprocessor.evaluate(events, matchingEvents, context);
                        return CollectionUtil.SINGLE_NULL_ROW_EVENT_SET;
                    }

                    @Override
                    public String toQueryPlan() {
                        return lookupStrategyDefault.toQueryPlan();
                    }

                    @Override
                    public LookupStrategyDesc getStrategyDesc() {
                        return lookupStrategyDefault.getStrategyDesc();
                    }
                };
            }
            SubSelectFactoryResult instance = new SubSelectFactoryResult(subselectActivationResult, realization, lookupStrategy);
            subselectStrategies.put(subselectEntry.getKey(), instance);
        }
        return subselectStrategies;
    }
}

