/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.table.compiletime;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.meta.EventTypeTypeClass;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.collection.PathException;
import com.espertech.esper.common.internal.collection.PathRegistry;
import com.espertech.esper.common.internal.collection.PathRegistryObjectType;
import com.espertech.esper.common.internal.context.module.ModuleDependenciesCompileTime;
import com.espertech.esper.common.internal.epl.table.compiletime.TableCompileTimeRegistry;
import com.espertech.esper.common.internal.epl.table.compiletime.TableCompileTimeResolver;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.epl.util.CompileTimeResolver;
import com.espertech.esper.common.internal.event.core.EventTypeNameUtil;
import java.util.Set;

public class TableCompileTimeResolverImpl
implements TableCompileTimeResolver {
    private final String moduleName;
    private final Set<String> moduleUses;
    private final TableCompileTimeRegistry compileTimeRegistry;
    private final PathRegistry<String, TableMetaData> pathTables;
    private final ModuleDependenciesCompileTime moduleDependencies;
    private final boolean isFireAndForget;

    public TableCompileTimeResolverImpl(String moduleName, Set<String> moduleUses, TableCompileTimeRegistry compileTimeRegistry, PathRegistry<String, TableMetaData> pathTables, ModuleDependenciesCompileTime moduleDependencies, boolean isFireAndForget) {
        this.moduleName = moduleName;
        this.moduleUses = moduleUses;
        this.compileTimeRegistry = compileTimeRegistry;
        this.pathTables = pathTables;
        this.moduleDependencies = moduleDependencies;
        this.isFireAndForget = isFireAndForget;
    }

    @Override
    public TableMetaData resolveTableFromEventType(EventType containedType) {
        if (containedType != null && containedType.getMetadata().getTypeClass() == EventTypeTypeClass.TABLE_INTERNAL) {
            String tableName = EventTypeNameUtil.getTableNameFromInternalTypeName(containedType.getName());
            return this.resolve(tableName);
        }
        return null;
    }

    @Override
    public TableMetaData resolve(String tableName) {
        TableMetaData metaData = this.compileTimeRegistry.getTable(tableName);
        if (metaData != null) {
            return metaData;
        }
        try {
            Pair<TableMetaData, String> data = this.pathTables.getAnyModuleExpectSingle(tableName, this.moduleUses);
            if (data != null) {
                if (!this.isFireAndForget && !NameAccessModifier.visible(data.getFirst().getTableVisibility(), data.getFirst().getTableModuleName(), this.moduleName)) {
                    return null;
                }
                this.moduleDependencies.addPathTable(tableName, data.getSecond());
                return data.getFirst();
            }
        }
        catch (PathException e) {
            throw CompileTimeResolver.makePathAmbiguous(PathRegistryObjectType.TABLE, tableName, e);
        }
        return null;
    }
}

