/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.table.compiletime;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerPlugInAggregationMultiFunction;
import com.espertech.esper.common.client.hook.aggmultifunc.AggregationMultiFunctionForge;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.epl.expression.chain.Chainable;
import com.espertech.esper.common.internal.epl.expression.chain.ChainableName;
import com.espertech.esper.common.internal.epl.expression.core.ExprConstantNodeImpl;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNode;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeImpl;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableAccessNode;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableAccessNodeKeys;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableAccessNodeSubprop;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableAccessNodeTopLevel;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableIdentNode;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableResetRowAggNode;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.common.internal.epl.table.compiletime.TableCompileTimeResolver;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetadataColumn;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetadataColumnAggregation;
import com.espertech.esper.common.internal.event.property.IndexedProperty;
import com.espertech.esper.common.internal.event.property.Property;
import com.espertech.esper.common.internal.event.property.PropertyParser;
import com.espertech.esper.common.internal.util.LazyAllocatedMap;
import com.espertech.esper.common.internal.util.StringValue;
import com.espertech.esper.common.internal.util.ValidationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class TableCompileTimeUtil {
    public static StreamTypeServiceImpl streamTypeFromTableColumn(EventType containedEventType) {
        return new StreamTypeServiceImpl(containedEventType, containedEventType.getName(), false);
    }

    public static Pair<ExprTableAccessNode, List<Chainable>> checkTableNameGetLibFunc(TableCompileTimeResolver tableService, LazyAllocatedMap<ConfigurationCompilerPlugInAggregationMultiFunction, AggregationMultiFunctionForge> plugInAggregations, String classIdent, List<Chainable> chain) {
        int index = StringValue.unescapedIndexOfDot(classIdent);
        if (index == -1) {
            TableMetaData table = tableService.resolve(classIdent);
            if (table == null) {
                return null;
            }
            String funcName = chain.get(1).getRootNameOrEmptyString();
            if (funcName.toLowerCase(Locale.ENGLISH).equals("keys")) {
                List<Chainable> subchain = chain.subList(2, chain.size());
                ExprTableAccessNodeKeys node = new ExprTableAccessNodeKeys(table.getTableName());
                return new Pair<ExprTableAccessNode, List<Chainable>>(node, subchain);
            }
            throw new ValidationException("Invalid use of table '" + classIdent + "', unrecognized use of function '" + funcName + "', expected 'keys()'");
        }
        String tableName = StringValue.unescapeDot(classIdent.substring(0, index));
        TableMetaData table = tableService.resolve(tableName);
        if (table == null) {
            return null;
        }
        String sub = classIdent.substring(index + 1, classIdent.length());
        return TableCompileTimeUtil.handleTableAccessNode(plugInAggregations, table.getTableName(), sub, chain);
    }

    public static Pair<ExprNode, List<Chainable>> getTableNodeChainable(StreamTypeService streamTypeService, List<Chainable> chainSpec, boolean allowTableAggReset, TableCompileTimeResolver tableCompileTimeResolver) throws ExprValidationException {
        TableMetaData tableMetadata;
        chainSpec = new ArrayList<Chainable>(chainSpec);
        String unresolvedPropertyName = chainSpec.get(0).getRootNameOrEmptyString();
        int tableStreamNum = streamTypeService.getStreamNumForStreamName(unresolvedPropertyName);
        if (chainSpec.size() == 2 && tableStreamNum != -1 && (tableMetadata = tableCompileTimeResolver.resolveTableFromEventType(streamTypeService.getEventTypes()[tableStreamNum])) != null && chainSpec.get(1).getRootNameOrEmptyString().toLowerCase(Locale.ENGLISH).equals("reset")) {
            if (!allowTableAggReset) {
                throw new ExprValidationException("The table aggregation'reset' method is only available for the on-merge update action");
            }
            if (!chainSpec.get(1).getParametersOrEmpty().isEmpty()) {
                throw new ExprValidationException("The table aggregation 'reset' method does not allow parameters");
            }
            ExprTableResetRowAggNode node = new ExprTableResetRowAggNode(tableMetadata, tableStreamNum);
            chainSpec.clear();
            return new Pair<ExprNode, List<Chainable>>(node, chainSpec);
        }
        StreamTableColWStreamName col = TableCompileTimeUtil.findTableColumnMayByPrefixed(streamTypeService, unresolvedPropertyName, tableCompileTimeResolver);
        if (col == null) {
            return null;
        }
        StreamTableColPair pair = col.getPair();
        if (pair.getColumn() instanceof TableMetadataColumnAggregation) {
            TableMetadataColumnAggregation agg = (TableMetadataColumnAggregation)pair.getColumn();
            Class returnType = pair.getTableMetadata().getPublicEventType().getPropertyType(pair.getColumn().getColumnName());
            ExprTableIdentNode node = new ExprTableIdentNode(pair.tableMetadata, null, unresolvedPropertyName, returnType, pair.getStreamNum(), agg.getColumnName(), agg.getColumn());
            chainSpec.remove(0);
            return new Pair<ExprNode, List<Chainable>>(node, chainSpec);
        }
        return null;
    }

    public static ExprTableIdentNode getTableIdentNode(StreamTypeService streamTypeService, String unresolvedPropertyName, String streamOrPropertyName, TableCompileTimeResolver resolver) throws ExprValidationException {
        StreamTableColWStreamName col;
        String propertyPrefixed = unresolvedPropertyName;
        if (streamOrPropertyName != null) {
            propertyPrefixed = streamOrPropertyName + "." + unresolvedPropertyName;
        }
        if ((col = TableCompileTimeUtil.findTableColumnMayByPrefixed(streamTypeService, propertyPrefixed, resolver)) == null) {
            return null;
        }
        StreamTableColPair pair = col.getPair();
        if (pair.getColumn() instanceof TableMetadataColumnAggregation) {
            TableMetadataColumnAggregation agg = (TableMetadataColumnAggregation)pair.getColumn();
            Class resultType = pair.tableMetadata.getPublicEventType().getPropertyType(agg.getColumnName());
            return new ExprTableIdentNode(pair.tableMetadata, streamOrPropertyName, unresolvedPropertyName, resultType, pair.streamNum, agg.getColumnName(), agg.getColumn());
        }
        return null;
    }

    public static Pair<ExprTableAccessNode, ExprDotNode> mapPropertyToTableNested(TableCompileTimeResolver resolver, String stream, String subproperty) {
        TableMetaData table = resolver.resolve(stream);
        Integer indexIfIndexed = null;
        if (table == null) {
            Pair<IndexedProperty, TableMetaData> pair = TableCompileTimeUtil.mapPropertyToTable(stream, resolver);
            if (pair == null) {
                return null;
            }
            table = pair.getSecond();
            indexIfIndexed = pair.getFirst().getIndex();
        }
        if (table.isKeyed() && indexIfIndexed == null) {
            return null;
        }
        if (!table.isKeyed() && indexIfIndexed != null) {
            return null;
        }
        int index = StringValue.unescapedIndexOfDot(subproperty);
        if (index == -1) {
            ExprTableAccessNodeSubprop tableNode = new ExprTableAccessNodeSubprop(table.getTableName(), subproperty);
            if (indexIfIndexed != null) {
                tableNode.addChildNode(new ExprConstantNodeImpl(indexIfIndexed));
            }
            return new Pair<ExprTableAccessNodeSubprop, Object>(tableNode, null);
        }
        ArrayList<Chainable> chainedSpecs = new ArrayList<Chainable>(1);
        chainedSpecs.add(new ChainableName(subproperty.substring(index + 1)));
        ExprTableAccessNodeSubprop tableNode = new ExprTableAccessNodeSubprop(table.getTableName(), subproperty.substring(0, index));
        if (indexIfIndexed != null) {
            tableNode.addChildNode(new ExprConstantNodeImpl(indexIfIndexed));
        }
        ExprDotNodeImpl dotNode = new ExprDotNodeImpl(chainedSpecs, false, false);
        dotNode.addChildNode(tableNode);
        return new Pair<ExprTableAccessNode, ExprDotNode>(tableNode, dotNode);
    }

    public static Pair<ExprTableAccessNode, List<Chainable>> handleTableAccessNode(LazyAllocatedMap<ConfigurationCompilerPlugInAggregationMultiFunction, AggregationMultiFunctionForge> plugInAggregations, String tableName, String sub, List<Chainable> chain) {
        ExprTableAccessNodeSubprop node = new ExprTableAccessNodeSubprop(tableName, sub);
        List<Chainable> subchain = chain.subList(1, chain.size());
        return new Pair<ExprTableAccessNode, List<Chainable>>(node, subchain);
    }

    private static StreamTableColWStreamName findTableColumnMayByPrefixed(StreamTypeService streamTypeService, String streamAndPropName, TableCompileTimeResolver resolver) throws ExprValidationException {
        int indexDot = streamAndPropName.indexOf(".");
        if (indexDot == -1) {
            StreamTableColPair pair = TableCompileTimeUtil.findTableColumnAcrossStreams(streamTypeService, streamAndPropName, resolver);
            if (pair != null) {
                return new StreamTableColWStreamName(pair, null);
            }
        } else {
            String streamName = streamAndPropName.substring(0, indexDot);
            String colName = streamAndPropName.substring(indexDot + 1);
            int streamNum = streamTypeService.getStreamNumForStreamName(streamName);
            if (streamNum == -1) {
                return null;
            }
            StreamTableColPair pair = TableCompileTimeUtil.findTableColumnForType(streamNum, streamTypeService.getEventTypes()[streamNum], colName, resolver);
            if (pair != null) {
                return new StreamTableColWStreamName(pair, streamName);
            }
        }
        return null;
    }

    private static StreamTableColPair findTableColumnAcrossStreams(StreamTypeService streamTypeService, String columnName, TableCompileTimeResolver resolver) throws ExprValidationException {
        StreamTableColPair found = null;
        for (int i = 0; i < streamTypeService.getEventTypes().length; ++i) {
            StreamTableColPair pair;
            EventType type = streamTypeService.getEventTypes()[i];
            if (type == null || (pair = TableCompileTimeUtil.findTableColumnForType(i, type, columnName, resolver)) == null) continue;
            if (found != null) {
                if (streamTypeService.isStreamZeroUnambigous() && found.getStreamNum() == 0) continue;
                throw new ExprValidationException("Ambiguous table column '" + columnName + "' should be prefixed by a stream name");
            }
            found = pair;
        }
        return found;
    }

    private static StreamTableColPair findTableColumnForType(int streamNum, EventType type, String columnName, TableCompileTimeResolver resolver) {
        TableMetadataColumn column;
        TableMetaData tableMetadata = resolver.resolveTableFromEventType(type);
        if (tableMetadata != null && (column = tableMetadata.getColumns().get(columnName)) != null) {
            return new StreamTableColPair(streamNum, column, tableMetadata);
        }
        return null;
    }

    public static ExprTableAccessNode mapPropertyToTableUnnested(String propertyName, TableCompileTimeResolver resolver) {
        TableMetaData table = resolver.resolve(propertyName);
        if (table != null) {
            return new ExprTableAccessNodeTopLevel(table.getTableName());
        }
        Pair<IndexedProperty, TableMetaData> pair = TableCompileTimeUtil.mapPropertyToTable(propertyName, resolver);
        if (pair == null) {
            return null;
        }
        ExprTableAccessNodeTopLevel tableNode = new ExprTableAccessNodeTopLevel(pair.getSecond().getTableName());
        tableNode.addChildNode(new ExprConstantNodeImpl(pair.getFirst().getIndex()));
        return tableNode;
    }

    private static Pair<IndexedProperty, TableMetaData> mapPropertyToTable(String propertyName, TableCompileTimeResolver resolver) {
        try {
            Property property = PropertyParser.parseAndWalkLaxToSimple(propertyName);
            if (!(property instanceof IndexedProperty)) {
                return null;
            }
            String name = property.getPropertyNameAtomic();
            TableMetaData table = resolver.resolve(name);
            if (table == null) {
                return null;
            }
            return new Pair<IndexedProperty, TableMetaData>((IndexedProperty)property, table);
        }
        catch (PropertyAccessException propertyAccessException) {
            return null;
        }
    }

    private static class StreamTableColWStreamName {
        private final StreamTableColPair pair;
        private final String optionalStreamName;

        private StreamTableColWStreamName(StreamTableColPair pair, String optionalStreamName) {
            this.pair = pair;
            this.optionalStreamName = optionalStreamName;
        }

        public StreamTableColPair getPair() {
            return this.pair;
        }

        public String getOptionalStreamName() {
            return this.optionalStreamName;
        }
    }

    private static class StreamTableColPair {
        private final int streamNum;
        private final TableMetadataColumn column;
        private final TableMetaData tableMetadata;

        private StreamTableColPair(int streamNum, TableMetadataColumn column, TableMetaData tableMetadata) {
            this.streamNum = streamNum;
            this.column = column;
            this.tableMetadata = tableMetadata;
        }

        public int getStreamNum() {
            return this.streamNum;
        }

        public TableMetadataColumn getColumn() {
            return this.column;
        }

        public TableMetaData getTableMetadata() {
            return this.tableMetadata;
        }
    }
}

