/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.table.compiletime;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleTableInitializeSymbol;
import java.util.HashMap;
import java.util.Map;

public abstract class TableMetadataColumn {
    private String columnName;
    private boolean key;

    public TableMetadataColumn() {
    }

    protected TableMetadataColumn(String columnName, boolean key) {
        this.columnName = columnName;
        this.key = key;
    }

    protected abstract CodegenExpression make(CodegenMethodScope var1, ModuleTableInitializeSymbol var2, CodegenClassScope var3);

    void makeSettersInline(CodegenExpressionRef col, CodegenBlock block) {
        block.exprDotMethod(col, "setKey", CodegenExpressionBuilder.constant(this.key)).exprDotMethod(col, "setColumnName", CodegenExpressionBuilder.constant(this.columnName));
    }

    public static CodegenExpression makeColumns(Map<String, TableMetadataColumn> columns, CodegenMethodScope parent, ModuleTableInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(Map.class, TableMetadataColumn.class, (CodegenScope)classScope);
        method.getBlock().declareVar(Map.class, "cols", CodegenExpressionBuilder.newInstance(HashMap.class, new CodegenExpression[0]));
        for (Map.Entry<String, TableMetadataColumn> entry : columns.entrySet()) {
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("cols"), "put", CodegenExpressionBuilder.constant(entry.getKey()), entry.getValue().make(method, symbols, classScope));
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("cols"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    public boolean isKey() {
        return this.key;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setKey(boolean key) {
        this.key = key;
    }
}

