/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.table.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.epl.table.core.Table;
import com.espertech.esper.common.internal.epl.table.core.TableMetadataInternalEventToPublic;

public class TableDeployTimeResolver {
    public static CodegenExpressionField makeTableEventToPublicField(TableMetaData table, CodegenClassScope classScope, Class generator) {
        SAIFFInitializeSymbol symbols = new SAIFFInitializeSymbol();
        CodegenMethod tableInit = classScope.getPackageScope().getInitMethod().makeChildWithScope(TableMetadataInternalEventToPublic.class, generator, (CodegenSymbolProvider)symbols, (CodegenScope)classScope).addParam(EPStatementInitServices.class, EPStatementInitServices.REF.getRef());
        CodegenExpression tableResolve = TableDeployTimeResolver.makeResolveTable(table, EPStatementInitServices.REF);
        tableInit.getBlock().methodReturn(CodegenExpressionBuilder.exprDotMethod(tableResolve, "getEventToPublic", new CodegenExpression[0]));
        return classScope.getPackageScope().addFieldUnshared(true, TableMetadataInternalEventToPublic.class, CodegenExpressionBuilder.localMethod(tableInit, EPStatementInitServices.REF));
    }

    public static CodegenExpression makeResolveTable(TableMetaData table, CodegenExpression initSvc) {
        return CodegenExpressionBuilder.staticMethod(TableDeployTimeResolver.class, "resolveTable", CodegenExpressionBuilder.constant(table.getTableName()), CodegenExpressionBuilder.constant((Object)table.getTableVisibility()), CodegenExpressionBuilder.constant(table.getTableModuleName()), initSvc);
    }

    public static Table resolveTable(String tableName, NameAccessModifier visibility, String optionalModuleName, EPStatementInitServices services) {
        String deploymentId = TableDeployTimeResolver.resolveDeploymentId(tableName, visibility, optionalModuleName, services);
        Table table = services.getTableManagementService().getTable(deploymentId, tableName);
        if (table == null) {
            throw new EPException("Failed to resolve table '" + tableName + "'");
        }
        return table;
    }

    private static String resolveDeploymentId(String tableName, NameAccessModifier visibility, String optionalModuleName, EPStatementInitServices services) {
        String deploymentId;
        if (visibility == NameAccessModifier.PRIVATE) {
            deploymentId = services.getDeploymentId();
        } else if (visibility == NameAccessModifier.PUBLIC || visibility == NameAccessModifier.PROTECTED) {
            deploymentId = services.getTablePathRegistry().getDeploymentId(tableName, optionalModuleName);
            if (deploymentId == null) {
                throw new EPException("Failed to resolve path table '" + tableName + "'");
            }
        } else {
            throw new IllegalArgumentException("Unrecognized visibility " + (Object)((Object)visibility));
        }
        return deploymentId;
    }
}

