/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.table.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.util.MultiKey;
import com.espertech.esper.common.internal.collection.MultiKeyArrayWrap;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.agg.core.AggregationRow;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.table.core.Table;
import com.espertech.esper.common.internal.epl.table.core.TableInstanceBase;
import com.espertech.esper.common.internal.epl.table.core.TableInstanceGrouped;
import com.espertech.esper.common.internal.event.core.ObjectArrayBackedEventBean;

public abstract class TableInstanceGroupedBase
extends TableInstanceBase
implements TableInstanceGrouped {
    public TableInstanceGroupedBase(Table table, AgentInstanceContext agentInstanceContext) {
        super(table, agentInstanceContext);
    }

    @Override
    public void addEvent(EventBean event) {
        this.agentInstanceContext.getInstrumentationProvider().qTableAddEvent(event);
        try {
            for (EventTable table : this.indexRepository.getTables()) {
                table.add(event, (ExprEvaluatorContext)this.agentInstanceContext);
            }
        }
        catch (EPException ex) {
            for (EventTable table : this.indexRepository.getTables()) {
                table.remove(event, (ExprEvaluatorContext)this.agentInstanceContext);
            }
            throw ex;
        }
        finally {
            this.agentInstanceContext.getInstrumentationProvider().aTableAddEvent();
        }
    }

    protected ObjectArrayBackedEventBean createRowIntoTable(Object groupKeys) {
        EventType eventType = this.table.getMetaData().getInternalEventType();
        AggregationRow aggregationRow = this.table.getAggregationRowFactory().make();
        Object[] data = new Object[eventType.getPropertyDescriptors().length];
        data[0] = aggregationRow;
        int[] groupKeyColNums = this.table.getMetaData().getKeyColNums();
        if (groupKeyColNums.length == 1) {
            data[groupKeyColNums[0]] = groupKeys instanceof MultiKeyArrayWrap ? ((MultiKeyArrayWrap)groupKeys).getArray() : groupKeys;
        } else {
            MultiKey mk = (MultiKey)groupKeys;
            for (int i = 0; i < groupKeyColNums.length; ++i) {
                data[groupKeyColNums[i]] = mk.getKey(i);
            }
        }
        ObjectArrayBackedEventBean row = this.agentInstanceContext.getEventBeanTypedEventFactory().adapterForTypedObjectArray(data, eventType);
        this.addEvent(row);
        return row;
    }
}

