/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.table.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.index.hash.PropertyHashedEventTableUnique;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanIndexItem;
import com.espertech.esper.common.internal.epl.lookupplansubord.EventTableIndexRepositoryEntry;
import com.espertech.esper.common.internal.epl.table.core.Table;
import com.espertech.esper.common.internal.epl.table.core.TableInstanceGrouped;
import com.espertech.esper.common.internal.epl.table.core.TableInstanceGroupedBase;
import com.espertech.esper.common.internal.event.core.ObjectArrayBackedEventBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class TableInstanceGroupedImpl
extends TableInstanceGroupedBase
implements TableInstanceGrouped {
    private final Map<Object, ObjectArrayBackedEventBean> rows;

    public TableInstanceGroupedImpl(Table table, AgentInstanceContext agentInstanceContext) {
        super(table, agentInstanceContext);
        PropertyHashedEventTableUnique eventTable = (PropertyHashedEventTableUnique)table.getPrimaryIndexFactory().makeEventTables(agentInstanceContext, null)[0];
        this.rows = eventTable.getPropertyIndex();
        this.indexRepository.addIndex(table.getMetaData().getKeyIndexMultiKey(), new EventTableIndexRepositoryEntry(table.getMetaData().getTableName(), table.getMetaData().getTableModuleName(), eventTable));
    }

    @Override
    public long size() {
        return this.rows.size();
    }

    @Override
    public ObjectArrayBackedEventBean getRowForGroupKey(Object groupKey) {
        return this.rows.get(groupKey);
    }

    @Override
    public Collection<EventBean> getEventCollection() {
        return this.rows.values();
    }

    @Override
    public Iterable<EventBean> getIterableTableScan() {
        return new PrimaryIndexIterable(this.rows);
    }

    @Override
    public void deleteEvent(EventBean matchingEvent) {
        this.agentInstanceContext.getInstrumentationProvider().qTableDeleteEvent(matchingEvent);
        for (EventTable table : this.indexRepository.getTables()) {
            table.remove(matchingEvent, (ExprEvaluatorContext)this.agentInstanceContext);
        }
        this.agentInstanceContext.getInstrumentationProvider().aTableDeleteEvent();
    }

    @Override
    public void addExplicitIndex(String indexName, String indexModuleName, QueryPlanIndexItem explicitIndexDesc, boolean isRecoveringResilient) throws ExprValidationException {
        this.indexRepository.validateAddExplicitIndex(indexName, indexModuleName, explicitIndexDesc, this.table.getMetaData().getInternalEventType(), new PrimaryIndexIterable(this.rows), this.getAgentInstanceContext(), isRecoveringResilient, null);
    }

    @Override
    public void removeExplicitIndex(String indexName) {
        this.indexRepository.removeExplicitIndex(indexName);
    }

    @Override
    public EventTable getIndex(String indexName) {
        if (indexName.equals(this.table.getMetaData().getTableName())) {
            return this.indexRepository.getIndexByDesc(this.table.getMetaData().getKeyIndexMultiKey());
        }
        return this.indexRepository.getExplicitIndexByName(indexName);
    }

    @Override
    public void clearInstance() {
        for (EventTable table : this.indexRepository.getTables()) {
            table.destroy();
        }
    }

    @Override
    public void destroy() {
        this.clearInstance();
    }

    @Override
    public ObjectArrayBackedEventBean getCreateRowIntoTable(Object groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        ObjectArrayBackedEventBean bean = this.rows.get(groupByKey);
        if (bean != null) {
            return bean;
        }
        return this.createRowIntoTable(groupByKey);
    }

    @Override
    public Collection<Object> getGroupKeysMayMultiKey() {
        return this.rows.keySet();
    }

    @Override
    public Collection<Object> getGroupKeys() {
        Class[] keyTypes = this.table.getMetaData().getKeyTypes();
        if (keyTypes.length == 1 && !keyTypes[0].isArray()) {
            return this.rows.keySet();
        }
        ArrayList<Object> keys = new ArrayList<Object>(this.rows.size());
        if (keyTypes.length == 1) {
            int col = this.table.getMetaData().getKeyColNums()[0];
            for (ObjectArrayBackedEventBean bean : this.rows.values()) {
                keys.add(bean.getProperties()[col]);
            }
        } else {
            int[] cols = this.table.getMetaData().getKeyColNums();
            for (ObjectArrayBackedEventBean bean : this.rows.values()) {
                Object[] mk = new Object[cols.length];
                for (int i = 0; i < cols.length; ++i) {
                    mk[i] = bean.getProperties()[cols[i]];
                }
                keys.add(mk);
            }
        }
        return keys;
    }

    @Override
    public void handleRowUpdated(ObjectArrayBackedEventBean updatedEvent) {
        if (this.agentInstanceContext.getInstrumentationProvider().activated()) {
            this.agentInstanceContext.getInstrumentationProvider().qTableUpdatedEvent(updatedEvent);
            this.agentInstanceContext.getInstrumentationProvider().aTableUpdatedEvent();
        }
    }

    @Override
    public void handleRowUpdateKeyBeforeUpdate(ObjectArrayBackedEventBean updatedEvent) {
        this.agentInstanceContext.getInstrumentationProvider().qaTableUpdatedEventWKeyBefore(updatedEvent);
    }

    @Override
    public void handleRowUpdateKeyAfterUpdate(ObjectArrayBackedEventBean updatedEvent) {
        this.agentInstanceContext.getInstrumentationProvider().qaTableUpdatedEventWKeyAfter(updatedEvent);
    }

    private static class PrimaryIndexIterable
    implements Iterable<EventBean> {
        private final Map<Object, ObjectArrayBackedEventBean> rows;

        private PrimaryIndexIterable(Map<Object, ObjectArrayBackedEventBean> rows) {
            this.rows = rows;
        }

        @Override
        public Iterator<EventBean> iterator() {
            return this.rows.values().iterator();
        }
    }
}

