/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.table.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.epl.table.core.Table;
import com.espertech.esper.common.internal.epl.table.core.TableInstance;
import com.espertech.esper.common.internal.epl.table.core.TableMetadataInternalEventToPublic;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import java.util.Iterator;

public class TableInstanceViewable
extends ViewSupport {
    private final Table tableMetadata;
    private final TableInstance tableStateInstance;

    public TableInstanceViewable(Table tableMetadata, TableInstance tableStateInstance) {
        this.tableMetadata = tableMetadata;
        this.tableStateInstance = tableStateInstance;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
    }

    @Override
    public EventType getEventType() {
        return this.tableMetadata.getMetaData().getPublicEventType();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return new TableToPublicIterator(this.tableStateInstance);
    }

    private static class TableToPublicIterator
    implements Iterator<EventBean> {
        private final TableMetadataInternalEventToPublic eventToPublic;
        private final Iterator<EventBean> iterator;
        private final TableInstance tableStateInstance;

        private TableToPublicIterator(TableInstance tableStateInstance) {
            this.eventToPublic = tableStateInstance.getTable().getEventToPublic();
            this.iterator = tableStateInstance.getEventCollection().iterator();
            this.tableStateInstance = tableStateInstance;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public EventBean next() {
            EventBean event = this.iterator.next();
            return this.eventToPublic.convert(event, null, true, this.tableStateInstance.getAgentInstanceContext());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

