/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.util;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecCategory;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecCategoryItem;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecCondition;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecConditionCrontab;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecConditionFilter;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecInitiatedTerminated;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecKeyed;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecKeyedItem;
import com.espertech.esper.common.internal.compile.stage1.spec.FilterSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.FilterStreamSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.ForClauseItemSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.GroupByClauseElement;
import com.espertech.esper.common.internal.compile.stage1.spec.GroupByClauseElementCombinedExpr;
import com.espertech.esper.common.internal.compile.stage1.spec.GroupByClauseElementExpr;
import com.espertech.esper.common.internal.compile.stage1.spec.GroupByClauseElementGroupingSet;
import com.espertech.esper.common.internal.compile.stage1.spec.GroupByClauseElementRollupOrCube;
import com.espertech.esper.common.internal.compile.stage1.spec.MatchRecognizeDefineItem;
import com.espertech.esper.common.internal.compile.stage1.spec.MatchRecognizeMeasureItem;
import com.espertech.esper.common.internal.compile.stage1.spec.MethodStreamSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeAction;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeActionInsert;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeActionUpdate;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeMatched;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerSetAssignment;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerSetDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerSplitStream;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerSplitStreamDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerWindowUpdateDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.OrderByItem;
import com.espertech.esper.common.internal.compile.stage1.spec.OuterJoinDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.PatternStreamSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.PropertyEvalAtom;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseElementRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseExprRawSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.StatementSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.ViewSpec;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalForgeNode;
import com.espertech.esper.common.internal.epl.pattern.filter.EvalFilterForgeNode;
import java.util.ArrayList;
import java.util.List;

public class StatementSpecRawWalkerExpr {
    public static List<ExprNode> collectExpressionsShallow(StatementSpecRaw raw) {
        Object expr;
        ArrayList<ExprNode> expressions = new ArrayList<ExprNode>();
        if (raw.getCreateContextDesc() != null) {
            ContextSpec detail = raw.getCreateContextDesc().getContextDetail();
            if (detail instanceof ContextSpecKeyed) {
                ContextSpecKeyed contextSpecKeyed = (ContextSpecKeyed)detail;
                for (ContextSpecKeyedItem contextSpecKeyedItem : contextSpecKeyed.getItems()) {
                    if (contextSpecKeyedItem.getFilterSpecRaw().getFilterExpressions() == null) continue;
                    expressions.addAll(contextSpecKeyedItem.getFilterSpecRaw().getFilterExpressions());
                }
                if (contextSpecKeyed.getOptionalInit() != null) {
                    for (ContextSpecConditionFilter contextSpecConditionFilter : contextSpecKeyed.getOptionalInit()) {
                        StatementSpecRawWalkerExpr.collectExpressions(expressions, contextSpecConditionFilter);
                    }
                }
                if (contextSpecKeyed.getOptionalTermination() != null) {
                    StatementSpecRawWalkerExpr.collectExpressions(expressions, contextSpecKeyed.getOptionalTermination());
                }
            } else if (detail instanceof ContextSpecCategory) {
                ContextSpecCategory contextSpecCategory = (ContextSpecCategory)detail;
                for (ContextSpecCategoryItem contextSpecCategoryItem : contextSpecCategory.getItems()) {
                    if (contextSpecCategoryItem.getExpression() == null) continue;
                    expressions.add(contextSpecCategoryItem.getExpression());
                }
                if (contextSpecCategory.getFilterSpecRaw().getFilterExpressions() != null) {
                    expressions.addAll(contextSpecCategory.getFilterSpecRaw().getFilterExpressions());
                }
            } else if (detail instanceof ContextSpecInitiatedTerminated) {
                ContextSpecInitiatedTerminated contextSpecInitiatedTerminated = (ContextSpecInitiatedTerminated)detail;
                StatementSpecRawWalkerExpr.collectExpressions(expressions, contextSpecInitiatedTerminated.getStartCondition());
                StatementSpecRawWalkerExpr.collectExpressions(expressions, contextSpecInitiatedTerminated.getEndCondition());
            } else {
                throw new EPException("Failed to obtain expressions from context detail " + detail);
            }
        }
        if (raw.getCreateVariableDesc() != null && (expr = raw.getCreateVariableDesc().getAssignment()) != null) {
            expressions.add((ExprNode)expr);
        }
        if (raw.getCreateWindowDesc() != null) {
            expr = raw.getCreateWindowDesc().getInsertFilter();
            if (expr != null) {
                expressions.add((ExprNode)expr);
            }
            for (ViewSpec viewSpec : raw.getCreateWindowDesc().getViewSpecs()) {
                expressions.addAll(viewSpec.getObjectParameters());
            }
        }
        if (raw.getUpdateDesc() != null) {
            if (raw.getUpdateDesc().getOptionalWhereClause() != null) {
                expressions.add(raw.getUpdateDesc().getOptionalWhereClause());
            }
            if (raw.getUpdateDesc().getAssignments() != null) {
                for (OnTriggerSetAssignment onTriggerSetAssignment : raw.getUpdateDesc().getAssignments()) {
                    expressions.add(onTriggerSetAssignment.getExpression());
                }
            }
        }
        if (raw.getOnTriggerDesc() != null) {
            OnTriggerWindowUpdateDesc onUpdate;
            OnTriggerSetDesc onSet;
            if (raw.getOnTriggerDesc() instanceof OnTriggerSplitStreamDesc) {
                OnTriggerSplitStreamDesc onSplit = (OnTriggerSplitStreamDesc)raw.getOnTriggerDesc();
                for (OnTriggerSplitStream onTriggerSplitStream : onSplit.getSplitStreams()) {
                    if (onTriggerSplitStream.getSelectClause() != null) {
                        StatementSpecRawWalkerExpr.addSelectClause(expressions, onTriggerSplitStream.getSelectClause().getSelectExprList());
                    }
                    if (onTriggerSplitStream.getWhereClause() == null) continue;
                    expressions.add(onTriggerSplitStream.getWhereClause());
                }
            }
            if (raw.getOnTriggerDesc() instanceof OnTriggerSetDesc && (onSet = (OnTriggerSetDesc)raw.getOnTriggerDesc()).getAssignments() != null) {
                for (OnTriggerSetAssignment onTriggerSetAssignment : onSet.getAssignments()) {
                    expressions.add(onTriggerSetAssignment.getExpression());
                }
            }
            if (raw.getOnTriggerDesc() instanceof OnTriggerWindowUpdateDesc && (onUpdate = (OnTriggerWindowUpdateDesc)raw.getOnTriggerDesc()).getAssignments() != null) {
                for (OnTriggerSetAssignment onTriggerSetAssignment : onUpdate.getAssignments()) {
                    expressions.add(onTriggerSetAssignment.getExpression());
                }
            }
            if (raw.getOnTriggerDesc() instanceof OnTriggerMergeDesc) {
                OnTriggerMergeDesc onMerge = (OnTriggerMergeDesc)raw.getOnTriggerDesc();
                for (OnTriggerMergeMatched onTriggerMergeMatched : onMerge.getItems()) {
                    if (onTriggerMergeMatched.getOptionalMatchCond() != null) {
                        expressions.add(onTriggerMergeMatched.getOptionalMatchCond());
                    }
                    for (OnTriggerMergeAction action : onTriggerMergeMatched.getActions()) {
                        if (action.getOptionalWhereClause() != null) {
                            expressions.add(action.getOptionalWhereClause());
                        }
                        if (action instanceof OnTriggerMergeActionUpdate) {
                            OnTriggerMergeActionUpdate onTriggerMergeActionUpdate = (OnTriggerMergeActionUpdate)action;
                            for (OnTriggerSetAssignment assignment : onTriggerMergeActionUpdate.getAssignments()) {
                                expressions.add(assignment.getExpression());
                            }
                            continue;
                        }
                        if (!(action instanceof OnTriggerMergeActionInsert)) continue;
                        OnTriggerMergeActionInsert onTriggerMergeActionInsert = (OnTriggerMergeActionInsert)action;
                        StatementSpecRawWalkerExpr.addSelectClause(expressions, onTriggerMergeActionInsert.getSelectClause());
                    }
                }
                if (onMerge.getOptionalInsertNoMatch() != null) {
                    StatementSpecRawWalkerExpr.addSelectClause(expressions, onMerge.getOptionalInsertNoMatch().getSelectClause());
                }
            }
        }
        if (raw.getSelectClauseSpec() != null) {
            StatementSpecRawWalkerExpr.addSelectClause(expressions, raw.getSelectClauseSpec().getSelectExprList());
        }
        if (raw.getStreamSpecs() != null) {
            for (StreamSpecRaw streamSpecRaw : raw.getStreamSpecs()) {
                MethodStreamSpec methodStreamSpec;
                if (streamSpecRaw instanceof FilterStreamSpecRaw) {
                    FilterStreamSpecRaw filterStreamSpecRaw = (FilterStreamSpecRaw)streamSpecRaw;
                    FilterSpecRaw filterSpecRaw = filterStreamSpecRaw.getRawFilterSpec();
                    if (filterSpecRaw != null && filterSpecRaw.getFilterExpressions() != null) {
                        expressions.addAll(filterSpecRaw.getFilterExpressions());
                    }
                    if (filterSpecRaw != null && filterSpecRaw.getOptionalPropertyEvalSpec() != null) {
                        for (PropertyEvalAtom propertyEvalAtom : filterSpecRaw.getOptionalPropertyEvalSpec().getAtoms()) {
                            StatementSpecRawWalkerExpr.addSelectClause(expressions, propertyEvalAtom.getOptionalSelectClause() == null ? null : propertyEvalAtom.getOptionalSelectClause().getSelectExprList());
                            if (propertyEvalAtom.getOptionalWhereClause() == null) continue;
                            expressions.add(propertyEvalAtom.getOptionalWhereClause());
                        }
                    }
                }
                if (streamSpecRaw instanceof PatternStreamSpecRaw) {
                    PatternStreamSpecRaw patternStreamSpecRaw = (PatternStreamSpecRaw)streamSpecRaw;
                    StatementSpecRawWalkerExpr.collectPatternExpressions(expressions, patternStreamSpecRaw.getEvalForgeNode());
                }
                if (streamSpecRaw instanceof MethodStreamSpec && (methodStreamSpec = (MethodStreamSpec)streamSpecRaw).getExpressions() != null) {
                    expressions.addAll(methodStreamSpec.getExpressions());
                }
                if (streamSpecRaw.getViewSpecs() == null) continue;
                for (ViewSpec viewSpec : streamSpecRaw.getViewSpecs()) {
                    expressions.addAll(viewSpec.getObjectParameters());
                }
            }
            if (raw.getOuterJoinDescList() != null) {
                for (OuterJoinDesc outerJoinDesc : raw.getOuterJoinDescList()) {
                    if (outerJoinDesc.getOptLeftNode() == null) continue;
                    expressions.add(outerJoinDesc.getOptLeftNode());
                    expressions.add(outerJoinDesc.getOptRightNode());
                    for (ExprIdentNode exprIdentNode : outerJoinDesc.getAdditionalLeftNodes()) {
                        expressions.add(exprIdentNode);
                    }
                    for (ExprIdentNode exprIdentNode : outerJoinDesc.getAdditionalRightNodes()) {
                        expressions.add(exprIdentNode);
                    }
                }
            }
        }
        if (raw.getWhereClause() != null) {
            expressions.add(raw.getWhereClause());
        }
        if (raw.getGroupByExpressions() != null) {
            for (GroupByClauseElement groupByClauseElement : raw.getGroupByExpressions()) {
                if (groupByClauseElement instanceof GroupByClauseElementExpr) {
                    expressions.add(((GroupByClauseElementExpr)groupByClauseElement).getExpr());
                    continue;
                }
                if (groupByClauseElement instanceof GroupByClauseElementRollupOrCube) {
                    GroupByClauseElementRollupOrCube groupByClauseElementRollupOrCube = (GroupByClauseElementRollupOrCube)groupByClauseElement;
                    StatementSpecRawWalkerExpr.analyzeRollup(groupByClauseElementRollupOrCube, expressions);
                    continue;
                }
                GroupByClauseElementGroupingSet groupByClauseElementGroupingSet = (GroupByClauseElementGroupingSet)groupByClauseElement;
                for (GroupByClauseElement inner : groupByClauseElementGroupingSet.getElements()) {
                    if (inner instanceof GroupByClauseElementExpr) {
                        expressions.add(((GroupByClauseElementExpr)inner).getExpr());
                        continue;
                    }
                    if (inner instanceof GroupByClauseElementCombinedExpr) {
                        expressions.addAll(((GroupByClauseElementCombinedExpr)inner).getExpressions());
                        continue;
                    }
                    StatementSpecRawWalkerExpr.analyzeRollup((GroupByClauseElementRollupOrCube)inner, expressions);
                }
            }
        }
        if (raw.getHavingClause() != null) {
            expressions.add(raw.getHavingClause());
        }
        if (raw.getOutputLimitSpec() != null) {
            if (raw.getOutputLimitSpec().getWhenExpressionNode() != null) {
                expressions.add(raw.getOutputLimitSpec().getWhenExpressionNode());
            }
            if (raw.getOutputLimitSpec().getThenExpressions() != null) {
                for (OnTriggerSetAssignment onTriggerSetAssignment : raw.getOutputLimitSpec().getThenExpressions()) {
                    expressions.add(onTriggerSetAssignment.getExpression());
                }
            }
            if (raw.getOutputLimitSpec().getCrontabAtSchedule() != null) {
                expressions.addAll(raw.getOutputLimitSpec().getCrontabAtSchedule());
            }
            if (raw.getOutputLimitSpec().getTimePeriodExpr() != null) {
                expressions.add(raw.getOutputLimitSpec().getTimePeriodExpr());
            }
            if (raw.getOutputLimitSpec().getAfterTimePeriodExpr() != null) {
                expressions.add(raw.getOutputLimitSpec().getAfterTimePeriodExpr());
            }
        }
        if (raw.getOrderByList() != null) {
            for (OrderByItem orderByItem : raw.getOrderByList()) {
                expressions.add(orderByItem.getExprNode());
            }
        }
        if (raw.getMatchRecognizeSpec() != null) {
            if (raw.getMatchRecognizeSpec().getPartitionByExpressions() != null) {
                expressions.addAll(raw.getMatchRecognizeSpec().getPartitionByExpressions());
            }
            for (MatchRecognizeMeasureItem matchRecognizeMeasureItem : raw.getMatchRecognizeSpec().getMeasures()) {
                expressions.add(matchRecognizeMeasureItem.getExpr());
            }
            for (MatchRecognizeDefineItem matchRecognizeDefineItem : raw.getMatchRecognizeSpec().getDefines()) {
                expressions.add(matchRecognizeDefineItem.getExpression());
            }
            if (raw.getMatchRecognizeSpec().getInterval() != null && raw.getMatchRecognizeSpec().getInterval().getTimePeriodExpr() != null) {
                expressions.add(raw.getMatchRecognizeSpec().getInterval().getTimePeriodExpr());
            }
        }
        if (raw.getForClauseSpec() != null) {
            for (ForClauseItemSpec forClauseItemSpec : raw.getForClauseSpec().getClauses()) {
                if (forClauseItemSpec.getExpressions() == null) continue;
                expressions.addAll(forClauseItemSpec.getExpressions());
            }
        }
        return expressions;
    }

    private static void analyzeRollup(GroupByClauseElementRollupOrCube rollup, List<ExprNode> expressions) {
        for (GroupByClauseElement ex : rollup.getRollupExpressions()) {
            if (ex instanceof GroupByClauseElementExpr) {
                expressions.add(((GroupByClauseElementExpr)ex).getExpr());
                continue;
            }
            GroupByClauseElementCombinedExpr combined = (GroupByClauseElementCombinedExpr)ex;
            expressions.addAll(combined.getExpressions());
        }
    }

    private static void addSelectClause(List<ExprNode> expressions, List<SelectClauseElementRaw> selectClause) {
        if (selectClause == null) {
            return;
        }
        for (SelectClauseElementRaw selement : selectClause) {
            if (!(selement instanceof SelectClauseExprRawSpec)) continue;
            SelectClauseExprRawSpec sexpr = (SelectClauseExprRawSpec)selement;
            expressions.add(sexpr.getSelectExpression());
        }
    }

    private static void collectPatternExpressions(List<ExprNode> expressions, EvalForgeNode patternExpression) {
        EvalFilterForgeNode filter;
        if (patternExpression instanceof EvalFilterForgeNode && (filter = (EvalFilterForgeNode)patternExpression).getRawFilterSpec().getFilterExpressions() != null) {
            expressions.addAll(filter.getRawFilterSpec().getFilterExpressions());
        }
        for (EvalForgeNode child : patternExpression.getChildNodes()) {
            StatementSpecRawWalkerExpr.collectPatternExpressions(expressions, child);
        }
    }

    private static void collectExpressions(List<ExprNode> expressions, ContextSpecCondition endpoint) {
        if (endpoint instanceof ContextSpecConditionCrontab) {
            ContextSpecConditionCrontab crontab = (ContextSpecConditionCrontab)endpoint;
            for (List<ExprNode> crontabItem : crontab.getCrontabs()) {
                expressions.addAll(crontabItem);
            }
        }
    }
}

