/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.variable.core;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerSetAssignment;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.assign.ExprAssignment;
import com.espertech.esper.common.internal.epl.expression.assign.ExprAssignmentCurly;
import com.espertech.esper.common.internal.epl.expression.assign.ExprAssignmentLHS;
import com.espertech.esper.common.internal.epl.expression.assign.ExprAssignmentLHSArrayElement;
import com.espertech.esper.common.internal.epl.expression.assign.ExprAssignmentLHSIdent;
import com.espertech.esper.common.internal.epl.expression.assign.ExprAssignmentLHSIdentWSubprop;
import com.espertech.esper.common.internal.epl.expression.assign.ExprAssignmentStraight;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCodegen;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.variable.ExprVariableNode;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVariableVisitor;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableMetaData;
import com.espertech.esper.common.internal.epl.variable.core.Variable;
import com.espertech.esper.common.internal.epl.variable.core.VariableDeployTimeResolver;
import com.espertech.esper.common.internal.epl.variable.core.VariableReadWritePackage;
import com.espertech.esper.common.internal.epl.variable.core.VariableReader;
import com.espertech.esper.common.internal.epl.variable.core.VariableTriggerSetDesc;
import com.espertech.esper.common.internal.epl.variable.core.VariableTriggerWrite;
import com.espertech.esper.common.internal.epl.variable.core.VariableTriggerWriteArrayElementForge;
import com.espertech.esper.common.internal.epl.variable.core.VariableTriggerWriteCurlyForge;
import com.espertech.esper.common.internal.epl.variable.core.VariableTriggerWriteDescForge;
import com.espertech.esper.common.internal.epl.variable.core.VariableTriggerWriteForge;
import com.espertech.esper.common.internal.epl.variable.core.VariableUtil;
import com.espertech.esper.common.internal.event.core.EventBeanCopyMethodForge;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventPropertyWriterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.TypeWidenerException;
import com.espertech.esper.common.internal.util.TypeWidenerFactory;
import com.espertech.esper.common.internal.util.TypeWidenerSPI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VariableReadWritePackageForge {
    private final ExprAssignment[] assignments;
    private final VariableMetaData[] variables;
    private final boolean[] mustCoerce;
    private final VariableTriggerWriteForge[] writers;
    private final Map<EventTypeSPI, EventBeanCopyMethodForge> copyMethods;
    private final Map<String, Object> variableTypes;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VariableReadWritePackageForge(List<OnTriggerSetAssignment> assignments, String statementName, StatementCompileTimeServices services) throws ExprValidationException {
        this.variables = new VariableMetaData[assignments.size()];
        this.mustCoerce = new boolean[assignments.size()];
        this.writers = new VariableTriggerWriteForge[assignments.size()];
        this.variableTypes = new HashMap<String, Object>();
        HashMap<EventTypeSPI, CopyMethodDesc> eventTypeWrittenProps = new HashMap<EventTypeSPI, CopyMethodDesc>();
        int count = 0;
        ArrayList<ExprAssignment> assignmentList = new ArrayList<ExprAssignment>();
        for (OnTriggerSetAssignment onTriggerSetAssignment : assignments) {
            ExprAssignment assignmentDesc = onTriggerSetAssignment.getValidated();
            assignmentList.add(assignmentDesc);
            try {
                if (assignmentDesc instanceof ExprAssignmentStraight) {
                    ExprAssignmentStraight assignment = (ExprAssignmentStraight)assignmentDesc;
                    ExprAssignmentLHS identAssignment = assignment.getLhs();
                    String variableName = identAssignment.getIdent();
                    VariableMetaData variableMetadata = services.getVariableCompileTimeResolver().resolve(variableName);
                    if (variableMetadata == null) {
                        throw new ExprValidationException("Variable by name '" + variableName + "' has not been created or configured");
                    }
                    this.variables[count] = variableMetadata;
                    Class expressionType = assignment.getRhs().getForge().getEvaluationType();
                    if (assignment.getLhs() instanceof ExprAssignmentLHSIdent) {
                        if (variableMetadata.getEventType() != null) {
                            if (expressionType != null && !JavaClassHelper.isSubclassOrImplementsInterface(expressionType, variableMetadata.getEventType().getUnderlyingType())) {
                                throw new ExprValidationException("Variable '" + variableName + "' of declared event type '" + variableMetadata.getEventType().getName() + "' underlying type '" + variableMetadata.getEventType().getUnderlyingType().getName() + "' cannot be assigned a value of type '" + expressionType.getName() + "'");
                            }
                            this.variableTypes.put(variableName, variableMetadata.getEventType().getUnderlyingType());
                        } else {
                            Class variableType = variableMetadata.getType();
                            this.variableTypes.put(variableName, variableType);
                            if (variableType != Object.class && JavaClassHelper.getBoxedType(expressionType) != variableType && expressionType != null) {
                                if (!JavaClassHelper.isNumeric(variableType) || !JavaClassHelper.isNumeric(expressionType)) {
                                    throw new ExprValidationException(VariableUtil.getAssigmentExMessage(variableName, variableType, expressionType));
                                }
                                if (!JavaClassHelper.canCoerce(expressionType, variableType)) {
                                    throw new ExprValidationException(VariableUtil.getAssigmentExMessage(variableName, variableType, expressionType));
                                }
                                this.mustCoerce[count] = true;
                            }
                        }
                    } else if (assignment.getLhs() instanceof ExprAssignmentLHSIdentWSubprop) {
                        ExprAssignmentLHSIdentWSubprop subpropAssignment = (ExprAssignmentLHSIdentWSubprop)assignment.getLhs();
                        String subPropertyName = subpropAssignment.getSubpropertyName();
                        if (variableMetadata.getEventType() == null) {
                            throw new ExprValidationException("Variable by name '" + variableName + "' does not have a property named '" + subPropertyName + "'");
                        }
                        EventType type = variableMetadata.getEventType();
                        if (!(type instanceof EventTypeSPI)) {
                            throw new ExprValidationException("Variable by name '" + variableName + "' event type '" + type.getName() + "' not writable");
                        }
                        EventTypeSPI spi = (EventTypeSPI)type;
                        EventPropertyWriterSPI writer = spi.getWriter(subPropertyName);
                        EventPropertyGetterSPI getter = spi.getGetterSPI(subPropertyName);
                        Class getterType = spi.getPropertyType(subPropertyName);
                        if (writer == null) {
                            throw new ExprValidationException("Variable by name '" + variableName + "' the property '" + subPropertyName + "' is not writable");
                        }
                        String fullVariableName = variableName + "." + subPropertyName;
                        this.variableTypes.put(fullVariableName, spi.getPropertyType(subPropertyName));
                        CopyMethodDesc writtenProps = (CopyMethodDesc)eventTypeWrittenProps.get(spi);
                        if (writtenProps == null) {
                            writtenProps = new CopyMethodDesc(variableName, new ArrayList<String>());
                            eventTypeWrittenProps.put(spi, writtenProps);
                        }
                        writtenProps.getPropertiesCopied().add(subPropertyName);
                        this.writers[count] = new VariableTriggerWriteDescForge(spi, variableName, writer, getter, getterType, assignment.getRhs().getForge().getEvaluationType());
                    } else {
                        TypeWidenerSPI widener;
                        if (!(assignment.getLhs() instanceof ExprAssignmentLHSArrayElement)) throw new IllegalStateException("Unrecognized left hand side assignment " + assignment.getLhs());
                        ExprAssignmentLHSArrayElement arrayAssign = (ExprAssignmentLHSArrayElement)assignment.getLhs();
                        Class variableType = variableMetadata.getType();
                        if (!variableType.isArray()) {
                            throw new ExprValidationException("Variable '" + variableMetadata.getVariableName() + "' is not an array");
                        }
                        try {
                            widener = TypeWidenerFactory.getCheckPropertyAssignType(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(assignment.getRhs()), expressionType, variableType.getComponentType(), variableMetadata.getVariableName(), false, null, statementName);
                        }
                        catch (TypeWidenerException ex) {
                            throw new ExprValidationException(ex.getMessage(), ex);
                        }
                        this.writers[count] = new VariableTriggerWriteArrayElementForge(variableName, arrayAssign.getIndexExpression().getForge(), widener);
                    }
                } else {
                    if (!(assignmentDesc instanceof ExprAssignmentCurly)) throw new IllegalStateException("Unrecognized assignment expression " + assignmentDesc);
                    ExprAssignmentCurly curly = (ExprAssignmentCurly)assignmentDesc;
                    if (curly.getExpression() instanceof ExprVariableNode) {
                        throw new ExprValidationException("Missing variable assignment expression in assignment number " + count);
                    }
                    ExprNodeVariableVisitor variableVisitor = new ExprNodeVariableVisitor(services.getVariableCompileTimeResolver());
                    curly.getExpression().accept(variableVisitor);
                    if (variableVisitor.getVariableNames() == null || variableVisitor.getVariableNames().size() != 1) {
                        throw new ExprValidationException("Assignment expression must receive a single variable value");
                    }
                    Map.Entry<String, VariableMetaData> variable = variableVisitor.getVariableNames().entrySet().iterator().next();
                    this.variables[count] = variable.getValue();
                    this.writers[count] = new VariableTriggerWriteCurlyForge(variable.getKey(), curly.getExpression().getForge());
                }
                if (this.variables[count].isConstant()) {
                    throw new ExprValidationException("Variable by name '" + this.variables[count].getVariableName() + "' is declared constant and may not be set");
                }
                ++count;
            }
            catch (ExprValidationException ex) {
                throw new ExprValidationException("Failed to validate assignment expression '" + ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(assignmentDesc.getOriginalExpression()) + "': " + ex.getMessage(), ex);
            }
        }
        this.assignments = assignmentList.toArray(new ExprAssignment[assignmentList.size()]);
        if (eventTypeWrittenProps.isEmpty()) {
            this.copyMethods = Collections.EMPTY_MAP;
            return;
        }
        this.copyMethods = new HashMap<EventTypeSPI, EventBeanCopyMethodForge>();
        for (Map.Entry entry : eventTypeWrittenProps.entrySet()) {
            List<String> propsWritten = ((CopyMethodDesc)entry.getValue()).getPropertiesCopied();
            String[] props = propsWritten.toArray(new String[propsWritten.size()]);
            EventBeanCopyMethodForge copyMethod = ((EventTypeSPI)entry.getKey()).getCopyMethodForge(props);
            if (copyMethod == null) {
                throw new ExprValidationException("Variable '" + ((CopyMethodDesc)entry.getValue()).getVariableName() + "' of declared type " + JavaClassHelper.getClassNameFullyQualPretty(((EventTypeSPI)entry.getKey()).getUnderlyingType()) + "' cannot be assigned to");
            }
            this.copyMethods.put((EventTypeSPI)entry.getKey(), copyMethod);
        }
    }

    public Map<String, Object> getVariableTypes() {
        return this.variableTypes;
    }

    public CodegenExpression make(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(VariableReadWritePackage.class, this.getClass(), (CodegenScope)classScope);
        CodegenExpressionRef ref = CodegenExpressionBuilder.ref("rw");
        method.getBlock().declareVar(VariableReadWritePackage.class, ref.getRef(), CodegenExpressionBuilder.newInstance(VariableReadWritePackage.class, new CodegenExpression[0])).exprDotMethod(ref, "setCopyMethods", VariableReadWritePackageForge.makeCopyMethods(this.copyMethods, method, symbols, classScope)).exprDotMethod(ref, "setAssignments", VariableReadWritePackageForge.makeAssignments(this.assignments, this.variables, method, symbols, classScope)).exprDotMethod(ref, "setVariables", VariableReadWritePackageForge.makeVariables(this.variables, method, symbols, classScope)).exprDotMethod(ref, "setWriters", VariableReadWritePackageForge.makeWriters(this.writers, method, symbols, classScope)).exprDotMethod(ref, "setReadersForGlobalVars", VariableReadWritePackageForge.makeReadersForGlobalVars(this.variables, method, symbols, classScope)).exprDotMethod(ref, "setMustCoerce", CodegenExpressionBuilder.constant(this.mustCoerce)).methodReturn(ref);
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    private static CodegenExpression makeReadersForGlobalVars(VariableMetaData[] variables, CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(VariableReader[].class, VariableReadWritePackageForge.class, (CodegenScope)classScope);
        method.getBlock().declareVar(VariableReader[].class, "readers", CodegenExpressionBuilder.newArrayByLength(VariableReader.class, CodegenExpressionBuilder.constant(variables.length)));
        for (int i = 0; i < variables.length; ++i) {
            if (variables[i].getOptionalContextName() != null) continue;
            CodegenExpression resolve = CodegenExpressionBuilder.staticMethod(VariableDeployTimeResolver.class, "resolveVariableReader", CodegenExpressionBuilder.constant(variables[i].getVariableName()), CodegenExpressionBuilder.constant((Object)variables[i].getVariableVisibility()), CodegenExpressionBuilder.constant(variables[i].getVariableModuleName()), CodegenExpressionBuilder.constantNull(), symbols.getAddInitSvc(method));
            method.getBlock().assignArrayElement("readers", CodegenExpressionBuilder.constant(i), resolve);
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("readers"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    private static CodegenExpression makeWriters(VariableTriggerWriteForge[] writers, CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(VariableTriggerWrite[].class, VariableReadWritePackageForge.class, (CodegenScope)classScope);
        method.getBlock().declareVar(VariableTriggerWrite[].class, "writers", CodegenExpressionBuilder.newArrayByLength(VariableTriggerWrite.class, CodegenExpressionBuilder.constant(writers.length)));
        for (int i = 0; i < writers.length; ++i) {
            CodegenExpression writer = writers[i] == null ? CodegenExpressionBuilder.constantNull() : writers[i].make(method, symbols, classScope);
            method.getBlock().assignArrayElement("writers", CodegenExpressionBuilder.constant(i), writer);
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("writers"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    private static CodegenExpression makeVariables(VariableMetaData[] variables, CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(Variable[].class, VariableReadWritePackageForge.class, (CodegenScope)classScope);
        method.getBlock().declareVar(Variable[].class, "vars", CodegenExpressionBuilder.newArrayByLength(Variable.class, CodegenExpressionBuilder.constant(variables.length)));
        for (int i = 0; i < variables.length; ++i) {
            CodegenExpression resolve = VariableDeployTimeResolver.makeResolveVariable(variables[i], symbols.getAddInitSvc(method));
            method.getBlock().assignArrayElement("vars", CodegenExpressionBuilder.constant(i), resolve);
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("vars"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    private static CodegenExpression makeAssignments(ExprAssignment[] assignments, VariableMetaData[] variables, CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(VariableTriggerSetDesc[].class, VariableReadWritePackageForge.class, (CodegenScope)classScope);
        method.getBlock().declareVar(VariableTriggerSetDesc[].class, "sets", CodegenExpressionBuilder.newArrayByLength(VariableTriggerSetDesc.class, CodegenExpressionBuilder.constant(assignments.length)));
        for (int i = 0; i < assignments.length; ++i) {
            CodegenExpression set;
            if (assignments[i] instanceof ExprAssignmentStraight) {
                ExprAssignmentStraight straightAssignment = (ExprAssignmentStraight)assignments[i];
                set = CodegenExpressionBuilder.newInstance(VariableTriggerSetDesc.class, CodegenExpressionBuilder.constant(straightAssignment.getLhs().getFullIdentifier()), ExprNodeUtilityCodegen.codegenEvaluator(straightAssignment.getRhs().getForge(), method, VariableReadWritePackageForge.class, classScope));
            } else {
                set = CodegenExpressionBuilder.newInstance(VariableTriggerSetDesc.class, CodegenExpressionBuilder.constant(variables[i].getVariableName()), CodegenExpressionBuilder.constantNull());
            }
            method.getBlock().assignArrayElement("sets", CodegenExpressionBuilder.constant(i), set);
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("sets"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    private static CodegenExpression makeCopyMethods(Map<EventTypeSPI, EventBeanCopyMethodForge> copyMethods, CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        if (copyMethods.isEmpty()) {
            return CodegenExpressionBuilder.staticMethod(Collections.class, "emptyMap", new CodegenExpression[0]);
        }
        CodegenMethod method = parent.makeChild(Map.class, VariableReadWritePackageForge.class, (CodegenScope)classScope);
        method.getBlock().declareVar(Map.class, "methods", CodegenExpressionBuilder.newInstance(HashMap.class, CodegenExpressionBuilder.constant(copyMethods.size())));
        for (Map.Entry<EventTypeSPI, EventBeanCopyMethodForge> entry : copyMethods.entrySet()) {
            CodegenExpression type = EventTypeUtility.resolveTypeCodegen(entry.getKey(), symbols.getAddInitSvc(method));
            CodegenExpression copyMethod = entry.getValue().makeCopyMethodClassScoped(classScope);
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("methods"), "put", type, copyMethod);
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("methods"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    private static class CopyMethodDesc {
        private final String variableName;
        private final List<String> propertiesCopied;

        public CopyMethodDesc(String variableName, List<String> propertiesCopied) {
            this.variableName = variableName;
            this.propertiesCopied = propertiesCopied;
        }

        public String getVariableName() {
            return this.variableName;
        }

        public List<String> getPropertiesCopied() {
            return this.propertiesCopied;
        }
    }
}

