/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.variable.core;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.configuration.ConfigurationException;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonVariable;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableMetaData;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableTypeException;
import com.espertech.esper.common.internal.epl.variable.core.VariableRepositoryPreconfigured;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactoryCompileTime;
import com.espertech.esper.common.internal.event.eventtyperepo.EventTypeRepositoryImpl;
import com.espertech.esper.common.internal.settings.ClasspathExtensionClass;
import com.espertech.esper.common.internal.settings.ClasspathExtensionClassEmpty;
import com.espertech.esper.common.internal.settings.ClasspathImportException;
import com.espertech.esper.common.internal.settings.ClasspathImportService;
import com.espertech.esper.common.internal.type.ClassIdentifierWArray;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableUtil {
    private static final Logger log = LoggerFactory.getLogger(VariableUtil.class);

    public static String getAssigmentExMessage(String variableName, Class variableType, Class initValueClass) {
        return "Variable '" + variableName + "' of declared type " + JavaClassHelper.getClassNameFullyQualPretty(variableType) + " cannot be assigned a value of type " + JavaClassHelper.getClassNameFullyQualPretty(initValueClass);
    }

    public static void configureVariables(VariableRepositoryPreconfigured repo, Map<String, ConfigurationCommonVariable> variables, ClasspathImportService classpathImportService, EventBeanTypedEventFactory eventBeanTypedEventFactory, EventTypeRepositoryImpl eventTypeRepositoryPreconfigured, BeanEventTypeFactory beanEventTypeFactory) throws ConfigurationException {
        for (Map.Entry<String, ConfigurationCommonVariable> entry : variables.entrySet()) {
            VariableMetaData meta;
            String variableName = entry.getKey().trim();
            if (repo.getMetadata(variableName) != null) continue;
            try {
                ClassIdentifierWArray variableType = ClassIdentifierWArray.parseSODA(entry.getValue().getType());
                meta = VariableUtil.getTypeInfo(variableName, null, NameAccessModifier.PRECONFIGURED, null, null, null, variableType, true, entry.getValue().isConstant(), entry.getValue().isConstant(), entry.getValue().getInitializationValue(), classpathImportService, ClasspathExtensionClassEmpty.INSTANCE, eventBeanTypedEventFactory, eventTypeRepositoryPreconfigured, beanEventTypeFactory);
            }
            catch (Throwable t) {
                throw new ConfigurationException("Error configuring variable '" + variableName + "': " + t.getMessage(), t);
            }
            repo.addVariable(variableName, meta);
        }
    }

    public static VariableMetaData compileVariable(String variableName, String variableModuleName, NameAccessModifier variableVisibility, String optionalContextName, NameAccessModifier optionalContextVisibility, String optionalModuleName, ClassIdentifierWArray variableType, boolean isConstant, boolean compileTimeConstant, Object initializationValue, ClasspathImportService classpathImportService, ClasspathExtensionClass classpathExtension, EventBeanTypedEventFactory eventBeanTypedEventFactory, EventTypeRepositoryImpl eventTypeRepositoryPreconfigured, BeanEventTypeFactory beanEventTypeFactory) throws ExprValidationException {
        try {
            return VariableUtil.getTypeInfo(variableName, variableModuleName, variableVisibility, optionalContextName, optionalContextVisibility, optionalModuleName, variableType, false, isConstant, compileTimeConstant, initializationValue, classpathImportService, classpathExtension, eventBeanTypedEventFactory, eventTypeRepositoryPreconfigured, beanEventTypeFactory);
        }
        catch (VariableTypeException t) {
            throw new ExprValidationException(t.getMessage(), t);
        }
        catch (Throwable t) {
            throw new ExprValidationException("Failed to compile variable '" + variableName + "': " + t.getMessage(), t);
        }
    }

    public static String checkVariableContextName(String optionalStatementContextName, VariableMetaData variableMetaData) {
        if (optionalStatementContextName == null) {
            if (variableMetaData.getOptionalContextName() != null) {
                return "Variable '" + variableMetaData.getVariableName() + "' defined for use with context '" + variableMetaData.getOptionalContextName() + "' can only be accessed within that context";
            }
        } else if (variableMetaData.getOptionalContextName() != null && !variableMetaData.getOptionalContextName().equals(optionalStatementContextName)) {
            return "Variable '" + variableMetaData.getVariableName() + "' defined for use with context '" + variableMetaData.getOptionalContextName() + "' is not available for use with context '" + optionalStatementContextName + "'";
        }
        return null;
    }

    private static VariableMetaData getTypeInfo(String variableName, String variableModuleName, NameAccessModifier variableVisibility, String optionalContextName, NameAccessModifier optionalContextVisibility, String optionalContextModule, ClassIdentifierWArray variableTypeWArray, boolean preconfigured, boolean constant, boolean compileTimeConstant, Object valueAsProvided, ClasspathImportService classpathImportService, ClasspathExtensionClass classpathExtension, EventBeanTypedEventFactory eventBeanTypedEventFactory, EventTypeRepositoryImpl eventTypeRepositoryPreconfigured, BeanEventTypeFactory beanEventTypeFactory) throws VariableTypeException {
        Class primitiveType = JavaClassHelper.getPrimitiveClassForName(variableTypeWArray.getClassIdentifier());
        Class type = JavaClassHelper.getClassForSimpleName(variableTypeWArray.getClassIdentifier(), classpathImportService.getClassForNameProvider());
        Class arrayType = null;
        EventType eventType = null;
        if (type == null) {
            if (variableTypeWArray.getClassIdentifier().toLowerCase(Locale.ENGLISH).equals("object")) {
                type = JavaClassHelper.getArrayType(Object.class, variableTypeWArray.getArrayDimensions());
            }
            if (type == null && (eventType = eventTypeRepositoryPreconfigured.getTypeByName(variableTypeWArray.getClassIdentifier())) != null) {
                type = eventType.getUnderlyingType();
            }
            ClasspathImportException lastException = null;
            if (type == null) {
                try {
                    type = classpathImportService.resolveClass(variableTypeWArray.getClassIdentifier(), false, classpathExtension);
                    type = JavaClassHelper.getArrayType(type, variableTypeWArray.getArrayDimensions());
                }
                catch (ClasspathImportException e) {
                    log.debug("Not found '" + type + "': " + e.getMessage(), (Throwable)e);
                    lastException = e;
                }
            }
            if (type == null) {
                throw new VariableTypeException("Cannot create variable '" + variableName + "', type '" + variableTypeWArray.getClassIdentifier() + "' is not a recognized type", lastException);
            }
            if (variableTypeWArray.getArrayDimensions() > 0 && eventType != null) {
                throw new VariableTypeException("Cannot create variable '" + variableName + "', type '" + variableTypeWArray.getClassIdentifier() + "' cannot be declared as an array type as it is an event type", lastException);
            }
        } else if (variableTypeWArray.getArrayDimensions() > 0) {
            if (variableTypeWArray.isArrayOfPrimitive()) {
                if (primitiveType == null) {
                    throw new VariableTypeException("Cannot create variable '" + variableName + "', type '" + variableTypeWArray.getClassIdentifier() + "' is not a primitive type");
                }
                arrayType = JavaClassHelper.getArrayType(primitiveType, variableTypeWArray.getArrayDimensions());
            } else {
                arrayType = JavaClassHelper.getArrayType(type, variableTypeWArray.getArrayDimensions());
            }
        }
        if (!(eventType != null || JavaClassHelper.isJavaBuiltinDataType(type) || type == Object.class || type.isArray() || type.isEnum())) {
            if (variableTypeWArray.getArrayDimensions() > 0) {
                throw new VariableTypeException("Cannot create variable '" + variableName + "', type '" + variableTypeWArray.getClassIdentifier() + "' cannot be declared as an array, only scalar types can be array");
            }
            eventType = beanEventTypeFactory.getCreateBeanType(type, false);
        }
        if (arrayType != null) {
            type = arrayType;
        }
        Object coerced = VariableUtil.getCoercedValue(valueAsProvided, eventType, variableName, type, eventBeanTypedEventFactory);
        return new VariableMetaData(variableName, variableModuleName, variableVisibility, optionalContextName, optionalContextVisibility, optionalContextModule, type, eventType, preconfigured, constant, compileTimeConstant, coerced, true);
    }

    private static Object getCoercedValue(Object value, EventType eventType, String variableName, Class variableType, EventBeanTypedEventFactory eventBeanTypedEventFactory) throws VariableTypeException {
        Object coercedValue = value;
        if (eventType != null) {
            if (value != null && !JavaClassHelper.isSubclassOrImplementsInterface(value.getClass(), eventType.getUnderlyingType())) {
                throw new VariableTypeException("Variable '" + variableName + "' of declared event type '" + eventType.getName() + "' underlying type '" + eventType.getUnderlyingType().getName() + "' cannot be assigned a value of type '" + value.getClass().getName() + "'");
            }
            if (eventBeanTypedEventFactory != EventBeanTypedEventFactoryCompileTime.INSTANCE) {
                coercedValue = eventBeanTypedEventFactory.adapterForTypedBean(value, eventType);
            }
        } else if (variableType != Object.class) {
            if (coercedValue != null && coercedValue instanceof String) {
                try {
                    coercedValue = JavaClassHelper.parse(variableType, (String)coercedValue);
                }
                catch (Exception ex) {
                    throw new VariableTypeException("Variable '" + variableName + "' of declared type " + JavaClassHelper.getClassNameFullyQualPretty(variableType) + " cannot be initialized by value '" + coercedValue + "': " + ex.toString());
                }
            }
            if (coercedValue != null && !JavaClassHelper.isSubclassOrImplementsInterface(coercedValue.getClass(), variableType)) {
                if (!JavaClassHelper.isNumeric(variableType) || !(coercedValue instanceof Number)) {
                    throw VariableUtil.getVariableTypeException(variableName, variableType, coercedValue.getClass());
                }
                if (!JavaClassHelper.canCoerce(coercedValue.getClass(), variableType)) {
                    throw VariableUtil.getVariableTypeException(variableName, variableType, coercedValue.getClass());
                }
                coercedValue = JavaClassHelper.coerceBoxed((Number)coercedValue, variableType);
            }
        }
        return coercedValue;
    }

    private static VariableTypeException getVariableTypeException(String variableName, Class variableType, Class initValueClass) {
        return new VariableTypeException("Variable '" + variableName + "' of declared type " + JavaClassHelper.getClassNameFullyQualPretty(variableType) + " cannot be initialized by a value of type " + JavaClassHelper.getClassNameFullyQualPretty(initValueClass));
    }
}

