/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.virtualdw;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBeanFactory;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.hook.vdw.VirtualDataWindow;
import com.espertech.esper.common.client.hook.vdw.VirtualDataWindowContext;
import com.espertech.esper.common.client.hook.vdw.VirtualDataWindowFactory;
import com.espertech.esper.common.client.hook.vdw.VirtualDataWindowFactoryContext;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.virtualdw.VirtualDWViewImpl;
import com.espertech.esper.common.internal.epl.virtualdw.VirtualDataWindowOutStreamImpl;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.DataWindowViewFactory;
import com.espertech.esper.common.internal.view.core.View;
import com.espertech.esper.common.internal.view.core.ViewFactoryContext;
import java.io.Serializable;

public class VirtualDWViewFactory
implements DataWindowViewFactory {
    private EventType eventType;
    private VirtualDataWindowFactory factory;
    private Object[] parameters;
    private ExprEvaluator[] parameterExpressions;
    private String namedWindowName;
    private Serializable compileTimeConfiguration;
    private EventBeanFactory eventBeanFactory;

    @Override
    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public void init(ViewFactoryContext viewFactoryContext, EPStatementInitServices services) {
        try {
            this.eventBeanFactory = EventTypeUtility.getFactoryForType(this.eventType, services.getEventBeanTypedEventFactory(), services.getEventTypeAvroHandler());
            VirtualDataWindowFactoryContext factoryContext = new VirtualDataWindowFactoryContext(this.eventType, this.parameters, this.parameterExpressions, this.namedWindowName, this.compileTimeConfiguration, viewFactoryContext, services);
            this.factory.initialize(factoryContext);
        }
        catch (RuntimeException ex) {
            throw new EPException("Validation exception initializing virtual data window '" + this.namedWindowName + "': " + ex.getMessage(), ex);
        }
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        VirtualDataWindow window;
        VirtualDataWindowOutStreamImpl outputStream = new VirtualDataWindowOutStreamImpl();
        try {
            VirtualDataWindowContext context = new VirtualDataWindowContext(this, agentInstanceViewFactoryContext, this.eventBeanFactory, outputStream);
            window = this.factory.create(context);
        }
        catch (Exception ex) {
            throw new EPException("Exception returned by virtual data window factory upon creation: " + ex.getMessage(), ex);
        }
        VirtualDWViewImpl view = new VirtualDWViewImpl(this, agentInstanceViewFactoryContext.getAgentInstanceContext(), window);
        outputStream.setView(view);
        return view;
    }

    @Override
    public String getViewName() {
        return "virtual-data-window";
    }

    public VirtualDataWindowFactory getFactory() {
        return this.factory;
    }

    public void setFactory(VirtualDataWindowFactory factory) {
        this.factory = factory;
    }

    public void setParameters(Object[] parameters) {
        this.parameters = parameters;
    }

    public void setParameterExpressions(ExprEvaluator[] parameterExpressions) {
        this.parameterExpressions = parameterExpressions;
    }

    public void setNamedWindowName(String namedWindowName) {
        this.namedWindowName = namedWindowName;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public ExprEvaluator[] getParameterExpressions() {
        return this.parameterExpressions;
    }

    public String getNamedWindowName() {
        return this.namedWindowName;
    }

    public Serializable getCompileTimeConfiguration() {
        return this.compileTimeConfiguration;
    }

    public void setCompileTimeConfiguration(Serializable compileTimeConfiguration) {
        this.compileTimeConfiguration = compileTimeConfiguration;
    }

    public void destroy() {
        this.factory.destroy();
    }
}

