/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.virtualdw;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.hook.forgeinject.InjectionStrategyClassNewInstance;
import com.espertech.esper.common.client.hook.vdw.VirtualDataWindowFactoryFactory;
import com.espertech.esper.common.client.hook.vdw.VirtualDataWindowFactoryFactoryContext;
import com.espertech.esper.common.client.hook.vdw.VirtualDataWindowFactoryMode;
import com.espertech.esper.common.client.hook.vdw.VirtualDataWindowFactoryModeManaged;
import com.espertech.esper.common.client.hook.vdw.VirtualDataWindowForge;
import com.espertech.esper.common.client.hook.vdw.VirtualDataWindowForgeContext;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeBuilder;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCodegen;
import com.espertech.esper.common.internal.epl.virtualdw.VirtualDWViewFactory;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SerializerUtil;
import com.espertech.esper.common.internal.view.core.DataWindowViewForge;
import com.espertech.esper.common.internal.view.core.ViewFactoryForge;
import com.espertech.esper.common.internal.view.core.ViewForgeEnv;
import com.espertech.esper.common.internal.view.core.ViewParameterException;
import com.espertech.esper.common.internal.view.core.ViewProcessingException;
import com.espertech.esper.common.internal.view.util.ViewForgeSupport;
import java.io.Serializable;
import java.util.List;
import java.util.Set;

public class VirtualDWViewFactoryForge
implements ViewFactoryForge,
DataWindowViewForge {
    private final VirtualDataWindowForge forge;
    private final String namedWindowName;
    private final Serializable customConfigs;
    private List<ExprNode> parameters;
    private ViewForgeEnv viewForgeEnv;
    private int streamNumber;
    ExprNode[] validatedParameterExpressions;
    private EventType parentEventType;
    private Object[] parameterValues;

    public VirtualDWViewFactoryForge(Class clazz, String namedWindowName, Serializable customConfigs) {
        if (!JavaClassHelper.isImplementsInterface(clazz, VirtualDataWindowForge.class)) {
            throw new ViewProcessingException("Virtual data window forge class " + clazz.getName() + " does not implement the interface " + VirtualDataWindowForge.class.getName());
        }
        this.forge = (VirtualDataWindowForge)JavaClassHelper.instantiate(VirtualDataWindowForge.class, clazz);
        this.namedWindowName = namedWindowName;
        this.customConfigs = customConfigs;
    }

    @Override
    public void setViewParameters(List<ExprNode> parameters, ViewForgeEnv viewForgeEnv, int streamNumber) throws ViewParameterException {
        this.parameters = parameters;
        this.viewForgeEnv = viewForgeEnv;
        this.streamNumber = streamNumber;
    }

    @Override
    public void attach(EventType parentEventType, int streamNumber, ViewForgeEnv viewForgeEnv) throws ViewParameterException {
        this.parentEventType = parentEventType;
        this.validatedParameterExpressions = ViewForgeSupport.validate(this.getViewName(), parentEventType, this.parameters, true, viewForgeEnv, streamNumber);
        this.parameterValues = new Object[this.validatedParameterExpressions.length];
        for (int i = 0; i < this.validatedParameterExpressions.length; ++i) {
            try {
                this.parameterValues[i] = ViewForgeSupport.evaluateAssertNoProperties(this.getViewName(), this.validatedParameterExpressions[i], i);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.forge.initialize(new VirtualDataWindowForgeContext(parentEventType, this.parameterValues, this.validatedParameterExpressions, this.namedWindowName, viewForgeEnv, this.customConfigs));
        }
        catch (RuntimeException ex) {
            throw new ViewParameterException("Validation exception initializing virtual data window '" + this.namedWindowName + "': " + ex.getMessage(), ex);
        }
    }

    @Override
    public EventType getEventType() {
        return this.parentEventType;
    }

    @Override
    public String getViewName() {
        return "virtual-data-window";
    }

    @Override
    public CodegenExpression make(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        VirtualDataWindowFactoryMode mode = this.forge.getFactoryMode();
        if (!(mode instanceof VirtualDataWindowFactoryModeManaged)) {
            throw new IllegalArgumentException("Unexpected factory mode " + mode);
        }
        VirtualDataWindowFactoryModeManaged managed = (VirtualDataWindowFactoryModeManaged)mode;
        InjectionStrategyClassNewInstance injectionStrategy = (InjectionStrategyClassNewInstance)managed.getInjectionStrategyFactoryFactory();
        CodegenExpressionField factoryField = classScope.addFieldUnshared(true, VirtualDataWindowFactoryFactory.class, injectionStrategy.getInitializationExpression(classScope));
        SAIFFInitializeBuilder builder = new SAIFFInitializeBuilder(VirtualDWViewFactory.class, this.getClass(), "factory", parent, symbols, classScope);
        builder.eventtype("eventType", this.parentEventType).expression("factory", CodegenExpressionBuilder.exprDotMethod(factoryField, "createFactory", CodegenExpressionBuilder.newInstance(VirtualDataWindowFactoryFactoryContext.class, new CodegenExpression[0]))).constant("parameters", this.parameterValues).expression("parameterExpressions", ExprNodeUtilityCodegen.codegenEvaluators(this.validatedParameterExpressions, (CodegenMethodScope)builder.getMethod(), this.getClass(), classScope)).constant("namedWindowName", this.namedWindowName).expression("compileTimeConfiguration", SerializerUtil.expressionForUserObject(this.customConfigs));
        return builder.build();
    }

    public Set<String> getUniqueKeys() {
        return this.forge.getUniqueKeyPropertyNames();
    }
}

