/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.arr;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventPropertyGetter;
import com.espertech.esper.common.internal.event.core.BaseNestableEventUtil;
import com.espertech.esper.common.internal.event.map.MapEventPropertyGetter;
import java.util.Map;

public class ObjectArrayMapPropertyGetter
implements ObjectArrayEventPropertyGetter {
    private final int index;
    private final MapEventPropertyGetter getter;

    public ObjectArrayMapPropertyGetter(int index, MapEventPropertyGetter getter) {
        if (getter == null) {
            throw new IllegalArgumentException("Getter is a required parameter");
        }
        this.index = index;
        this.getter = getter;
    }

    @Override
    public Object getObjectArray(Object[] array) throws PropertyAccessException {
        Object valueTopObj = array[this.index];
        if (!(valueTopObj instanceof Map)) {
            return null;
        }
        return this.getter.getMap((Map)valueTopObj);
    }

    private CodegenMethod getObjectArrayCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return codegenMethodScope.makeChild(Object.class, this.getClass(), (CodegenScope)codegenClassScope).addParam(Object[].class, "array").getBlock().declareVar(Object.class, "valueTopObj", CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("array"), CodegenExpressionBuilder.constant(this.index))).ifRefNotTypeReturnConst("valueTopObj", Map.class, null).methodReturn(this.getter.underlyingGetCodegen(CodegenExpressionBuilder.cast(Map.class, (CodegenExpression)CodegenExpressionBuilder.ref("valueTopObj")), codegenMethodScope, codegenClassScope));
    }

    @Override
    public boolean isObjectArrayExistsProperty(Object[] array) {
        Object valueTopObj = array[this.index];
        if (!(valueTopObj instanceof Map)) {
            return false;
        }
        return this.getter.isMapExistsProperty((Map)valueTopObj);
    }

    private CodegenMethod isObjectArrayExistsPropertyCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return codegenMethodScope.makeChild(Boolean.TYPE, this.getClass(), (CodegenScope)codegenClassScope).addParam(Object[].class, "array").getBlock().declareVar(Object.class, "valueTopObj", CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("array"), CodegenExpressionBuilder.constant(this.index))).ifRefNotTypeReturnConst("valueTopObj", Map.class, false).methodReturn(this.getter.underlyingExistsCodegen(CodegenExpressionBuilder.cast(Map.class, (CodegenExpression)CodegenExpressionBuilder.ref("valueTopObj")), codegenMethodScope, codegenClassScope));
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        Object[] array = BaseNestableEventUtil.checkedCastUnderlyingObjectArray(eventBean);
        return this.getObjectArray(array);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        Object[] array = BaseNestableEventUtil.checkedCastUnderlyingObjectArray(eventBean);
        return this.isObjectArrayExistsProperty(array);
    }

    @Override
    public Object getFragment(EventBean eventBean) {
        return null;
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.castUnderlying(Object[].class, beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingExistsCodegen(CodegenExpressionBuilder.castUnderlying(Object[].class, beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanFragmentCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantNull();
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.localMethod(this.getObjectArrayCodegen(codegenMethodScope, codegenClassScope), underlyingExpression);
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.localMethod(this.isObjectArrayExistsPropertyCodegen(codegenMethodScope, codegenClassScope), underlyingExpression);
    }

    @Override
    public CodegenExpression underlyingFragmentCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantNull();
    }
}

