/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.avro;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventSender;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.util.EPRuntimeEventProcessWrapped;
import com.espertech.esper.common.internal.statement.thread.ThreadingCommon;

public class EventSenderAvro
implements EventSender {
    private final EPRuntimeEventProcessWrapped runtimeEventSender;
    private final EventBeanTypedEventFactory eventBeanTypedEventFactory;
    private final EventType eventType;
    private final ThreadingCommon threadingService;

    public EventSenderAvro(EPRuntimeEventProcessWrapped runtimeEventSender, EventType eventType, EventBeanTypedEventFactory eventBeanTypedEventFactory, ThreadingCommon threadingService) {
        this.runtimeEventSender = runtimeEventSender;
        this.eventType = eventType;
        this.threadingService = threadingService;
        this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
    }

    @Override
    public void sendEvent(Object theEvent) {
        EventBean eventBean = this.eventBeanTypedEventFactory.adapterForTypedAvro(theEvent, this.eventType);
        if (this.threadingService.isInboundThreading()) {
            this.threadingService.submitInbound(eventBean, this.runtimeEventSender);
        } else {
            this.runtimeEventSender.processWrappedEvent(eventBean);
        }
    }

    @Override
    public void routeEvent(Object theEvent) {
        EventBean eventBean = this.eventBeanTypedEventFactory.adapterForTypedAvro(theEvent, this.eventType);
        this.runtimeEventSender.routeEventBean(eventBean);
    }
}

