/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventPropertyDescriptor;
import com.espertech.esper.common.client.EventPropertyGetter;
import com.espertech.esper.common.client.EventPropertyGetterIndexed;
import com.espertech.esper.common.client.EventPropertyGetterMapped;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.FragmentEventType;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.util.PropertyResolutionStyle;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.event.bean.core.BeanEventBeanConfiguredCopyMethodForge;
import com.espertech.esper.common.internal.event.bean.core.BeanEventBeanSerializableCopyMethodForge;
import com.espertech.esper.common.internal.event.bean.core.BeanEventBeanWriter;
import com.espertech.esper.common.internal.event.bean.core.BeanEventPropertyWriter;
import com.espertech.esper.common.internal.event.bean.core.BeanEventPropertyWriterIndexedProp;
import com.espertech.esper.common.internal.event.bean.core.BeanEventPropertyWriterMapProp;
import com.espertech.esper.common.internal.event.bean.core.PropertyHelper;
import com.espertech.esper.common.internal.event.bean.core.PropertyStem;
import com.espertech.esper.common.internal.event.bean.introspect.BeanEventTypeStem;
import com.espertech.esper.common.internal.event.bean.introspect.PropertyInfo;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventBeanCopyMethodForge;
import com.espertech.esper.common.internal.event.core.EventBeanUtility;
import com.espertech.esper.common.internal.event.core.EventBeanWriter;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterIndexedSPI;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterMappedSPI;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.core.NativeEventType;
import com.espertech.esper.common.internal.event.core.WriteablePropertyDescriptor;
import com.espertech.esper.common.internal.event.property.GenericPropertyDesc;
import com.espertech.esper.common.internal.event.property.IndexedProperty;
import com.espertech.esper.common.internal.event.property.MappedProperty;
import com.espertech.esper.common.internal.event.property.Property;
import com.espertech.esper.common.internal.event.property.PropertyParser;
import com.espertech.esper.common.internal.event.property.SimpleProperty;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.MethodResolver;
import com.espertech.esper.common.internal.util.MethodResolverNoSuchMethodException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanEventType
implements EventTypeSPI,
NativeEventType {
    private final BeanEventTypeStem stem;
    private EventTypeMetadata metadata;
    private final BeanEventTypeFactory beanEventTypeFactory;
    private final EventType[] superTypes;
    private final Set<EventType> deepSuperTypes;
    private final String startTimestampPropertyName;
    private final String endTimestampPropertyName;
    private final Map<String, EventPropertyGetterSPI> propertyGetterCache = new HashMap<String, EventPropertyGetterSPI>(4);
    private EventPropertyDescriptor[] writeablePropertyDescriptors;
    private Map<String, Pair<EventPropertyDescriptor, BeanEventPropertyWriter>> writerMap;
    private static final Logger log = LoggerFactory.getLogger(BeanEventType.class);

    public BeanEventType(BeanEventTypeStem stem, EventTypeMetadata metadata, BeanEventTypeFactory beanEventTypeFactory, EventType[] superTypes, Set<EventType> deepSuperTypes, String startTimestampPropertyName, String endTimestampPropertyName) {
        this.stem = stem;
        this.metadata = metadata;
        this.beanEventTypeFactory = beanEventTypeFactory;
        this.superTypes = superTypes;
        this.deepSuperTypes = deepSuperTypes;
        EventTypeUtility.TimestampPropertyDesc desc = EventTypeUtility.validatedDetermineTimestampProps(this, startTimestampPropertyName, endTimestampPropertyName, superTypes);
        this.startTimestampPropertyName = desc.getStart();
        this.endTimestampPropertyName = desc.getEnd();
    }

    @Override
    public void setMetadataId(long publicId, long protectedId) {
        this.metadata = this.metadata.withIds(publicId, protectedId);
    }

    @Override
    public String getStartTimestampPropertyName() {
        return this.startTimestampPropertyName;
    }

    @Override
    public String getEndTimestampPropertyName() {
        return this.endTimestampPropertyName;
    }

    @Override
    public String getName() {
        return this.metadata.getName();
    }

    @Override
    public EventPropertyDescriptor getPropertyDescriptor(String propertyName) {
        return this.stem.getPropertyDescriptorMap().get(propertyName);
    }

    public String getFactoryMethodName() {
        return this.stem.getOptionalLegacyDef() == null ? null : this.stem.getOptionalLegacyDef().getFactoryMethod();
    }

    @Override
    public final Class getPropertyType(String propertyName) {
        PropertyInfo simpleProp = this.getSimplePropertyInfo(propertyName);
        if (simpleProp != null && simpleProp.getClazz() != null) {
            return simpleProp.getClazz();
        }
        Property prop = PropertyParser.parseAndWalkLaxToSimple(propertyName);
        if (prop instanceof SimpleProperty) {
            return null;
        }
        return prop.getPropertyType(this, this.beanEventTypeFactory);
    }

    @Override
    public boolean isProperty(String propertyName) {
        return this.getPropertyType(propertyName) != null;
    }

    @Override
    public final Class getUnderlyingType() {
        return this.stem.getClazz();
    }

    public PropertyResolutionStyle getPropertyResolutionStyle() {
        return this.stem.getPropertyResolutionStyle();
    }

    @Override
    public EventPropertyGetterSPI getGetterSPI(String propertyName) {
        EventPropertyGetterSPI cachedGetter = this.propertyGetterCache.get(propertyName);
        if (cachedGetter != null) {
            return cachedGetter;
        }
        PropertyInfo simpleProp = this.getSimplePropertyInfo(propertyName);
        if (simpleProp != null && simpleProp.getGetterFactory() != null) {
            EventPropertyGetterSPI getter = simpleProp.getGetterFactory().make(this.beanEventTypeFactory.getEventBeanTypedEventFactory(), this.beanEventTypeFactory);
            this.propertyGetterCache.put(propertyName, getter);
            return getter;
        }
        Property prop = PropertyParser.parseAndWalkLaxToSimple(propertyName);
        if (prop instanceof SimpleProperty) {
            return null;
        }
        EventPropertyGetterSPI getter = prop.getGetter(this, this.beanEventTypeFactory.getEventBeanTypedEventFactory(), this.beanEventTypeFactory);
        this.propertyGetterCache.put(propertyName, getter);
        return getter;
    }

    @Override
    public EventPropertyGetter getGetter(String propertyName) {
        return this.getGetterSPI(propertyName);
    }

    @Override
    public EventPropertyGetterMapped getGetterMapped(String mappedPropertyName) {
        return this.getGetterMappedSPI(mappedPropertyName);
    }

    @Override
    public EventPropertyGetterMappedSPI getGetterMappedSPI(String propertyName) {
        EventPropertyDescriptor desc = this.stem.getPropertyDescriptorMap().get(propertyName);
        if (desc == null || !desc.isMapped()) {
            return null;
        }
        MappedProperty mappedProperty = new MappedProperty(propertyName);
        return mappedProperty.getGetter(this, this.beanEventTypeFactory.getEventBeanTypedEventFactory(), this.beanEventTypeFactory);
    }

    @Override
    public EventPropertyGetterIndexed getGetterIndexed(String indexedPropertyName) {
        return this.getGetterIndexedSPI(indexedPropertyName);
    }

    @Override
    public EventPropertyGetterIndexedSPI getGetterIndexedSPI(String indexedPropertyName) {
        EventPropertyDescriptor desc = this.stem.getPropertyDescriptorMap().get(indexedPropertyName);
        if (desc == null || !desc.isIndexed()) {
            return null;
        }
        IndexedProperty indexedProperty = new IndexedProperty(indexedPropertyName);
        return indexedProperty.getGetter(this, this.beanEventTypeFactory.getEventBeanTypedEventFactory(), this.beanEventTypeFactory);
    }

    public final PropertyStem getSimpleProperty(String propertyName) {
        PropertyInfo simpleProp = this.getSimplePropertyInfo(propertyName);
        if (simpleProp != null) {
            return simpleProp.getDescriptor();
        }
        return null;
    }

    public final PropertyStem getMappedProperty(String propertyName) {
        List<PropertyInfo> propertyInfos;
        if (this.getPropertyResolutionStyle().equals((Object)PropertyResolutionStyle.CASE_SENSITIVE)) {
            return this.stem.getMappedPropertyDescriptors().get(propertyName);
        }
        if (this.getPropertyResolutionStyle().equals((Object)PropertyResolutionStyle.CASE_INSENSITIVE)) {
            List<PropertyInfo> propertyInfos2 = this.stem.getMappedSmartPropertyTable().get(propertyName.toLowerCase(Locale.ENGLISH));
            return propertyInfos2 != null ? propertyInfos2.get(0).getDescriptor() : null;
        }
        if (this.getPropertyResolutionStyle().equals((Object)PropertyResolutionStyle.DISTINCT_CASE_INSENSITIVE) && (propertyInfos = this.stem.getMappedSmartPropertyTable().get(propertyName.toLowerCase(Locale.ENGLISH))) != null) {
            if (propertyInfos.size() != 1) {
                throw new EPException("Unable to determine which property to use for \"" + propertyName + "\" because more than one property matched");
            }
            return propertyInfos.get(0).getDescriptor();
        }
        return null;
    }

    public final PropertyStem getIndexedProperty(String propertyName) {
        List<PropertyInfo> propertyInfos;
        if (this.getPropertyResolutionStyle().equals((Object)PropertyResolutionStyle.CASE_SENSITIVE)) {
            return this.stem.getIndexedPropertyDescriptors().get(propertyName);
        }
        if (this.getPropertyResolutionStyle().equals((Object)PropertyResolutionStyle.CASE_INSENSITIVE)) {
            List<PropertyInfo> propertyInfos2 = this.stem.getIndexedSmartPropertyTable().get(propertyName.toLowerCase(Locale.ENGLISH));
            return propertyInfos2 != null ? propertyInfos2.get(0).getDescriptor() : null;
        }
        if (this.getPropertyResolutionStyle().equals((Object)PropertyResolutionStyle.DISTINCT_CASE_INSENSITIVE) && (propertyInfos = this.stem.getIndexedSmartPropertyTable().get(propertyName.toLowerCase(Locale.ENGLISH))) != null) {
            if (propertyInfos.size() != 1) {
                throw new EPException("Unable to determine which property to use for \"" + propertyName + "\" because more than one property matched");
            }
            return propertyInfos.get(0).getDescriptor();
        }
        return null;
    }

    @Override
    public String[] getPropertyNames() {
        return this.stem.getPropertyNames();
    }

    @Override
    public EventType[] getSuperTypes() {
        return this.superTypes;
    }

    @Override
    public Iterator<EventType> getDeepSuperTypes() {
        return this.deepSuperTypes.iterator();
    }

    public String toString() {
        return "BeanEventType name=" + this.getName() + " clazz=" + this.stem.getClazz().getName();
    }

    private PropertyInfo getSimplePropertyInfo(String propertyName) {
        if (this.getPropertyResolutionStyle().equals((Object)PropertyResolutionStyle.CASE_SENSITIVE)) {
            return this.stem.getSimpleProperties().get(propertyName);
        }
        if (this.getPropertyResolutionStyle().equals((Object)PropertyResolutionStyle.CASE_INSENSITIVE)) {
            PropertyInfo propertyInfo = this.stem.getSimpleProperties().get(propertyName);
            if (propertyInfo != null) {
                return propertyInfo;
            }
            List<PropertyInfo> simplePropertyInfoList = this.stem.getSimpleSmartPropertyTable().get(propertyName.toLowerCase(Locale.ENGLISH));
            return simplePropertyInfoList != null ? simplePropertyInfoList.get(0) : null;
        }
        if (this.getPropertyResolutionStyle().equals((Object)PropertyResolutionStyle.DISTINCT_CASE_INSENSITIVE)) {
            PropertyInfo propertyInfo = this.stem.getSimpleProperties().get(propertyName);
            if (propertyInfo != null) {
                return propertyInfo;
            }
            List<PropertyInfo> simplePropertyInfoList = this.stem.getSimpleSmartPropertyTable().get(propertyName.toLowerCase(Locale.ENGLISH));
            if (simplePropertyInfoList != null) {
                if (simplePropertyInfoList.size() != 1) {
                    throw new EPException("Unable to determine which property to use for \"" + propertyName + "\" because more than one property matched");
                }
                return simplePropertyInfoList.get(0);
            }
        }
        return null;
    }

    @Override
    public EventTypeMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public EventPropertyDescriptor[] getPropertyDescriptors() {
        return this.stem.getPropertyDescriptors();
    }

    @Override
    public FragmentEventType getFragmentType(String propertyExpression) {
        PropertyInfo simpleProp = this.getSimplePropertyInfo(propertyExpression);
        if (simpleProp != null && simpleProp.getClazz() != null) {
            GenericPropertyDesc genericProp = simpleProp.getDescriptor().getReturnTypeGeneric();
            return EventBeanUtility.createNativeFragmentType(genericProp.getType(), genericProp.getGeneric(), this.beanEventTypeFactory, this.stem.isPublicFields());
        }
        Property prop = PropertyParser.parseAndWalkLaxToSimple(propertyExpression);
        if (prop instanceof SimpleProperty) {
            return null;
        }
        GenericPropertyDesc genericProp = prop.getPropertyTypeGeneric(this, this.beanEventTypeFactory);
        if (genericProp == null) {
            return null;
        }
        return EventBeanUtility.createNativeFragmentType(genericProp.getType(), genericProp.getGeneric(), this.beanEventTypeFactory, this.stem.isPublicFields());
    }

    @Override
    public BeanEventPropertyWriter getWriter(String propertyName) {
        Pair<EventPropertyDescriptor, BeanEventPropertyWriter> pair;
        if (this.writeablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        if ((pair = this.writerMap.get(propertyName)) != null) {
            return pair.getSecond();
        }
        Property property = PropertyParser.parseAndWalkLaxToSimple(propertyName);
        if (property instanceof MappedProperty) {
            Method setterMethod;
            MappedProperty mapProp = (MappedProperty)property;
            String methodName = PropertyHelper.getSetterMethodName(mapProp.getPropertyNameAtomic());
            try {
                setterMethod = MethodResolver.resolveMethod(this.stem.getClazz(), methodName, new Class[]{String.class, Object.class}, true, new boolean[2], new boolean[2]);
            }
            catch (MethodResolverNoSuchMethodException e) {
                log.info("Failed to find mapped property setter method '" + methodName + "' for writing to property '" + propertyName + "' taking {String, Object} as parameters");
                return null;
            }
            if (setterMethod == null) {
                return null;
            }
            return new BeanEventPropertyWriterMapProp(this.stem.getClazz(), setterMethod, mapProp.getKey());
        }
        if (property instanceof IndexedProperty) {
            Method setterMethod;
            IndexedProperty indexedProp = (IndexedProperty)property;
            String methodName = PropertyHelper.getSetterMethodName(indexedProp.getPropertyNameAtomic());
            try {
                setterMethod = MethodResolver.resolveMethod(this.stem.getClazz(), methodName, new Class[]{Integer.TYPE, Object.class}, true, new boolean[2], new boolean[2]);
            }
            catch (MethodResolverNoSuchMethodException e) {
                log.info("Failed to find indexed property setter method '" + methodName + "' for writing to property '" + propertyName + "' taking {int, Object} as parameters");
                return null;
            }
            if (setterMethod == null) {
                return null;
            }
            return new BeanEventPropertyWriterIndexedProp(this.stem.getClazz(), setterMethod, indexedProp.getIndex());
        }
        return null;
    }

    @Override
    public EventPropertyDescriptor getWritableProperty(String propertyName) {
        Pair<EventPropertyDescriptor, BeanEventPropertyWriter> pair;
        if (this.writeablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        if ((pair = this.writerMap.get(propertyName)) != null) {
            return pair.getFirst();
        }
        Property property = PropertyParser.parseAndWalkLaxToSimple(propertyName);
        if (property instanceof MappedProperty) {
            BeanEventPropertyWriter writer = this.getWriter(propertyName);
            if (writer == null) {
                return null;
            }
            MappedProperty mapProp = (MappedProperty)property;
            return new EventPropertyDescriptor(mapProp.getPropertyNameAtomic(), Object.class, null, false, true, false, true, false);
        }
        if (property instanceof IndexedProperty) {
            BeanEventPropertyWriter writer = this.getWriter(propertyName);
            if (writer == null) {
                return null;
            }
            IndexedProperty indexedProp = (IndexedProperty)property;
            return new EventPropertyDescriptor(indexedProp.getPropertyNameAtomic(), Object.class, null, true, false, true, false, false);
        }
        return null;
    }

    @Override
    public EventPropertyDescriptor[] getWriteableProperties() {
        if (this.writeablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        return this.writeablePropertyDescriptors;
    }

    @Override
    public Set<EventType> getDeepSuperTypesAsSet() {
        return this.deepSuperTypes;
    }

    @Override
    public EventBeanCopyMethodForge getCopyMethodForge(String[] properties) {
        String copyMethodName;
        String string = copyMethodName = this.stem.getOptionalLegacyDef() == null ? null : this.stem.getOptionalLegacyDef().getCopyMethod();
        if (copyMethodName == null) {
            if (JavaClassHelper.isImplementsInterface(this.stem.getClazz(), Serializable.class)) {
                return new BeanEventBeanSerializableCopyMethodForge(this);
            }
            return null;
        }
        Method method = null;
        try {
            method = this.stem.getClazz().getMethod(copyMethodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            log.error("Configured copy-method for class '" + this.stem.getClazz().getName() + " not found by name '" + copyMethodName + "': " + e.getMessage());
        }
        if (method == null) {
            if (JavaClassHelper.isImplementsInterface(this.stem.getClazz(), Serializable.class)) {
                return new BeanEventBeanSerializableCopyMethodForge(this);
            }
            throw new EPException("Configured copy-method for class '" + this.stem.getClazz().getName() + " not found by name '" + copyMethodName + "' and class does not implement Serializable");
        }
        return new BeanEventBeanConfiguredCopyMethodForge(this, method);
    }

    @Override
    public EventBeanWriter getWriter(String[] properties) {
        if (this.writeablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        BeanEventPropertyWriter[] writers = new BeanEventPropertyWriter[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            Pair<EventPropertyDescriptor, BeanEventPropertyWriter> pair = this.writerMap.get(properties[i]);
            writers[i] = pair != null ? pair.getSecond() : this.getWriter(properties[i]);
        }
        return new BeanEventBeanWriter(writers);
    }

    public BeanEventTypeStem getStem() {
        return this.stem;
    }

    @Override
    public ExprValidationException equalsCompareType(EventType eventType) {
        if (this != eventType) {
            return new ExprValidationException("Bean event types mismatch");
        }
        return null;
    }

    private void initializeWriters() {
        Set<WriteablePropertyDescriptor> writables = PropertyHelper.getWritableProperties(this.stem.getClazz());
        EventPropertyDescriptor[] desc = new EventPropertyDescriptor[writables.size()];
        HashMap<String, Pair<EventPropertyDescriptor, BeanEventPropertyWriter>> writers = new HashMap<String, Pair<EventPropertyDescriptor, BeanEventPropertyWriter>>();
        int count = 0;
        for (WriteablePropertyDescriptor writable : writables) {
            EventPropertyDescriptor propertyDesc = new EventPropertyDescriptor(writable.getPropertyName(), writable.getType(), null, false, false, false, false, false);
            desc[count++] = propertyDesc;
            writers.put(writable.getPropertyName(), new Pair<EventPropertyDescriptor, BeanEventPropertyWriter>(propertyDesc, new BeanEventPropertyWriter(this.stem.getClazz(), writable.getWriteMethod())));
        }
        this.writerMap = writers;
        this.writeablePropertyDescriptors = desc;
    }
}

