/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.core;

import com.espertech.esper.common.client.configuration.Configuration;
import com.espertech.esper.common.client.configuration.ConfigurationException;
import com.espertech.esper.common.internal.event.bean.core.BeanEventTypeStemService;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.settings.ClasspathImportException;
import com.espertech.esper.common.internal.settings.ClasspathImportService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BeanEventTypeRepoUtil {
    public static BeanEventTypeStemService makeBeanEventTypeStemService(Configuration configurationSnapshot, Map<String, Class> resolvedBeanEventTypes, EventBeanTypedEventFactory eventBeanTypedEventFactory) {
        Map<Class, List<String>> publicClassToTypeNames = Collections.emptyMap();
        if (!resolvedBeanEventTypes.isEmpty()) {
            publicClassToTypeNames = new HashMap();
            for (Map.Entry<String, Class> entry : resolvedBeanEventTypes.entrySet()) {
                List<String> names = publicClassToTypeNames.get(entry.getValue());
                if (names == null) {
                    names = new ArrayList<String>(1);
                    publicClassToTypeNames.put(entry.getValue(), names);
                }
                names.add(entry.getKey());
            }
        }
        return new BeanEventTypeStemService(publicClassToTypeNames, eventBeanTypedEventFactory, configurationSnapshot.getCommon().getEventMeta().getClassPropertyResolutionStyle(), configurationSnapshot.getCommon().getEventMeta().getDefaultAccessorStyle());
    }

    public static Map<String, Class> resolveBeanEventTypes(Map<String, String> typeToClassName, ClasspathImportService classpathImportService) {
        if (typeToClassName.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Class> resolved = new LinkedHashMap<String, Class>();
        for (Map.Entry<String, String> entry : typeToClassName.entrySet()) {
            Class clazz;
            try {
                clazz = classpathImportService.resolveClassForBeanEventType(entry.getValue());
            }
            catch (ClasspathImportException ex) {
                throw new ConfigurationException("Class named '" + entry.getValue() + "' was not found", ex);
            }
            resolved.put(entry.getKey(), clazz);
        }
        return resolved;
    }
}

