/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.getter;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.event.bean.core.BeanEventPropertyGetter;
import com.espertech.esper.common.internal.event.bean.getter.BaseNativePropertyGetter;
import com.espertech.esper.common.internal.event.bean.getter.BeanFieldGetterHelper;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterAndIndexed;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.lang.reflect.Field;

public class ArrayFieldPropertyGetter
extends BaseNativePropertyGetter
implements BeanEventPropertyGetter,
EventPropertyGetterAndIndexed {
    private final Field field;
    private final int index;

    public ArrayFieldPropertyGetter(Field field, int index, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        super(eventBeanTypedEventFactory, beanEventTypeFactory, field.getType().getComponentType(), null);
        this.index = index;
        this.field = field;
        if (index < 0) {
            throw new IllegalArgumentException("Invalid negative index value");
        }
    }

    @Override
    public Object getBeanProp(Object object) throws PropertyAccessException {
        return BeanFieldGetterHelper.getFieldArray(this.field, object, this.index);
    }

    private CodegenMethod getBeanPropInternalCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return codegenMethodScope.makeChild(this.getBeanPropType(), this.getClass(), (CodegenScope)codegenClassScope).addParam(this.getTargetType(), "object").addParam(Integer.TYPE, "index").getBlock().declareVar(Object.class, "value", (CodegenExpression)CodegenExpressionBuilder.exprDotName(CodegenExpressionBuilder.ref("object"), this.field.getName())).methodReturn(CodegenExpressionBuilder.cast(this.getBeanPropType(), CodegenExpressionBuilder.staticMethod(CollectionUtil.class, "arrayValueAtIndex", CodegenExpressionBuilder.ref("value"), CodegenExpressionBuilder.ref("index"))));
    }

    @Override
    public boolean isBeanExistsProperty(Object object) {
        return true;
    }

    @Override
    public final Object get(EventBean obj) throws PropertyAccessException {
        return this.getBeanProp(obj.getUnderlying());
    }

    @Override
    public Object get(EventBean eventBean, int index) throws PropertyAccessException {
        return BeanFieldGetterHelper.getFieldArray(this.field, eventBean.getUnderlying(), index);
    }

    @Override
    public Class getBeanPropType() {
        return this.field.getType().getComponentType();
    }

    public String toString() {
        return "ArrayFieldPropertyGetter  field=" + this.field.toString() + " index=" + this.index;
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Class getTargetType() {
        return this.field.getDeclaringClass();
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.castUnderlying(this.getTargetType(), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.localMethod(this.getBeanPropInternalCodegen(codegenMethodScope, codegenClassScope), underlyingExpression, CodegenExpressionBuilder.constant(this.index));
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression eventBeanGetIndexedCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpression beanExpression, CodegenExpression key) {
        return CodegenExpressionBuilder.localMethod(this.getBeanPropInternalCodegen(codegenMethodScope, codegenClassScope), CodegenExpressionBuilder.castUnderlying(this.getTargetType(), beanExpression), key);
    }
}

