/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.getter;

import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.internal.event.util.PropertyUtility;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Field;

public class BeanFieldGetterHelper {
    public static Object getFieldSimple(Field field, Object object) {
        try {
            return field.get(object);
        }
        catch (IllegalArgumentException e) {
            throw PropertyUtility.getIllegalArgumentException(field, e);
        }
        catch (IllegalAccessException e) {
            throw PropertyUtility.getIllegalAccessException(field, e);
        }
    }

    public static Object getFieldMap(Field field, Object object, Object key) throws PropertyAccessException {
        try {
            Object result = field.get(object);
            return CollectionUtil.getMapValueChecked(result, key);
        }
        catch (ClassCastException e) {
            throw PropertyUtility.getMismatchException(field, object, e);
        }
        catch (IllegalAccessException e) {
            throw PropertyUtility.getIllegalAccessException(field, e);
        }
        catch (IllegalArgumentException e) {
            throw PropertyUtility.getIllegalArgumentException(field, e);
        }
    }

    public static Object getFieldArray(Field field, Object object, int index) throws PropertyAccessException {
        try {
            Object value = field.get(object);
            if (Array.getLength(value) <= index) {
                return null;
            }
            return Array.get(value, index);
        }
        catch (ClassCastException e) {
            throw PropertyUtility.getMismatchException(field, object, e);
        }
        catch (IllegalAccessException e) {
            throw PropertyUtility.getIllegalAccessException(field, e);
        }
        catch (IllegalArgumentException e) {
            throw PropertyUtility.getIllegalArgumentException(field, e);
        }
    }
}

