/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.getter;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.event.bean.core.DynamicPropertyDescriptorByMethod;
import com.espertech.esper.common.internal.event.bean.core.PropertyHelper;
import com.espertech.esper.common.internal.event.bean.getter.DynamicPropertyGetterByMethodBase;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.util.PropertyUtility;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public class DynamicMappedPropertyGetterByMethod
extends DynamicPropertyGetterByMethodBase {
    private final String getterMethodName;
    private final Object[] parameters;

    public DynamicMappedPropertyGetterByMethod(String fieldName, String key, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        super(eventBeanTypedEventFactory, beanEventTypeFactory);
        this.getterMethodName = PropertyHelper.getGetterMethodName(fieldName);
        this.parameters = new Object[]{key};
    }

    @Override
    public Method determineMethod(Class clazz) throws PropertyAccessException {
        return DynamicMappedPropertyGetterByMethod.dynamicMapperPropertyDetermineMethod(clazz, this.getterMethodName);
    }

    @Override
    protected CodegenExpression determineMethodCodegen(CodegenExpressionRef clazz, CodegenMethodScope parent, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.staticMethod(DynamicMappedPropertyGetterByMethod.class, "dynamicMapperPropertyDetermineMethod", clazz, CodegenExpressionBuilder.constant(this.getterMethodName));
    }

    @Override
    protected Object call(DynamicPropertyDescriptorByMethod descriptor, Object underlying) {
        return DynamicMappedPropertyGetterByMethod.dynamicMappedPropertyGet(descriptor, underlying, this.parameters);
    }

    @Override
    protected CodegenExpression callCodegen(CodegenExpressionRef desc, CodegenExpressionRef object, CodegenMethodScope parent, CodegenClassScope codegenClassScope) {
        CodegenExpressionField params = codegenClassScope.addFieldUnshared(true, Object[].class, CodegenExpressionBuilder.constant(this.parameters));
        return CodegenExpressionBuilder.staticMethod(DynamicMappedPropertyGetterByMethod.class, "dynamicMappedPropertyGet", desc, object, params);
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope parent, CodegenClassScope codegenClassScope) {
        CodegenExpressionField memberCache = codegenClassScope.addOrGetFieldSharable(this.sharableCode);
        CodegenMethod method = parent.makeChild(Boolean.TYPE, DynamicPropertyGetterByMethodBase.class, (CodegenScope)codegenClassScope).addParam(Object.class, "object");
        method.getBlock().declareVar(DynamicPropertyDescriptorByMethod.class, "desc", this.getPopulateCacheCodegen(memberCache, CodegenExpressionBuilder.ref("object"), method, codegenClassScope)).ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("desc"), "getMethod", new CodegenExpression[0]))).blockReturn(CodegenExpressionBuilder.constantFalse()).methodReturn(CodegenExpressionBuilder.staticMethod(DynamicMappedPropertyGetterByMethod.class, "dynamicMappedPropertyExists", CodegenExpressionBuilder.ref("desc"), CodegenExpressionBuilder.ref("object"), CodegenExpressionBuilder.constant(this.parameters[0])));
        return CodegenExpressionBuilder.localMethod(method, underlyingExpression);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        DynamicPropertyDescriptorByMethod desc = DynamicMappedPropertyGetterByMethod.getPopulateCache(this.cache, this, eventBean.getUnderlying(), this.eventBeanTypedEventFactory);
        if (desc.getMethod() == null) {
            return false;
        }
        return DynamicMappedPropertyGetterByMethod.dynamicMappedPropertyExists(desc, eventBean.getUnderlying(), (String)this.parameters[0]);
    }

    public static Method dynamicMapperPropertyDetermineMethod(Class clazz, String getterMethodName) throws PropertyAccessException {
        try {
            return clazz.getMethod(getterMethodName, String.class);
        }
        catch (NoSuchMethodException ex1) {
            Method method;
            try {
                method = clazz.getMethod(getterMethodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            if (method.getReturnType() != Map.class) {
                return null;
            }
            return method;
        }
    }

    public static Object dynamicMappedPropertyGet(DynamicPropertyDescriptorByMethod descriptor, Object underlying, Object[] parameters) {
        try {
            if (descriptor.isHasParameters()) {
                return descriptor.getMethod().invoke(underlying, parameters);
            }
            Object result = descriptor.getMethod().invoke(underlying, null);
            return CollectionUtil.getMapValueChecked(result, parameters[0]);
        }
        catch (ClassCastException e) {
            throw PropertyUtility.getMismatchException(descriptor.getMethod(), underlying, e);
        }
        catch (InvocationTargetException e) {
            throw PropertyUtility.getInvocationTargetException(descriptor.getMethod(), e);
        }
        catch (IllegalArgumentException e) {
            throw PropertyUtility.getIllegalArgumentException(descriptor.getMethod(), e);
        }
        catch (IllegalAccessException e) {
            throw PropertyUtility.getIllegalAccessException(descriptor.getMethod(), e);
        }
    }

    public static boolean dynamicMappedPropertyExists(DynamicPropertyDescriptorByMethod descriptor, Object underlying, String key) {
        try {
            if (descriptor.isHasParameters()) {
                return true;
            }
            Object result = descriptor.getMethod().invoke(underlying, null);
            return CollectionUtil.getMapKeyExistsChecked(result, key);
        }
        catch (ClassCastException e) {
            throw PropertyUtility.getMismatchException(descriptor.getMethod(), underlying, e);
        }
        catch (InvocationTargetException e) {
            throw PropertyUtility.getInvocationTargetException(descriptor.getMethod(), e);
        }
        catch (IllegalArgumentException e) {
            throw PropertyUtility.getIllegalArgumentException(descriptor.getMethod(), e);
        }
        catch (IllegalAccessException e) {
            throw PropertyUtility.getIllegalAccessException(descriptor.getMethod(), e);
        }
    }
}

