/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.instantiator;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.event.bean.instantiator.BeanInstantiator;
import com.espertech.esper.common.internal.event.bean.instantiator.BeanInstantiatorForge;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanInstantiatorForgeByReflection
implements BeanInstantiatorForge,
BeanInstantiator {
    private static final Logger log = LoggerFactory.getLogger(BeanInstantiatorForgeByReflection.class);
    private final Method method;

    public BeanInstantiatorForgeByReflection(Method method) {
        this.method = method;
    }

    @Override
    public Object instantiate() {
        try {
            return this.method.invoke(null, null);
        }
        catch (InvocationTargetException e) {
            String message = "Unexpected exception encountered invoking factory method '" + this.method.getName() + "' on class '" + this.method.getDeclaringClass().getName() + "': " + e.getTargetException().getMessage();
            log.error(message, (Throwable)e);
            return null;
        }
        catch (IllegalAccessException ex) {
            String message = "Unexpected exception encountered invoking factory method '" + this.method.getName() + "' on class '" + this.method.getDeclaringClass().getName() + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            return null;
        }
    }

    @Override
    public BeanInstantiator getBeanInstantiator() {
        return this;
    }

    @Override
    public CodegenExpression make(CodegenMethodScope parent, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.staticMethod(this.method.getDeclaringClass(), this.method.getName(), new CodegenExpression[0]);
    }
}

