/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.introspect;

import com.espertech.esper.common.client.EventPropertyDescriptor;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeBean;
import com.espertech.esper.common.client.util.PropertyResolutionStyle;
import com.espertech.esper.common.internal.event.bean.core.PropertyStem;
import com.espertech.esper.common.internal.event.bean.getter.ReflectionPropFieldGetterFactory;
import com.espertech.esper.common.internal.event.bean.getter.ReflectionPropMethodGetterFactory;
import com.espertech.esper.common.internal.event.bean.introspect.BeanEventTypeStem;
import com.espertech.esper.common.internal.event.bean.introspect.EventPropertyGetterSPIFactory;
import com.espertech.esper.common.internal.event.bean.introspect.PropertyInfo;
import com.espertech.esper.common.internal.event.bean.introspect.PropertyListBuilder;
import com.espertech.esper.common.internal.event.bean.introspect.PropertyListBuilderFactory;
import com.espertech.esper.common.internal.event.core.EventPropertyType;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class BeanEventTypeStemBuilder {
    private final ConfigurationCommonEventTypeBean optionalConfig;
    private final PropertyResolutionStyle propertyResolutionStyle;
    private final boolean smartResolutionStyle;

    public BeanEventTypeStemBuilder(ConfigurationCommonEventTypeBean optionalConfig, PropertyResolutionStyle defaultPropertyResolutionStyle) {
        this.optionalConfig = optionalConfig;
        this.propertyResolutionStyle = optionalConfig != null ? optionalConfig.getPropertyResolutionStyle() : defaultPropertyResolutionStyle;
        this.smartResolutionStyle = this.propertyResolutionStyle.equals((Object)PropertyResolutionStyle.CASE_INSENSITIVE) || this.propertyResolutionStyle.equals((Object)PropertyResolutionStyle.DISTINCT_CASE_INSENSITIVE);
    }

    public BeanEventTypeStem make(Class clazz) {
        EventTypeUtility.validateEventBeanClassVisibility(clazz);
        PropertyListBuilder propertyListBuilder = PropertyListBuilderFactory.createBuilder(this.optionalConfig);
        List<PropertyStem> properties = propertyListBuilder.assessProperties(clazz);
        EventPropertyDescriptor[] propertyDescriptors = new EventPropertyDescriptor[properties.size()];
        HashMap<String, EventPropertyDescriptor> propertyDescriptorMap = new HashMap<String, EventPropertyDescriptor>();
        String[] propertyNames = new String[properties.size()];
        HashMap<String, PropertyInfo> simpleProperties = new HashMap<String, PropertyInfo>();
        HashMap<String, PropertyStem> mappedPropertyDescriptors = new HashMap<String, PropertyStem>();
        HashMap<String, PropertyStem> indexedPropertyDescriptors = new HashMap<String, PropertyStem>();
        HashMap<String, List<PropertyInfo>> simpleSmartPropertyTable = null;
        HashMap<String, List<PropertyInfo>> mappedSmartPropertyTable = null;
        HashMap<String, List<PropertyInfo>> indexedSmartPropertyTable = null;
        if (this.smartResolutionStyle) {
            simpleSmartPropertyTable = new HashMap<String, List<PropertyInfo>>();
            mappedSmartPropertyTable = new HashMap<String, List<PropertyInfo>>();
            indexedSmartPropertyTable = new HashMap<String, List<PropertyInfo>>();
        }
        int count = 0;
        for (PropertyStem desc : properties) {
            PropertyInfo propertyInfo;
            List<PropertyInfo> propertyInfoList;
            String smartPropertyName;
            boolean isFragment;
            boolean isMapped;
            boolean isIndexed;
            boolean isRequiresMapkey;
            boolean isRequiresIndex;
            Class<Object> componentType;
            Class underlyingType;
            String propertyName = desc.getPropertyName();
            if (desc.getPropertyType().equals((Object)EventPropertyType.SIMPLE)) {
                Class type;
                EventPropertyGetterSPIFactory getter;
                if (desc.getReadMethod() != null) {
                    getter = new ReflectionPropMethodGetterFactory(desc.getReadMethod());
                    type = desc.getReadMethod().getReturnType();
                } else {
                    if (desc.getAccessorField() == null) continue;
                    getter = new ReflectionPropFieldGetterFactory(desc.getAccessorField());
                    type = desc.getAccessorField().getType();
                }
                underlyingType = type;
                componentType = null;
                isRequiresIndex = false;
                isRequiresMapkey = false;
                isIndexed = false;
                isMapped = false;
                if (JavaClassHelper.isImplementsInterface(type, Map.class)) {
                    isMapped = true;
                    isFragment = false;
                    componentType = desc.getReadMethod() != null ? JavaClassHelper.getGenericReturnTypeMap(desc.getReadMethod(), false) : (desc.getAccessorField() != null ? JavaClassHelper.getGenericFieldTypeMap(desc.getAccessorField(), false) : Object.class);
                } else if (type.isArray()) {
                    isIndexed = true;
                    isFragment = JavaClassHelper.isFragmentableType(type.getComponentType());
                    componentType = type.getComponentType();
                } else if (JavaClassHelper.isImplementsInterface(type, Iterable.class)) {
                    isIndexed = true;
                    Class genericType = JavaClassHelper.getGenericReturnType(desc.getReadMethod(), desc.getAccessorField(), true);
                    isFragment = JavaClassHelper.isFragmentableType(genericType);
                    componentType = genericType != null ? genericType : Object.class;
                } else {
                    isMapped = false;
                    isFragment = JavaClassHelper.isFragmentableType(type);
                }
                simpleProperties.put(propertyName, new PropertyInfo(type, getter, desc));
                if (this.smartResolutionStyle) {
                    String smartPropertyName2 = propertyName.toLowerCase(Locale.ENGLISH);
                    ArrayList<PropertyInfo> propertyInfoList2 = (ArrayList<PropertyInfo>)simpleSmartPropertyTable.get(smartPropertyName2);
                    if (propertyInfoList2 == null) {
                        propertyInfoList2 = new ArrayList<PropertyInfo>();
                        simpleSmartPropertyTable.put(smartPropertyName2, propertyInfoList2);
                    }
                    PropertyInfo propertyInfo2 = new PropertyInfo(type, getter, desc);
                    propertyInfoList2.add(propertyInfo2);
                }
            } else if (desc.getPropertyType().equals((Object)EventPropertyType.MAPPED)) {
                mappedPropertyDescriptors.put(propertyName, desc);
                underlyingType = desc.getReturnType();
                componentType = Object.class;
                isRequiresIndex = false;
                isRequiresMapkey = desc.getReadMethod().getParameterTypes().length > 0;
                isIndexed = false;
                isMapped = true;
                isFragment = false;
                if (this.smartResolutionStyle) {
                    smartPropertyName = propertyName.toLowerCase(Locale.ENGLISH);
                    propertyInfoList = (ArrayList)mappedSmartPropertyTable.get(smartPropertyName);
                    if (propertyInfoList == null) {
                        propertyInfoList = new ArrayList();
                        mappedSmartPropertyTable.put(smartPropertyName, propertyInfoList);
                    }
                    propertyInfo = new PropertyInfo(desc.getReturnType(), null, desc);
                    propertyInfoList.add(propertyInfo);
                }
            } else {
                if (!desc.getPropertyType().equals((Object)EventPropertyType.INDEXED)) continue;
                indexedPropertyDescriptors.put(propertyName, desc);
                underlyingType = desc.getReturnType();
                componentType = null;
                isRequiresIndex = desc.getReadMethod().getParameterTypes().length > 0;
                isRequiresMapkey = false;
                isIndexed = true;
                isMapped = false;
                isFragment = JavaClassHelper.isFragmentableType(desc.getReturnType());
                if (this.smartResolutionStyle) {
                    smartPropertyName = propertyName.toLowerCase(Locale.ENGLISH);
                    propertyInfoList = (List)indexedSmartPropertyTable.get(smartPropertyName);
                    if (propertyInfoList == null) {
                        propertyInfoList = new ArrayList();
                        indexedSmartPropertyTable.put(smartPropertyName, propertyInfoList);
                    }
                    propertyInfo = new PropertyInfo(desc.getReturnType(), null, desc);
                    propertyInfoList.add(propertyInfo);
                }
            }
            propertyNames[count] = desc.getPropertyName();
            EventPropertyDescriptor descriptor = new EventPropertyDescriptor(desc.getPropertyName(), underlyingType, componentType, isRequiresIndex, isRequiresMapkey, isIndexed, isMapped, isFragment);
            propertyDescriptors[count++] = descriptor;
            propertyDescriptorMap.put(descriptor.getPropertyName(), descriptor);
        }
        Class[] superTypes = BeanEventTypeStemBuilder.getSuperTypes(clazz);
        if (superTypes != null && superTypes.length == 0) {
            superTypes = null;
        }
        HashSet<Class> deepSuperTypes = new HashSet<Class>();
        BeanEventTypeStemBuilder.getSuper(clazz, deepSuperTypes);
        BeanEventTypeStemBuilder.removeJavaLibInterfaces(deepSuperTypes);
        return new BeanEventTypeStem(clazz, this.optionalConfig, propertyNames, simpleProperties, mappedPropertyDescriptors, indexedPropertyDescriptors, superTypes, deepSuperTypes, this.propertyResolutionStyle, simpleSmartPropertyTable, indexedSmartPropertyTable, mappedSmartPropertyTable, propertyDescriptors, propertyDescriptorMap);
    }

    private static Class[] getSuperTypes(Class clazz) {
        LinkedList superclasses = new LinkedList();
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            superclasses.add(superClass);
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        superclasses.addAll(Arrays.asList(interfaces));
        LinkedList<Class> superTypes = new LinkedList<Class>();
        for (Class clazz2 : superclasses) {
            String superclassName = clazz2.getName();
            if (superclassName.startsWith("java")) continue;
            superTypes.add(clazz2);
        }
        return superTypes.toArray(new Class[superTypes.size()]);
    }

    protected static void getSuper(Class clazz, Set<Class> result) {
        BeanEventTypeStemBuilder.getSuperInterfaces(clazz, result);
        BeanEventTypeStemBuilder.getSuperClasses(clazz, result);
    }

    private static void getSuperInterfaces(Class clazz, Set<Class> result) {
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            result.add(interfaces[i]);
            BeanEventTypeStemBuilder.getSuperInterfaces(interfaces[i], result);
        }
    }

    private static void getSuperClasses(Class clazz, Set<Class> result) {
        Class superClass = clazz.getSuperclass();
        if (superClass == null) {
            return;
        }
        result.add(superClass);
        BeanEventTypeStemBuilder.getSuper(superClass, result);
    }

    private static void removeJavaLibInterfaces(Set<Class> classes) {
        for (Class clazz : classes.toArray(new Class[0])) {
            if (!clazz.getName().startsWith("java")) continue;
            classes.remove(clazz);
        }
    }
}

