/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.introspect;

import com.espertech.esper.common.client.configuration.ConfigurationException;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeBean;
import com.espertech.esper.common.internal.event.bean.core.PropertyStem;
import com.espertech.esper.common.internal.event.bean.introspect.PropertyListBuilder;
import com.espertech.esper.common.internal.event.core.EventPropertyType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;

public class PropertyListBuilderExplicit
implements PropertyListBuilder {
    private ConfigurationCommonEventTypeBean legacyConfig;

    public PropertyListBuilderExplicit(ConfigurationCommonEventTypeBean legacyConfig) {
        if (legacyConfig == null) {
            throw new IllegalArgumentException("Required configuration not passed");
        }
        this.legacyConfig = legacyConfig;
    }

    @Override
    public List<PropertyStem> assessProperties(Class clazz) {
        LinkedList<PropertyStem> result = new LinkedList<PropertyStem>();
        PropertyListBuilderExplicit.getExplicitProperties(result, clazz, this.legacyConfig);
        return result;
    }

    protected static void getExplicitProperties(List<PropertyStem> result, Class clazz, ConfigurationCommonEventTypeBean legacyConfig) {
        for (ConfigurationCommonEventTypeBean.LegacyFieldPropDesc legacyFieldPropDesc : legacyConfig.getFieldProperties()) {
            result.add(PropertyListBuilderExplicit.makeDesc(clazz, legacyFieldPropDesc));
        }
        for (ConfigurationCommonEventTypeBean.LegacyMethodPropDesc legacyMethodPropDesc : legacyConfig.getMethodProperties()) {
            result.add(PropertyListBuilderExplicit.makeDesc(clazz, legacyMethodPropDesc));
        }
    }

    private static PropertyStem makeDesc(Class clazz, ConfigurationCommonEventTypeBean.LegacyMethodPropDesc methodDesc) {
        Method[] methods = clazz.getMethods();
        Method method = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodDesc.getAccessorMethodName()) || methods[i].getReturnType() == Void.TYPE || methods[i].getParameterTypes().length >= 2) continue;
            if (methods[i].getParameterTypes().length == 0) {
                method = methods[i];
                break;
            }
            Class<?> parameterType = methods[i].getParameterTypes()[0];
            if (parameterType != Integer.TYPE && parameterType != Integer.class && parameterType != String.class) continue;
            method = methods[i];
            break;
        }
        if (method == null) {
            throw new ConfigurationException("Configured method named '" + methodDesc.getAccessorMethodName() + "' not found for class " + clazz.getName());
        }
        return PropertyListBuilderExplicit.makeMethodDesc(method, methodDesc.getName());
    }

    private static PropertyStem makeDesc(Class clazz, ConfigurationCommonEventTypeBean.LegacyFieldPropDesc fieldDesc) {
        Field field;
        try {
            field = clazz.getField(fieldDesc.getAccessorFieldName());
        }
        catch (NoSuchFieldException ex) {
            throw new ConfigurationException("Configured field named '" + fieldDesc.getAccessorFieldName() + "' not found for class " + clazz.getName());
        }
        return PropertyListBuilderExplicit.makeFieldDesc(field, fieldDesc.getName());
    }

    protected static PropertyStem makeFieldDesc(Field field, String name) {
        return new PropertyStem(name, field, EventPropertyType.SIMPLE);
    }

    protected static PropertyStem makeMethodDesc(Method method, String name) {
        Class<?> parameterType;
        EventPropertyType propertyType = method.getParameterTypes().length == 1 ? ((parameterType = method.getParameterTypes()[0]) == String.class ? EventPropertyType.MAPPED : EventPropertyType.INDEXED) : EventPropertyType.SIMPLE;
        return new PropertyStem(name, method, propertyType);
    }
}

