/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.manufacturer;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.bean.manufacturer.EventBeanManufacturerCtor;
import com.espertech.esper.common.internal.event.core.EventBeanManufacturer;
import com.espertech.esper.common.internal.event.core.EventBeanManufacturerForge;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactoryCodegenField;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import java.lang.reflect.Constructor;
import java.util.Arrays;

public class EventBeanManufacturerCtorForge
implements EventBeanManufacturerForge {
    private final Constructor constructor;
    private final BeanEventType beanEventType;

    public EventBeanManufacturerCtorForge(Constructor constructor, BeanEventType beanEventType) {
        this.constructor = constructor;
        this.beanEventType = beanEventType;
    }

    @Override
    public CodegenExpression make(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        CodegenExpressionField factory = codegenClassScope.addOrGetFieldSharable(EventBeanTypedEventFactoryCodegenField.INSTANCE);
        CodegenExpressionField beanType = codegenClassScope.addFieldUnshared(true, EventType.class, EventTypeUtility.resolveTypeCodegen(this.beanEventType, EPStatementInitServices.REF));
        CodegenExpression ctor = CodegenExpressionBuilder.staticMethod(EventBeanManufacturerCtorForge.class, "resolveConstructor", CodegenExpressionBuilder.constant(this.constructor.getParameterTypes()), CodegenExpressionBuilder.constant(this.constructor.getDeclaringClass()));
        return CodegenExpressionBuilder.newInstance(EventBeanManufacturerCtor.class, ctor, beanType, factory);
    }

    @Override
    public EventBeanManufacturer getManufacturer(EventBeanTypedEventFactory eventBeanTypedEventFactory) {
        return new EventBeanManufacturerCtor(this.constructor, this.beanEventType, eventBeanTypedEventFactory);
    }

    public static Constructor resolveConstructor(Class[] classes, Class declaring) {
        try {
            return declaring.getConstructor(classes);
        }
        catch (Throwable t) {
            throw new EPException("Failed to resolve constructor for class " + declaring.getClass() + " params " + Arrays.toString(classes));
        }
    }
}

