/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.manufacturer;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.event.bean.instantiator.BeanInstantiator;
import com.espertech.esper.common.internal.event.bean.instantiator.BeanInstantiatorForgeByNewInstanceReflection;
import com.espertech.esper.common.internal.event.core.EventBeanManufactureException;
import com.espertech.esper.common.internal.event.core.EventBeanManufacturer;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.WriteablePropertyDescriptor;
import com.espertech.esper.common.internal.event.json.compiletime.JsonUnderlyingField;
import com.espertech.esper.common.internal.event.json.core.JsonEventType;
import com.espertech.esper.common.internal.settings.ClasspathImportService;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBeanManufacturerJsonProvided
implements EventBeanManufacturer {
    private static final Logger log = LoggerFactory.getLogger(EventBeanManufacturerJsonProvided.class);
    private final BeanInstantiator beanInstantiator;
    private final JsonEventType jsonEventType;
    private final EventBeanTypedEventFactory service;
    private final Field[] writeFieldsReflection;
    private final boolean hasPrimitiveTypes;
    private final boolean[] primitiveType;

    public EventBeanManufacturerJsonProvided(JsonEventType jsonEventType, EventBeanTypedEventFactory service, WriteablePropertyDescriptor[] properties, ClasspathImportService classpathImportService) throws EventBeanManufactureException {
        this.jsonEventType = jsonEventType;
        this.service = service;
        this.beanInstantiator = new BeanInstantiatorForgeByNewInstanceReflection(jsonEventType.getUnderlyingType());
        this.writeFieldsReflection = new Field[properties.length];
        boolean primitiveTypeCheck = false;
        this.primitiveType = new boolean[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            String propertyName = properties[i].getPropertyName();
            JsonUnderlyingField field = jsonEventType.getDetail().getFieldDescriptors().get(propertyName);
            this.writeFieldsReflection[i] = field.getOptionalField();
            this.primitiveType[i] = properties[i].getType().isPrimitive();
            primitiveTypeCheck |= this.primitiveType[i];
        }
        this.hasPrimitiveTypes = primitiveTypeCheck;
    }

    @Override
    public EventBean make(Object[] propertyValues) {
        Object outObject = this.makeUnderlying(propertyValues);
        return this.service.adapterForTypedJson(outObject, this.jsonEventType);
    }

    @Override
    public Object makeUnderlying(Object[] propertyValues) {
        Object outObject = this.beanInstantiator.instantiate();
        if (!this.hasPrimitiveTypes) {
            for (int i = 0; i < this.writeFieldsReflection.length; ++i) {
                try {
                    this.writeFieldsReflection[i].set(outObject, propertyValues[i]);
                    continue;
                }
                catch (IllegalAccessException e) {
                    this.handle(e, this.writeFieldsReflection[i].getName());
                }
            }
        } else {
            for (int i = 0; i < this.writeFieldsReflection.length; ++i) {
                if (this.primitiveType[i] && propertyValues[i] == null) continue;
                try {
                    this.writeFieldsReflection[i].set(outObject, propertyValues[i]);
                    continue;
                }
                catch (IllegalAccessException e) {
                    this.handle(e, this.writeFieldsReflection[i].getName());
                }
            }
        }
        return outObject;
    }

    private void handle(IllegalAccessException ex, String fieldName) {
        String message = "Unexpected exception encountered invoking setter for field '" + fieldName + "' on class '" + this.jsonEventType.getUnderlyingType().getName() + "' : " + ex.getMessage();
        log.error(message, (Throwable)ex);
    }
}

