/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.manufacturer;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewAnonymousClass;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.event.bean.instantiator.BeanInstantiatorForge;
import com.espertech.esper.common.internal.event.bean.instantiator.BeanInstantiatorForgeByNewInstanceReflection;
import com.espertech.esper.common.internal.event.bean.manufacturer.EventBeanManufacturerJsonProvided;
import com.espertech.esper.common.internal.event.core.EventBeanManufactureException;
import com.espertech.esper.common.internal.event.core.EventBeanManufacturer;
import com.espertech.esper.common.internal.event.core.EventBeanManufacturerForge;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactoryCodegenField;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.core.WriteablePropertyDescriptor;
import com.espertech.esper.common.internal.event.json.compiletime.JsonUnderlyingField;
import com.espertech.esper.common.internal.event.json.core.JsonEventType;
import com.espertech.esper.common.internal.settings.ClasspathImportService;
import com.espertech.esper.common.internal.util.SimpleTypeCaster;
import com.espertech.esper.common.internal.util.SimpleTypeCasterFactory;
import java.lang.reflect.Field;

public class EventBeanManufacturerJsonProvidedForge
implements EventBeanManufacturerForge {
    private final BeanInstantiatorForge beanInstantiator;
    private final JsonEventType jsonEventType;
    private final WriteablePropertyDescriptor[] properties;
    private final ClasspathImportService classpathImportService;
    private final Field[] writeFieldReflection;
    private final boolean[] primitiveType;

    public EventBeanManufacturerJsonProvidedForge(JsonEventType jsonEventType, WriteablePropertyDescriptor[] properties, ClasspathImportService classpathImportService) throws EventBeanManufactureException {
        this.jsonEventType = jsonEventType;
        this.properties = properties;
        this.classpathImportService = classpathImportService;
        this.beanInstantiator = new BeanInstantiatorForgeByNewInstanceReflection(jsonEventType.getUnderlyingType());
        this.writeFieldReflection = new Field[properties.length];
        this.primitiveType = new boolean[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            String propertyName = properties[i].getPropertyName();
            JsonUnderlyingField field = jsonEventType.getDetail().getFieldDescriptors().get(propertyName);
            this.writeFieldReflection[i] = field.getOptionalField();
            this.primitiveType[i] = properties[i].getType().isPrimitive();
        }
    }

    @Override
    public EventBeanManufacturer getManufacturer(EventBeanTypedEventFactory eventBeanTypedEventFactory) throws EventBeanManufactureException {
        return new EventBeanManufacturerJsonProvided(this.jsonEventType, eventBeanTypedEventFactory, this.properties, this.classpathImportService);
    }

    @Override
    public CodegenExpression make(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        CodegenMethod init = codegenClassScope.getPackageScope().getInitMethod();
        CodegenExpressionField factory = codegenClassScope.addOrGetFieldSharable(EventBeanTypedEventFactoryCodegenField.INSTANCE);
        CodegenExpressionField beanType = codegenClassScope.addFieldUnshared(true, EventType.class, EventTypeUtility.resolveTypeCodegen(this.jsonEventType, EPStatementInitServices.REF));
        CodegenExpressionNewAnonymousClass manufacturer = CodegenExpressionBuilder.newAnonymousClass(init.getBlock(), EventBeanManufacturer.class);
        CodegenMethod makeUndMethod = CodegenMethod.makeParentNode(Object.class, this.getClass(), codegenClassScope).addParam(Object[].class, "properties");
        manufacturer.addMethod("makeUnderlying", makeUndMethod);
        this.makeUnderlyingCodegen(makeUndMethod, codegenClassScope);
        CodegenMethod makeMethod = CodegenMethod.makeParentNode(EventBean.class, this.getClass(), codegenClassScope).addParam(Object[].class, "properties");
        manufacturer.addMethod("make", makeMethod);
        makeMethod.getBlock().declareVar(Object.class, "und", (CodegenExpression)CodegenExpressionBuilder.localMethod(makeUndMethod, CodegenExpressionBuilder.ref("properties"))).methodReturn(CodegenExpressionBuilder.exprDotMethod(factory, "adapterForTypedJson", CodegenExpressionBuilder.ref("und"), beanType));
        return codegenClassScope.addFieldUnshared(true, EventBeanManufacturer.class, manufacturer);
    }

    private void makeUnderlyingCodegen(CodegenMethod method, CodegenClassScope codegenClassScope) {
        method.getBlock().declareVar(this.jsonEventType.getUnderlyingType(), "und", CodegenExpressionBuilder.cast(this.jsonEventType.getUnderlyingType(), this.beanInstantiator.make(method, codegenClassScope))).declareVar(Object.class, "value", CodegenExpressionBuilder.constantNull());
        for (int i = 0; i < this.writeFieldReflection.length; ++i) {
            CodegenExpression value;
            method.getBlock().assignRef("value", CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("properties"), CodegenExpressionBuilder.constant(i)));
            Class<?> targetType = this.writeFieldReflection[i].getType();
            if (targetType.isPrimitive()) {
                SimpleTypeCaster caster = SimpleTypeCasterFactory.getCaster(Object.class, targetType);
                value = caster.codegen(CodegenExpressionBuilder.ref("value"), Object.class, method, codegenClassScope);
            } else {
                value = CodegenExpressionBuilder.cast(targetType, (CodegenExpression)CodegenExpressionBuilder.ref("value"));
            }
            CodegenExpression set = CodegenExpressionBuilder.assign(CodegenExpressionBuilder.exprDotName(CodegenExpressionBuilder.ref("und"), this.writeFieldReflection[i].getName()), value);
            if (this.primitiveType[i]) {
                method.getBlock().ifRefNotNull("value").expression(set).blockEnd();
                continue;
            }
            method.getBlock().expression(set);
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("und"));
    }
}

