/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.manufacturer;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.settings.ClasspathImportException;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceCompileTime;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;

public class InstanceManufacturerUtil {
    public static Pair<Constructor, ExprForge[]> getManufacturer(Class targetClass, ClasspathImportServiceCompileTime classpathImportService, ExprForge[] exprForges, Object[] expressionReturnTypes) throws ExprValidationException {
        Class[] ctorTypes = new Class[expressionReturnTypes.length];
        ExprForge[] forges = new ExprForge[exprForges.length];
        for (int i = 0; i < expressionReturnTypes.length; ++i) {
            ExprForge inner;
            EventType columnEventType;
            Object columnType = expressionReturnTypes[i];
            if (columnType instanceof Class || columnType == null) {
                ctorTypes[i] = (Class)expressionReturnTypes[i];
                forges[i] = exprForges[i];
                continue;
            }
            if (columnType instanceof EventType) {
                columnEventType = (EventType)columnType;
                Class returnType = columnEventType.getUnderlyingType();
                inner = exprForges[i];
                forges[i] = new InstanceManufacturerForgeNonArray(returnType, inner);
                ctorTypes[i] = returnType;
                continue;
            }
            if (columnType instanceof EventType[]) {
                columnEventType = ((EventType[])columnType)[0];
                Class componentReturnType = columnEventType.getUnderlyingType();
                inner = exprForges[i];
                forges[i] = new InstanceManufacturerForgeArray(componentReturnType, inner);
                continue;
            }
            String message = "Invalid assignment of expression " + i + " returning type '" + columnType + "', column and parameter types mismatch";
            throw new ExprValidationException(message);
        }
        try {
            Constructor ctor = classpathImportService.resolveCtor(targetClass, ctorTypes);
            return new Pair<Constructor, ExprForge[]>(ctor, forges);
        }
        catch (ClasspathImportException ex) {
            throw new ExprValidationException("Failed to find a suitable constructor for class '" + targetClass.getName() + "': " + ex.getMessage(), ex);
        }
    }

    public static class InstanceManufacturerForgeArray
    implements ExprForge,
    ExprNodeRenderable {
        private final Class componentReturnType;
        private final ExprForge innerForge;

        InstanceManufacturerForgeArray(Class componentReturnType, ExprForge innerForge) {
            this.componentReturnType = componentReturnType;
            this.innerForge = innerForge;
        }

        @Override
        public ExprEvaluator getExprEvaluator() {
            final ExprEvaluator inner = this.innerForge.getExprEvaluator();
            return new ExprEvaluator(){

                @Override
                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                    Object result = inner.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                    if (!(result instanceof EventBean[])) {
                        return null;
                    }
                    EventBean[] events = (EventBean[])result;
                    Object values = Array.newInstance(componentReturnType, events.length);
                    for (int i = 0; i < events.length; ++i) {
                        Array.set(values, i, events[i].getUnderlying());
                    }
                    return values;
                }
            };
        }

        @Override
        public ExprForgeConstantType getForgeConstantType() {
            return ExprForgeConstantType.NONCONST;
        }

        @Override
        public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            Class arrayType = JavaClassHelper.getArrayType(this.componentReturnType);
            CodegenMethod methodNode = codegenMethodScope.makeChild(arrayType, InstanceManufacturerForgeArray.class, (CodegenScope)codegenClassScope);
            methodNode.getBlock().declareVar(Object.class, "result", this.innerForge.evaluateCodegen(requiredType, methodNode, exprSymbol, codegenClassScope)).ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.instanceOf(CodegenExpressionBuilder.ref("result"), EventBean[].class))).blockReturn(CodegenExpressionBuilder.constantNull()).declareVar(EventBean[].class, "events", CodegenExpressionBuilder.cast(EventBean[].class, (CodegenExpression)CodegenExpressionBuilder.ref("result"))).declareVar(arrayType, "values", CodegenExpressionBuilder.newArrayByLength(this.componentReturnType, CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("events")))).forLoopIntSimple("i", CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("events"))).assignArrayElement("values", (CodegenExpression)CodegenExpressionBuilder.ref("i"), CodegenExpressionBuilder.cast(this.componentReturnType, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("events"), CodegenExpressionBuilder.ref("i")), "getUnderlying", new CodegenExpression[0]))).blockEnd().methodReturn(CodegenExpressionBuilder.ref("values"));
            return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
        }

        @Override
        public Class getEvaluationType() {
            return JavaClassHelper.getArrayType(this.componentReturnType);
        }

        @Override
        public ExprNodeRenderable getForgeRenderable() {
            return this;
        }

        @Override
        public void toEPL(StringWriter writer, ExprPrecedenceEnum parentPrecedence, ExprNodeRenderableFlags flags) {
            writer.append(this.getClass().getSimpleName());
        }
    }

    public static class InstanceManufacturerForgeNonArray
    implements ExprForge {
        private final Class returnType;
        private final ExprForge innerForge;

        InstanceManufacturerForgeNonArray(Class returnType, ExprForge innerForge) {
            this.returnType = returnType;
            this.innerForge = innerForge;
        }

        @Override
        public ExprEvaluator getExprEvaluator() {
            final ExprEvaluator inner = this.innerForge.getExprEvaluator();
            return new ExprEvaluator(){

                @Override
                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                    EventBean event = (EventBean)inner.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                    if (event != null) {
                        return event.getUnderlying();
                    }
                    return null;
                }
            };
        }

        @Override
        public ExprForgeConstantType getForgeConstantType() {
            return ExprForgeConstantType.NONCONST;
        }

        @Override
        public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethod methodNode = codegenMethodScope.makeChild(this.returnType, InstanceManufacturerForgeNonArray.class, (CodegenScope)codegenClassScope);
            methodNode.getBlock().declareVar(EventBean.class, "event", CodegenExpressionBuilder.cast(EventBean.class, this.innerForge.evaluateCodegen(requiredType, methodNode, exprSymbol, codegenClassScope))).ifRefNullReturnNull("event").methodReturn(CodegenExpressionBuilder.cast(this.returnType, CodegenExpressionBuilder.exprDotUnderlying(CodegenExpressionBuilder.ref("event"))));
            return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
        }

        @Override
        public Class getEvaluationType() {
            return this.returnType;
        }

        @Override
        public ExprNodeRenderable getForgeRenderable() {
            return this.innerForge.getForgeRenderable();
        }
    }
}

