/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.hook.expr.EventBeanService;
import com.espertech.esper.common.internal.collection.PathException;
import com.espertech.esper.common.internal.collection.PathRegistry;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.eventtyperepo.EventTypeRepositoryImpl;
import java.util.Map;
import org.w3c.dom.Node;

public class EventBeanServiceImpl
implements EventBeanService {
    private final EventTypeRepositoryImpl eventTypeRepositoryPreconfigured;
    private final PathRegistry<String, EventType> pathEventTypes;
    private final EventBeanTypedEventFactory typedEventFactory;

    public EventBeanServiceImpl(EventTypeRepositoryImpl eventTypeRepositoryPreconfigured, PathRegistry<String, EventType> pathEventTypes, EventBeanTypedEventFactory typedEventFactory) {
        this.eventTypeRepositoryPreconfigured = eventTypeRepositoryPreconfigured;
        this.pathEventTypes = pathEventTypes;
        this.typedEventFactory = typedEventFactory;
    }

    @Override
    public EventBean adapterForMap(Map<String, Object> theEvent, String eventTypeName) {
        EventType eventType = this.findType(eventTypeName);
        return this.typedEventFactory.adapterForTypedMap(theEvent, eventType);
    }

    @Override
    public EventBean adapterForBean(Object theEvent, String eventTypeName) {
        EventType eventType = this.findType(eventTypeName);
        return this.typedEventFactory.adapterForTypedBean(theEvent, eventType);
    }

    @Override
    public EventBean adapterForAvro(Object avroGenericDataDotRecord, String eventTypeName) {
        EventType eventType = this.findType(eventTypeName);
        return this.typedEventFactory.adapterForTypedAvro(avroGenericDataDotRecord, eventType);
    }

    @Override
    public EventBean adapterForObjectArray(Object[] theEvent, String eventTypeName) {
        EventType eventType = this.findType(eventTypeName);
        return this.typedEventFactory.adapterForTypedObjectArray(theEvent, eventType);
    }

    @Override
    public EventBean adapterForDOM(Node node, String eventTypeName) {
        EventType eventType = this.findType(eventTypeName);
        return this.typedEventFactory.adapterForTypedDOM(node, eventType);
    }

    @Override
    public EventType getExistsTypeByName(String eventTypeName) {
        return this.findTypeMayNull(eventTypeName);
    }

    @Override
    public EventBean adapterForTypedBean(Object bean, EventType eventType) {
        return this.typedEventFactory.adapterForTypedBean(bean, eventType);
    }

    @Override
    public EventBean adapterForTypedAvro(Object avroGenericDataDotRecord, EventType eventType) {
        return this.typedEventFactory.adapterForTypedAvro(avroGenericDataDotRecord, eventType);
    }

    @Override
    public EventBean adapterForTypedMap(Map<String, Object> properties, EventType eventType) {
        return this.typedEventFactory.adapterForTypedMap(properties, eventType);
    }

    @Override
    public EventBean adapterForTypedObjectArray(Object[] props, EventType eventType) {
        return this.typedEventFactory.adapterForTypedObjectArray(props, eventType);
    }

    @Override
    public EventBean adapterForTypedDOM(Node node, EventType eventType) {
        return this.typedEventFactory.adapterForTypedDOM(node, eventType);
    }

    private EventType findType(String eventTypeName) {
        EventType eventType = this.findTypeMayNull(eventTypeName);
        if (eventType == null) {
            throw new EPException("Failed to find event type '" + eventTypeName + "'");
        }
        return eventType;
    }

    private EventType findTypeMayNull(String eventTypeName) {
        EventType eventType = this.eventTypeRepositoryPreconfigured.getTypeByName(eventTypeName);
        if (eventType != null) {
            return eventType;
        }
        try {
            eventType = this.pathEventTypes.getAnyModuleExpectSingle(eventTypeName, null).getFirst();
        }
        catch (PathException ex) {
            throw new EPException("Failed to obtain event type '" + eventTypeName + "': " + ex.getMessage(), ex);
        }
        return eventType;
    }
}

