/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.core;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.collection.PathException;
import com.espertech.esper.common.internal.collection.PathRegistry;
import com.espertech.esper.common.internal.collection.PathRegistryObjectType;
import com.espertech.esper.common.internal.context.module.EventTypeCompileTimeRegistry;
import com.espertech.esper.common.internal.context.module.ModuleDependenciesCompileTime;
import com.espertech.esper.common.internal.epl.util.CompileTimeResolver;
import com.espertech.esper.common.internal.event.core.EventTypeNameResolver;
import com.espertech.esper.common.internal.event.eventtyperepo.EventTypeRepositoryImpl;
import java.util.Set;

public class EventTypeCompileTimeResolver
implements EventTypeNameResolver,
CompileTimeResolver {
    private final String moduleName;
    private final Set<String> moduleUses;
    private final EventTypeCompileTimeRegistry locals;
    private final EventTypeRepositoryImpl publics;
    private final PathRegistry<String, EventType> path;
    private final ModuleDependenciesCompileTime moduleDependencies;
    private final boolean isFireAndForget;

    public EventTypeCompileTimeResolver(String moduleName, Set<String> moduleUses, EventTypeCompileTimeRegistry locals, EventTypeRepositoryImpl publics, PathRegistry<String, EventType> path, ModuleDependenciesCompileTime moduleDependencies, boolean isFireAndForget) {
        this.moduleName = moduleName;
        this.moduleUses = moduleUses;
        this.locals = locals;
        this.publics = publics;
        this.path = path;
        this.moduleDependencies = moduleDependencies;
        this.isFireAndForget = isFireAndForget;
    }

    public PathRegistry<String, EventType> getPath() {
        return this.path;
    }

    @Override
    public EventType getTypeByName(String typeName) {
        EventType local = this.locals.getModuleTypes(typeName);
        EventType path = this.resolvePath(typeName);
        EventType preconfigured = this.resolvePreconfigured(typeName);
        return CompileTimeResolver.validateAmbiguous(local, path, preconfigured, PathRegistryObjectType.EVENTTYPE, typeName);
    }

    private EventType resolvePreconfigured(String typeName) {
        EventType eventType = this.publics.getTypeByName(typeName);
        if (eventType == null) {
            return null;
        }
        this.moduleDependencies.addPublicEventType(typeName);
        return eventType;
    }

    private EventType resolvePath(String typeName) {
        try {
            Pair<EventType, String> typeAndModule = this.path.getAnyModuleExpectSingle(typeName, this.moduleUses);
            if (typeAndModule == null) {
                return null;
            }
            if (!this.isFireAndForget && !NameAccessModifier.visible(typeAndModule.getFirst().getMetadata().getAccessModifier(), typeAndModule.getSecond(), this.moduleName)) {
                return null;
            }
            this.moduleDependencies.addPathEventType(typeName, typeAndModule.getSecond());
            return typeAndModule.getFirst();
        }
        catch (PathException e) {
            throw CompileTimeResolver.makePathAmbiguous(PathRegistryObjectType.EVENTTYPE, typeName, e);
        }
    }
}

