/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventPropertyDescriptor;
import com.espertech.esper.common.client.EventPropertyGetter;
import com.espertech.esper.common.client.EventPropertyGetterIndexed;
import com.espertech.esper.common.client.EventPropertyGetterMapped;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.FragmentEventType;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.client.meta.EventTypeIdPair;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.meta.EventTypeTypeClass;
import com.espertech.esper.common.client.util.EventTypeBusModifier;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.DecoratingEventBean;
import com.espertech.esper.common.internal.event.core.EventBeanCopyMethodForge;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactoryCodegenField;
import com.espertech.esper.common.internal.event.core.EventBeanWriter;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterIndexedSPI;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterMappedSPI;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventPropertyWriter;
import com.espertech.esper.common.internal.event.core.EventPropertyWriterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeNameUtil;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.core.MappedEventBean;
import com.espertech.esper.common.internal.event.core.WrapperEventBeanCopyMethodForge;
import com.espertech.esper.common.internal.event.core.WrapperEventBeanMapCopyMethodForge;
import com.espertech.esper.common.internal.event.core.WrapperEventBeanMapWriter;
import com.espertech.esper.common.internal.event.core.WrapperEventBeanPropertyWriter;
import com.espertech.esper.common.internal.event.core.WrapperEventBeanUndCopyMethodForge;
import com.espertech.esper.common.internal.event.core.WrapperEventBeanUndWriter;
import com.espertech.esper.common.internal.event.map.MapEventType;
import com.espertech.esper.common.internal.event.wrap.WrapperGetterIndexed;
import com.espertech.esper.common.internal.event.wrap.WrapperGetterMapped;
import com.espertech.esper.common.internal.event.wrap.WrapperMapPropertyGetter;
import com.espertech.esper.common.internal.event.wrap.WrapperUnderlyingPropertyGetter;
import com.espertech.esper.common.internal.util.CRC32Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WrapperEventType
implements EventTypeSPI {
    protected EventTypeMetadata metadata;
    protected final EventType underlyingEventType;
    protected final MapEventType underlyingMapType;
    private String[] propertyNames;
    private EventPropertyDescriptor[] propertyDesc;
    private Map<String, EventPropertyDescriptor> propertyDescriptorMap;
    private final boolean isNoMapProperties;
    private final Map<String, EventPropertyGetterSPI> propertyGetterCache;
    protected final EventBeanTypedEventFactory eventBeanTypedEventFactory;
    private EventPropertyDescriptor[] writableProperties;
    private Map<String, Pair<EventPropertyDescriptor, EventPropertyWriterSPI>> writers;
    private String startTimestampPropertyName;
    private String endTimestampPropertyName;
    private int numPropertiesUnderlyingType;

    protected WrapperEventType(EventTypeMetadata metadata, EventType underlyingEventType, Map<String, Object> properties, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        this.checkForRepeatedPropertyNames(underlyingEventType, properties);
        this.metadata = metadata;
        this.underlyingEventType = underlyingEventType;
        String innerName = EventTypeNameUtil.getWrapperInnerTypeName(metadata.getName());
        EventTypeIdPair ids = this.computeIdFromWrapped(metadata.getAccessModifier(), innerName, metadata);
        EventTypeMetadata metadataMapType = new EventTypeMetadata(innerName, this.metadata.getModuleName(), metadata.getTypeClass(), metadata.getApplicationType(), metadata.getAccessModifier(), EventTypeBusModifier.NONBUS, false, ids);
        this.underlyingMapType = new MapEventType(metadataMapType, properties, null, null, null, null, beanEventTypeFactory);
        this.isNoMapProperties = properties.isEmpty();
        this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
        this.propertyGetterCache = new HashMap<String, EventPropertyGetterSPI>();
        this.updatePropertySet();
        if (metadata.getTypeClass() == EventTypeTypeClass.NAMED_WINDOW) {
            this.startTimestampPropertyName = underlyingEventType.getStartTimestampPropertyName();
            this.endTimestampPropertyName = underlyingEventType.getEndTimestampPropertyName();
            EventTypeUtility.validateTimestampProperties(this, this.startTimestampPropertyName, this.endTimestampPropertyName);
        }
    }

    @Override
    public void setMetadataId(long publicId, long protectedId) {
        this.metadata = this.metadata.withIds(publicId, protectedId);
    }

    private void checkInitProperties() {
        if (this.numPropertiesUnderlyingType != this.underlyingEventType.getPropertyDescriptors().length) {
            this.updatePropertySet();
        }
    }

    private void updatePropertySet() {
        PropertyDescriptorComposite compositeProperties = WrapperEventType.getCompositeProperties(this.underlyingEventType, this.underlyingMapType);
        this.propertyNames = compositeProperties.getPropertyNames();
        this.propertyDescriptorMap = compositeProperties.getPropertyDescriptorMap();
        this.propertyDesc = compositeProperties.getDescriptors();
        this.numPropertiesUnderlyingType = this.underlyingEventType.getPropertyDescriptors().length;
    }

    private static PropertyDescriptorComposite getCompositeProperties(EventType underlyingEventType, MapEventType underlyingMapType) {
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.addAll(Arrays.asList(underlyingEventType.getPropertyNames()));
        propertyNames.addAll(Arrays.asList(underlyingMapType.getPropertyNames()));
        String[] propertyNamesArr = propertyNames.toArray(new String[propertyNames.size()]);
        ArrayList<EventPropertyDescriptor> propertyDesc = new ArrayList<EventPropertyDescriptor>();
        HashMap<String, EventPropertyDescriptor> propertyDescriptorMap = new HashMap<String, EventPropertyDescriptor>();
        for (EventPropertyDescriptor eventProperty : underlyingEventType.getPropertyDescriptors()) {
            propertyDesc.add(eventProperty);
            propertyDescriptorMap.put(eventProperty.getPropertyName(), eventProperty);
        }
        for (EventPropertyDescriptor mapProperty : underlyingMapType.getPropertyDescriptors()) {
            propertyDesc.add(mapProperty);
            propertyDescriptorMap.put(mapProperty.getPropertyName(), mapProperty);
        }
        EventPropertyDescriptor[] propertyDescArr = propertyDesc.toArray(new EventPropertyDescriptor[propertyDesc.size()]);
        return new PropertyDescriptorComposite(propertyDescriptorMap, propertyNamesArr, propertyDescArr);
    }

    @Override
    public String getStartTimestampPropertyName() {
        return this.startTimestampPropertyName;
    }

    @Override
    public String getEndTimestampPropertyName() {
        return this.endTimestampPropertyName;
    }

    @Override
    public Iterator<EventType> getDeepSuperTypes() {
        return null;
    }

    @Override
    public Set<EventType> getDeepSuperTypesAsSet() {
        return Collections.emptySet();
    }

    @Override
    public String getName() {
        return this.metadata.getName();
    }

    @Override
    public EventPropertyGetterSPI getGetterSPI(String property) {
        EventPropertyGetterSPI cachedGetter = this.propertyGetterCache.get(property);
        if (cachedGetter != null) {
            return cachedGetter;
        }
        if (this.underlyingMapType.isProperty(property) && property.indexOf(63) == -1) {
            EventPropertyGetterSPI mapGetter = this.underlyingMapType.getGetterSPI(property);
            WrapperMapPropertyGetter getter = new WrapperMapPropertyGetter(this, this.eventBeanTypedEventFactory, this.underlyingMapType, mapGetter);
            this.propertyGetterCache.put(property, getter);
            return getter;
        }
        if (this.underlyingEventType.isProperty(property)) {
            EventPropertyGetterSPI underlyingGetter = ((EventTypeSPI)this.underlyingEventType).getGetterSPI(property);
            WrapperUnderlyingPropertyGetter getter = new WrapperUnderlyingPropertyGetter(this, underlyingGetter);
            this.propertyGetterCache.put(property, getter);
            return getter;
        }
        return null;
    }

    @Override
    public EventPropertyGetter getGetter(String propertyName) {
        return this.getGetterSPI(propertyName);
    }

    @Override
    public EventPropertyGetterMappedSPI getGetterMappedSPI(String mappedProperty) {
        EventPropertyGetterMappedSPI undMapped = ((EventTypeSPI)this.underlyingEventType).getGetterMappedSPI(mappedProperty);
        if (undMapped != null) {
            return new WrapperGetterMapped(undMapped);
        }
        final EventPropertyGetterMappedSPI decoMapped = this.underlyingMapType.getGetterMappedSPI(mappedProperty);
        if (decoMapped != null) {
            return new EventPropertyGetterMappedSPI(){

                @Override
                public Object get(EventBean theEvent, String mapKey) throws PropertyAccessException {
                    if (!(theEvent instanceof DecoratingEventBean)) {
                        throw new PropertyAccessException("Mismatched property getter to EventBean type");
                    }
                    DecoratingEventBean wrapperEvent = (DecoratingEventBean)((Object)theEvent);
                    Map<String, Object> map = wrapperEvent.getDecoratingProperties();
                    MappedEventBean wrapped = WrapperEventType.this.eventBeanTypedEventFactory.adapterForTypedMap(map, WrapperEventType.this.underlyingMapType);
                    return decoMapped.get(wrapped, mapKey);
                }

                @Override
                public CodegenExpression eventBeanGetMappedCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpression beanExpression, CodegenExpression key) {
                    CodegenExpressionField factory = codegenClassScope.addOrGetFieldSharable(EventBeanTypedEventFactoryCodegenField.INSTANCE);
                    CodegenExpressionField eventType = codegenClassScope.addFieldUnshared(true, EventType.class, EventTypeUtility.resolveTypeCodegen(WrapperEventType.this.underlyingEventType, EPStatementInitServices.REF));
                    CodegenMethod method = codegenMethodScope.makeChild(Object.class, WrapperEventType.class, (CodegenScope)codegenClassScope).addParam(EventBean.class, "theEvent").addParam(String.class, "mapKey").getBlock().declareVar(DecoratingEventBean.class, "wrapperEvent", CodegenExpressionBuilder.cast(DecoratingEventBean.class, (CodegenExpression)CodegenExpressionBuilder.ref("theEvent"))).declareVar(Map.class, "map", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("wrapperEvent"), "getDecoratingProperties", new CodegenExpression[0])).declareVar(EventBean.class, "wrapped", CodegenExpressionBuilder.exprDotMethod(factory, "adapterForTypedMap", CodegenExpressionBuilder.ref("map"), eventType)).methodReturn(decoMapped.eventBeanGetMappedCodegen(codegenMethodScope, codegenClassScope, CodegenExpressionBuilder.ref("wrapped"), CodegenExpressionBuilder.ref("mapKey")));
                    return CodegenExpressionBuilder.localMethodBuild(method).pass(beanExpression).pass(key).call();
                }
            };
        }
        return null;
    }

    @Override
    public EventPropertyGetterMapped getGetterMapped(String mappedProperty) {
        return this.getGetterMappedSPI(mappedProperty);
    }

    @Override
    public EventPropertyGetterIndexed getGetterIndexed(String indexedPropertyName) {
        return this.getGetterIndexedSPI(indexedPropertyName);
    }

    @Override
    public EventPropertyGetterIndexedSPI getGetterIndexedSPI(String indexedProperty) {
        EventPropertyGetterIndexedSPI undIndexed = ((EventTypeSPI)this.underlyingEventType).getGetterIndexedSPI(indexedProperty);
        if (undIndexed != null) {
            return new WrapperGetterIndexed(undIndexed);
        }
        final EventPropertyGetterIndexedSPI decoIndexed = this.underlyingMapType.getGetterIndexedSPI(indexedProperty);
        if (decoIndexed != null) {
            return new EventPropertyGetterIndexedSPI(){

                @Override
                public Object get(EventBean theEvent, int index) throws PropertyAccessException {
                    if (!(theEvent instanceof DecoratingEventBean)) {
                        throw new PropertyAccessException("Mismatched property getter to EventBean type");
                    }
                    DecoratingEventBean wrapperEvent = (DecoratingEventBean)((Object)theEvent);
                    Map<String, Object> map = wrapperEvent.getDecoratingProperties();
                    MappedEventBean wrapped = WrapperEventType.this.eventBeanTypedEventFactory.adapterForTypedMap(map, WrapperEventType.this.underlyingMapType);
                    return decoIndexed.get(wrapped, index);
                }

                @Override
                public CodegenExpression eventBeanGetIndexedCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpression beanExpression, CodegenExpression key) {
                    CodegenExpressionField factory = codegenClassScope.addOrGetFieldSharable(EventBeanTypedEventFactoryCodegenField.INSTANCE);
                    CodegenExpressionField eventType = codegenClassScope.addFieldUnshared(true, EventType.class, EventTypeUtility.resolveTypeCodegen(WrapperEventType.this.underlyingEventType, EPStatementInitServices.REF));
                    CodegenMethod method = codegenMethodScope.makeChild(Object.class, WrapperEventType.class, (CodegenScope)codegenClassScope).addParam(EventBean.class, "theEvent").addParam(Integer.TYPE, "index").getBlock().declareVar(DecoratingEventBean.class, "wrapperEvent", CodegenExpressionBuilder.cast(DecoratingEventBean.class, (CodegenExpression)CodegenExpressionBuilder.ref("theEvent"))).declareVar(Map.class, "map", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("wrapperEvent"), "getDecoratingProperties", new CodegenExpression[0])).declareVar(EventBean.class, "wrapped", CodegenExpressionBuilder.exprDotMethod(factory, "adapterForTypedMap", CodegenExpressionBuilder.ref("map"), eventType)).methodReturn(decoIndexed.eventBeanGetIndexedCodegen(codegenMethodScope, codegenClassScope, CodegenExpressionBuilder.ref("wrapped"), CodegenExpressionBuilder.ref("index")));
                    return CodegenExpressionBuilder.localMethodBuild(method).pass(beanExpression).pass(key).call();
                }
            };
        }
        return null;
    }

    @Override
    public String[] getPropertyNames() {
        this.checkInitProperties();
        return this.propertyNames;
    }

    @Override
    public Class getPropertyType(String property) {
        if (this.underlyingEventType.isProperty(property)) {
            return this.underlyingEventType.getPropertyType(property);
        }
        if (this.underlyingMapType.isProperty(property)) {
            return this.underlyingMapType.getPropertyType(property);
        }
        return null;
    }

    @Override
    public EventType[] getSuperTypes() {
        return null;
    }

    @Override
    public Class getUnderlyingType() {
        if (this.isNoMapProperties) {
            return this.underlyingEventType.getUnderlyingType();
        }
        return Pair.class;
    }

    public EventType getUnderlyingEventType() {
        return this.underlyingEventType;
    }

    public MapEventType getUnderlyingMapType() {
        return this.underlyingMapType;
    }

    @Override
    public boolean isProperty(String property) {
        return this.underlyingEventType.isProperty(property) || this.underlyingMapType.isProperty(property);
    }

    public String toString() {
        return "WrapperEventType name=" + this.getName() + " underlyingEventType=(" + this.underlyingEventType + ") underlyingMapType=(" + this.underlyingMapType + ")";
    }

    @Override
    public ExprValidationException equalsCompareType(EventType otherEventType) {
        if (this == otherEventType) {
            return null;
        }
        if (!(otherEventType instanceof WrapperEventType)) {
            return new ExprValidationException("Expected a wrapper event type but received " + otherEventType);
        }
        WrapperEventType other = (WrapperEventType)otherEventType;
        ExprValidationException underlyingMapCompare = other.underlyingMapType.equalsCompareType(this.underlyingMapType);
        if (underlyingMapCompare != null) {
            return underlyingMapCompare;
        }
        if (!(other.underlyingEventType instanceof EventTypeSPI) || !(this.underlyingEventType instanceof EventTypeSPI)) {
            if (!other.underlyingEventType.equals(this.underlyingEventType)) {
                return new ExprValidationException("Wrapper underlying type mismatches");
            }
            return null;
        }
        EventTypeSPI otherUnderlying = (EventTypeSPI)other.underlyingEventType;
        EventTypeSPI thisUnderlying = (EventTypeSPI)this.underlyingEventType;
        return otherUnderlying.equalsCompareType(thisUnderlying);
    }

    @Override
    public EventTypeMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public EventPropertyDescriptor[] getPropertyDescriptors() {
        this.checkInitProperties();
        return this.propertyDesc;
    }

    @Override
    public EventPropertyDescriptor getPropertyDescriptor(String propertyName) {
        this.checkInitProperties();
        return this.propertyDescriptorMap.get(propertyName);
    }

    @Override
    public FragmentEventType getFragmentType(String property) {
        FragmentEventType fragment = this.underlyingEventType.getFragmentType(property);
        if (fragment != null) {
            return fragment;
        }
        return this.underlyingMapType.getFragmentType(property);
    }

    @Override
    public EventPropertyWriterSPI getWriter(String propertyName) {
        Pair<EventPropertyDescriptor, EventPropertyWriterSPI> pair;
        if (this.writableProperties == null) {
            this.initializeWriters();
        }
        if ((pair = this.writers.get(propertyName)) == null) {
            return null;
        }
        return pair.getSecond();
    }

    @Override
    public EventPropertyDescriptor getWritableProperty(String propertyName) {
        Pair<EventPropertyDescriptor, EventPropertyWriterSPI> pair;
        if (this.writableProperties == null) {
            this.initializeWriters();
        }
        if ((pair = this.writers.get(propertyName)) == null) {
            return null;
        }
        return pair.getFirst();
    }

    @Override
    public EventPropertyDescriptor[] getWriteableProperties() {
        if (this.writableProperties == null) {
            this.initializeWriters();
        }
        return this.writableProperties;
    }

    private void initializeWriters() {
        ArrayList<EventPropertyDescriptor> writables = new ArrayList<EventPropertyDescriptor>();
        HashMap<String, Pair<EventPropertyDescriptor, EventPropertyWriterSPI>> writerMap = new HashMap<String, Pair<EventPropertyDescriptor, EventPropertyWriterSPI>>();
        writables.addAll(Arrays.asList(this.underlyingMapType.getWriteableProperties()));
        for (EventPropertyDescriptor writableMapProp : this.underlyingMapType.getWriteableProperties()) {
            final String propertyName = writableMapProp.getPropertyName();
            writables.add(writableMapProp);
            EventPropertyWriterSPI writer = new EventPropertyWriterSPI(){

                @Override
                public void write(Object value, EventBean target) {
                    DecoratingEventBean decorated = (DecoratingEventBean)((Object)target);
                    decorated.getDecoratingProperties().put(propertyName, value);
                }

                @Override
                public CodegenExpression writeCodegen(CodegenExpression assigned, CodegenExpression und, CodegenExpression target, CodegenMethodScope parent, CodegenClassScope classScope) {
                    CodegenExpression decorated = CodegenExpressionBuilder.cast(DecoratingEventBean.class, target);
                    CodegenExpression decoratingProps = CodegenExpressionBuilder.exprDotMethod(decorated, "getDecoratingProperties", new CodegenExpression[0]);
                    return CodegenExpressionBuilder.exprDotMethod(decoratingProps, "put", CodegenExpressionBuilder.constant(propertyName), assigned);
                }
            };
            writerMap.put(propertyName, new Pair<EventPropertyDescriptor, 3>(writableMapProp, writer));
        }
        if (this.underlyingEventType instanceof EventTypeSPI) {
            EventTypeSPI spi = (EventTypeSPI)this.underlyingEventType;
            for (EventPropertyDescriptor writableUndProp : spi.getWriteableProperties()) {
                String propertyName = writableUndProp.getPropertyName();
                final EventPropertyWriterSPI innerWriter = spi.getWriter(propertyName);
                if (innerWriter == null) continue;
                writables.add(writableUndProp);
                EventPropertyWriterSPI writer = new EventPropertyWriterSPI(){

                    @Override
                    public void write(Object value, EventBean target) {
                        DecoratingEventBean decorated = (DecoratingEventBean)((Object)target);
                        innerWriter.write(value, decorated.getUnderlyingEvent());
                    }

                    @Override
                    public CodegenExpression writeCodegen(CodegenExpression assigned, CodegenExpression und, CodegenExpression target, CodegenMethodScope parent, CodegenClassScope classScope) {
                        CodegenExpression decorated = CodegenExpressionBuilder.cast(DecoratingEventBean.class, target);
                        CodegenExpression underlyingBean = CodegenExpressionBuilder.exprDotMethod(decorated, "getUnderlyingEvent", new CodegenExpression[0]);
                        CodegenExpression underlying = CodegenExpressionBuilder.exprDotMethod(underlyingBean, "getUnderlying", new CodegenExpression[0]);
                        CodegenExpression casted = CodegenExpressionBuilder.cast(WrapperEventType.this.underlyingEventType.getUnderlyingType(), underlying);
                        return ((EventPropertyWriterSPI)innerWriter).writeCodegen(assigned, casted, target, parent, classScope);
                    }
                };
                writerMap.put(propertyName, new Pair<EventPropertyDescriptor, 4>(writableUndProp, writer));
            }
        }
        this.writers = writerMap;
        this.writableProperties = writables.toArray(new EventPropertyDescriptor[writables.size()]);
    }

    @Override
    public EventBeanCopyMethodForge getCopyMethodForge(String[] properties) {
        if (this.writableProperties == null) {
            this.initializeWriters();
        }
        boolean isOnlyMap = true;
        for (int i = 0; i < properties.length; ++i) {
            if (this.underlyingMapType.getWritableProperty(properties[i]) != null) continue;
            isOnlyMap = false;
        }
        boolean isOnlyUnderlying = true;
        if (!isOnlyMap) {
            if (!(this.underlyingEventType instanceof EventTypeSPI)) {
                return null;
            }
            EventTypeSPI spi = (EventTypeSPI)this.underlyingEventType;
            for (int i = 0; i < properties.length; ++i) {
                if (spi.getWritableProperty(properties[i]) != null) continue;
                isOnlyUnderlying = false;
            }
        }
        if (isOnlyMap) {
            return new WrapperEventBeanMapCopyMethodForge(this);
        }
        EventBeanCopyMethodForge undCopyMethod = ((EventTypeSPI)this.underlyingEventType).getCopyMethodForge(properties);
        if (undCopyMethod == null) {
            return null;
        }
        if (isOnlyUnderlying) {
            return new WrapperEventBeanUndCopyMethodForge(this, undCopyMethod);
        }
        return new WrapperEventBeanCopyMethodForge(this, undCopyMethod);
    }

    @Override
    public EventBeanWriter getWriter(String[] properties) {
        int i;
        EventTypeSPI spi;
        if (this.writableProperties == null) {
            this.initializeWriters();
        }
        boolean isOnlyMap = true;
        for (int i2 = 0; i2 < properties.length; ++i2) {
            if (!this.writers.containsKey(properties[i2])) {
                return null;
            }
            if (this.underlyingMapType.getWritableProperty(properties[i2]) != null) continue;
            isOnlyMap = false;
        }
        boolean isOnlyUnderlying = true;
        if (!isOnlyMap) {
            spi = (EventTypeSPI)this.underlyingEventType;
            for (i = 0; i < properties.length; ++i) {
                if (spi.getWritableProperty(properties[i]) != null) continue;
                isOnlyUnderlying = false;
            }
        }
        if (isOnlyMap) {
            return new WrapperEventBeanMapWriter(properties);
        }
        if (isOnlyUnderlying) {
            spi = (EventTypeSPI)this.underlyingEventType;
            EventBeanWriter undWriter = spi.getWriter(properties);
            if (undWriter == null) {
                return undWriter;
            }
            return new WrapperEventBeanUndWriter(undWriter);
        }
        EventPropertyWriter[] writerArr = new EventPropertyWriter[properties.length];
        for (i = 0; i < properties.length; ++i) {
            writerArr[i] = this.writers.get(properties[i]).getSecond();
        }
        return new WrapperEventBeanPropertyWriter(writerArr);
    }

    private void checkForRepeatedPropertyNames(EventType eventType, Map<String, Object> properties) {
        for (String property : eventType.getPropertyNames()) {
            if (!properties.keySet().contains(property)) continue;
            throw new EPException("Property '" + property + "' occurs in both the underlying event and in the additional properties");
        }
    }

    public EventTypeIdPair computeIdFromWrapped(NameAccessModifier visibility, String innerName, EventTypeMetadata metadataWrapper) {
        if (visibility == NameAccessModifier.TRANSIENT || visibility == NameAccessModifier.PRIVATE) {
            return new EventTypeIdPair(metadataWrapper.getEventTypeIdPair().getPublicId(), CRC32Util.computeCRC32(innerName));
        }
        return new EventTypeIdPair(CRC32Util.computeCRC32(innerName), -1L);
    }

    public static class PropertyDescriptorComposite {
        private final HashMap<String, EventPropertyDescriptor> propertyDescriptorMap;
        private final String[] propertyNames;
        private final EventPropertyDescriptor[] descriptors;

        public PropertyDescriptorComposite(HashMap<String, EventPropertyDescriptor> propertyDescriptorMap, String[] propertyNames, EventPropertyDescriptor[] descriptors) {
            this.propertyDescriptorMap = propertyDescriptorMap;
            this.propertyNames = propertyNames;
            this.descriptors = descriptors;
        }

        public HashMap<String, EventPropertyDescriptor> getPropertyDescriptorMap() {
            return this.propertyDescriptorMap;
        }

        public String[] getPropertyNames() {
            return this.propertyNames;
        }

        public EventPropertyDescriptor[] getDescriptors() {
            return this.descriptors;
        }
    }
}

