/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.eventtyperepo;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.event.eventtyperepo.EventTypeRepository;
import com.espertech.esper.common.internal.util.CRC32Util;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class EventTypeRepositoryImpl
implements EventTypeRepository {
    private final boolean compileTime;
    private final Map<String, EventType> nameToTypeMap = new HashMap<String, EventType>();
    private final Map<Long, EventType> idToTypeMap = new HashMap<Long, EventType>();

    public EventTypeRepositoryImpl(boolean compileTime) {
        this.compileTime = compileTime;
    }

    @Override
    public EventType getTypeByName(String typeName) {
        return this.nameToTypeMap.get(typeName);
    }

    @Override
    public EventType getTypeById(long eventTypeIdPublic) {
        return this.idToTypeMap.get(eventTypeIdPublic);
    }

    public Collection<EventType> getAllTypes() {
        return this.nameToTypeMap.values();
    }

    @Override
    public void addType(EventType eventType) {
        String name = eventType.getMetadata().getName();
        if (this.nameToTypeMap.containsKey(name)) {
            throw new IllegalArgumentException("Event type by name '" + name + "' already registered");
        }
        this.nameToTypeMap.put(name, eventType);
        long publicId = eventType.getMetadata().getEventTypeIdPair().getPublicId();
        if (this.compileTime) {
            publicId = CRC32Util.computeCRC32(name);
        } else if (publicId == -1L) {
            throw new IllegalArgumentException("Event type by name '" + name + "' has a public id of -1 at runtime");
        }
        EventType sameIdType = this.idToTypeMap.get(publicId);
        if (sameIdType != null) {
            throw new IllegalArgumentException("Event type by name '" + name + "' has a public crc32 id overlap with event type by name '" + sameIdType.getName() + "', please consider renaming either of these types");
        }
        this.idToTypeMap.put(publicId, eventType);
    }

    public void removeType(EventType eventType) {
        this.nameToTypeMap.remove(eventType.getName());
        this.idToTypeMap.remove(CRC32Util.computeCRC32(eventType.getName()));
    }

    public void mergeFrom(EventTypeRepositoryImpl other) {
        for (Map.Entry<String, EventType> entry : other.getNameToTypeMap().entrySet()) {
            if (this.nameToTypeMap.containsKey(entry.getKey())) continue;
            this.addType(entry.getValue());
        }
    }

    @Override
    public Map<String, EventType> getNameToTypeMap() {
        return this.nameToTypeMap;
    }
}

