/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.eventtyperepo;

import com.espertech.esper.common.client.configuration.ConfigurationException;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeWithSupertype;
import com.espertech.esper.common.internal.event.eventtyperepo.EventTypeRepositoryMapTypeUtil;
import com.espertech.esper.common.internal.util.GraphCircularDependencyException;
import com.espertech.esper.common.internal.util.GraphUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EventTypeRepositoryUtil {
    public static List<String> getCreationOrder(Set<String> firstSet, Set<String> secondSet, Map<String, ? extends ConfigurationCommonEventTypeWithSupertype> configurations) {
        Set<String> dependentOrder;
        ArrayList<String> creationOrder = new ArrayList<String>();
        creationOrder.addAll(firstSet);
        creationOrder.addAll(secondSet);
        try {
            Map<String, Set<String>> typesReferences = EventTypeRepositoryMapTypeUtil.toTypesReferences(configurations);
            dependentOrder = GraphUtil.getTopDownOrder(typesReferences);
        }
        catch (GraphCircularDependencyException e) {
            throw new ConfigurationException("Error configuring event types, dependency graph between map type names is circular: " + e.getMessage(), e);
        }
        if (dependentOrder.isEmpty() || dependentOrder.size() < 2) {
            return creationOrder;
        }
        String[] dependents = dependentOrder.toArray(new String[0]);
        for (int i = 1; i < dependents.length; ++i) {
            int indexSuper = creationOrder.indexOf(dependents[i - 1]);
            int indexSub = creationOrder.indexOf(dependents[i]);
            if (indexSuper == -1 || indexSub == -1 || indexSuper <= indexSub) continue;
            creationOrder.remove(indexSub);
            if (indexSuper == creationOrder.size()) {
                creationOrder.add(dependents[i]);
                continue;
            }
            creationOrder.add(indexSuper + 1, dependents[i]);
        }
        return creationOrder;
    }
}

