/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.compiletime;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.json.util.EventSenderJson;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.json.core.JsonEventType;
import com.espertech.esper.common.internal.event.util.EPRuntimeEventProcessWrapped;
import com.espertech.esper.common.internal.statement.thread.ThreadingCommon;

public class EventSenderJsonImpl
implements EventSenderJson {
    private final EPRuntimeEventProcessWrapped runtimeEventSender;
    private final EventBeanTypedEventFactory eventBeanTypedEventFactory;
    private final JsonEventType eventType;
    private final ThreadingCommon threadingService;

    public EventSenderJsonImpl(EPRuntimeEventProcessWrapped runtimeEventSender, JsonEventType eventType, EventBeanTypedEventFactory eventBeanTypedEventFactory, ThreadingCommon threadingService) {
        this.runtimeEventSender = runtimeEventSender;
        this.eventType = eventType;
        this.threadingService = threadingService;
        this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
    }

    @Override
    public void sendEvent(Object theEvent) {
        Object underlying = this.getUnderlying(theEvent);
        EventBean eventBean = this.eventBeanTypedEventFactory.adapterForTypedJson(underlying, this.eventType);
        if (this.threadingService.isInboundThreading()) {
            this.threadingService.submitInbound(eventBean, this.runtimeEventSender);
        } else {
            this.runtimeEventSender.processWrappedEvent(eventBean);
        }
    }

    @Override
    public void routeEvent(Object theEvent) {
        EventBean eventBean = this.eventBeanTypedEventFactory.adapterForTypedJson(this.getUnderlying(theEvent), this.eventType);
        this.runtimeEventSender.routeEventBean(eventBean);
    }

    @Override
    public Object parse(String json) {
        return this.eventType.parse(json);
    }

    private Object getUnderlying(Object theEvent) {
        if (theEvent instanceof String) {
            return this.eventType.parse((String)theEvent);
        }
        if (theEvent == null || theEvent.getClass() != this.eventType.getUnderlyingType()) {
            throw new EPException("Unexpected event object of type '" + (theEvent == null ? "(null)" : theEvent.getClass().getName()) + "', expected a Json-formatted string-type value");
        }
        return theEvent;
    }
}

