/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.compiletime;

import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeBean;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.event.bean.core.PropertyStem;
import com.espertech.esper.common.internal.event.bean.introspect.PropertyListBuilderPublic;
import com.espertech.esper.common.internal.event.json.compiletime.JsonApplicationClassDelegateDesc;
import com.espertech.esper.common.internal.event.json.parser.forge.JsonForgeFactoryBuiltinClassTyped;
import com.espertech.esper.common.internal.util.ConstructorHelper;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JsonEventTypeUtilityReflective {
    public static LinkedHashMap<Class, JsonApplicationClassDelegateDesc> computeClassesDeep(Class clazz, String eventTypeName, Annotation[] annotations, StatementCompileTimeServices services) throws ExprValidationException {
        LinkedHashMap<Class, List<Field>> deepClassesWFields = new LinkedHashMap<Class, List<Field>>();
        JsonEventTypeUtilityReflective.computeClassesDeep(clazz, deepClassesWFields, new ArrayDeque<Class>(), annotations, services);
        return JsonEventTypeUtilityReflective.assignDelegateClassNames(eventTypeName, deepClassesWFields);
    }

    public static LinkedHashMap<Class, JsonApplicationClassDelegateDesc> computeClassesDeep(Map<String, Object> fields, String eventTypeName, Annotation[] annotations, StatementCompileTimeServices services) throws ExprValidationException {
        LinkedHashMap<Class, List<Field>> deepClassesWFields = new LinkedHashMap<Class, List<Field>>();
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            Class clazz;
            if (!(entry.getValue() instanceof Class) || !JsonEventTypeUtilityReflective.isDeepClassEligibleType(clazz = (Class)entry.getValue(), entry.getKey(), null, annotations, services)) continue;
            JsonEventTypeUtilityReflective.computeClassesDeep(clazz, deepClassesWFields, new ArrayDeque<Class>(), annotations, services);
        }
        return JsonEventTypeUtilityReflective.assignDelegateClassNames(eventTypeName, deepClassesWFields);
    }

    private static LinkedHashMap<Class, JsonApplicationClassDelegateDesc> assignDelegateClassNames(String eventTypeName, LinkedHashMap<Class, List<Field>> deepClassesWFields) {
        LinkedHashMap<Class, JsonApplicationClassDelegateDesc> classes = new LinkedHashMap<Class, JsonApplicationClassDelegateDesc>();
        for (Map.Entry<Class, List<Field>> classEntry : deepClassesWFields.entrySet()) {
            String replaced = classEntry.getKey().getName().replaceAll("\\.", "_").replaceAll("\\$", "_");
            String delegateClassName = eventTypeName + "_Delegate_" + replaced;
            String delegateFactoryClassName = eventTypeName + "_Factory_" + replaced;
            classes.put(classEntry.getKey(), new JsonApplicationClassDelegateDesc(delegateClassName, delegateFactoryClassName, classEntry.getValue()));
        }
        return classes;
    }

    private static void computeClassesDeep(Class clazz, Map<Class, List<Field>> deepClasses, Deque<Class> stack, Annotation[] annotations, StatementCompileTimeServices services) throws ExprValidationException {
        if (deepClasses.containsKey(clazz)) {
            return;
        }
        List<Field> fields = JsonEventTypeUtilityReflective.resolveFields(clazz);
        for (Field field : fields) {
            if (JavaClassHelper.isImplementsInterface(field.getType(), Collection.class)) {
                Class genericType = JavaClassHelper.getGenericFieldType(field, true);
                if (genericType == null || stack.contains(genericType) || !JsonEventTypeUtilityReflective.isDeepClassEligibleType(genericType, field.getName(), field, annotations, services) || genericType == Object.class) continue;
                stack.add(genericType);
                JsonEventTypeUtilityReflective.computeClassesDeep(genericType, deepClasses, stack, annotations, services);
                stack.removeLast();
                continue;
            }
            if (field.getType().isArray()) {
                Class arrayType = JavaClassHelper.getArrayComponentTypeInnermost(field.getType());
                if (stack.contains(arrayType) || !JsonEventTypeUtilityReflective.isDeepClassEligibleType(arrayType, field.getName(), field, annotations, services) || arrayType == Object.class) continue;
                stack.add(arrayType);
                JsonEventTypeUtilityReflective.computeClassesDeep(arrayType, deepClasses, stack, annotations, services);
                stack.removeLast();
                continue;
            }
            if (stack.contains(field.getType()) || !JsonEventTypeUtilityReflective.isDeepClassEligibleType(field.getType(), field.getName(), field, annotations, services)) continue;
            stack.add(field.getType());
            JsonEventTypeUtilityReflective.computeClassesDeep(field.getType(), deepClasses, stack, annotations, services);
            stack.removeLast();
        }
        deepClasses.put(clazz, fields);
    }

    private static boolean isDeepClassEligibleType(Class genericType, String fieldName, Field optionalField, Annotation[] annotations, StatementCompileTimeServices services) throws ExprValidationException {
        if (!ConstructorHelper.hasDefaultConstructor(genericType)) {
            return false;
        }
        try {
            JsonForgeFactoryBuiltinClassTyped.forge(genericType, fieldName, optionalField, Collections.emptyMap(), annotations, services);
            return false;
        }
        catch (UnsupportedOperationException ex) {
            return true;
        }
    }

    private static List<Field> resolveFields(Class clazz) {
        PropertyListBuilderPublic propertyListBuilder = new PropertyListBuilderPublic(new ConfigurationCommonEventTypeBean());
        List<PropertyStem> properties = propertyListBuilder.assessProperties(clazz);
        ArrayList<Field> props = new ArrayList<Field>();
        for (PropertyStem stem : properties) {
            int modifiers;
            Field field = stem.getAccessorField();
            if (field == null || !Modifier.isPublic(modifiers = field.getModifiers()) || Modifier.isStatic(modifiers)) continue;
            props.add(field);
        }
        return props;
    }
}

