/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.compiletime;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.json.minimaljson.JsonWriter;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProviderEmpty;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassType;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRelational;
import com.espertech.esper.common.internal.bytecodemodel.model.statement.CodegenStatementSwitch;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenStackGenerator;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableType;
import com.espertech.esper.common.internal.event.core.TypeBeanOrUnderlying;
import com.espertech.esper.common.internal.event.json.compiletime.JsonUnderlyingField;
import com.espertech.esper.common.internal.event.json.compiletime.StmtClassForgeableJsonDesc;
import com.espertech.esper.common.internal.event.json.compiletime.StmtClassForgeableJsonUtil;
import com.espertech.esper.common.internal.event.json.core.JsonEventObjectBase;
import com.espertech.esper.common.internal.event.json.core.JsonEventType;
import com.espertech.esper.common.internal.event.json.parser.core.JsonDelegateBase;
import com.espertech.esper.common.internal.event.json.parser.core.JsonDelegateFactory;
import com.espertech.esper.common.internal.event.json.parser.core.JsonHandlerDelegator;
import com.espertech.esper.common.internal.event.json.parser.forge.JsonForgeDesc;
import com.espertech.esper.common.internal.event.json.write.JsonWriteForgeRefs;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StmtClassForgeableJsonDelegateFactory
implements StmtClassForgeable {
    private final CodegenClassType classType;
    private final String className;
    private final boolean makeWriteMethod;
    private final CodegenPackageScope packageScope;
    private final String delegateClassName;
    private final String underlyingClassName;
    private final StmtClassForgeableJsonDesc desc;

    public StmtClassForgeableJsonDelegateFactory(CodegenClassType classType, String className, boolean makeWriteMethod, CodegenPackageScope packageScope, String delegateClassName, String underlyingClassName, StmtClassForgeableJsonDesc desc) {
        this.classType = classType;
        this.className = className;
        this.makeWriteMethod = makeWriteMethod;
        this.packageScope = packageScope;
        this.delegateClassName = delegateClassName;
        this.underlyingClassName = underlyingClassName;
        this.desc = desc;
    }

    @Override
    public CodegenClass forge(boolean includeDebugSymbols, boolean fireAndForget) {
        CodegenClassMethods methods = new CodegenClassMethods();
        CodegenClassScope classScope = new CodegenClassScope(includeDebugSymbols, this.packageScope, this.className);
        CodegenMethod makeMethod = CodegenMethod.makeParentNode(JsonDelegateBase.class, StmtClassForgeableJsonDelegateFactory.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(JsonHandlerDelegator.class, "delegator").addParam(JsonDelegateBase.class, "parent");
        makeMethod.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(this.delegateClassName, CodegenExpressionBuilder.ref("delegator"), CodegenExpressionBuilder.ref("parent"), CodegenExpressionBuilder.newInstance(this.underlyingClassName, new CodegenExpression[0])));
        CodegenStackGenerator.recursiveBuildStack(makeMethod, "make", methods);
        CodegenMethod writeMethod = CodegenMethod.makeParentNode(Void.TYPE, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(JsonWriter.class, "writer").addParam(Object.class, "underlying").addThrown(IOException.class);
        writeMethod.getBlock().staticMethod(this.className, "writeStatic", CodegenExpressionBuilder.ref("writer"), CodegenExpressionBuilder.ref("underlying"));
        CodegenStackGenerator.recursiveBuildStack(writeMethod, "write", methods);
        CodegenMethod writeStaticMethod = CodegenMethod.makeParentNode(Void.TYPE, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(JsonWriter.class, "writer").addParam(Object.class, "underlying").addThrown(IOException.class);
        writeStaticMethod.setStatic(true);
        if (this.makeWriteMethod) {
            this.makeNativeWrite(writeStaticMethod, classScope);
        } else {
            writeStaticMethod.getBlock().methodThrowUnsupported();
        }
        CodegenStackGenerator.recursiveBuildStack(writeStaticMethod, "writeStatic", methods);
        CodegenMethod copyMethod = CodegenMethod.makeParentNode(Object.class, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(Object.class, "und");
        this.makeCopy(copyMethod, classScope);
        CodegenStackGenerator.recursiveBuildStack(copyMethod, "copy", methods);
        CodegenMethod getValueMethod = CodegenMethod.makeParentNode(Object.class, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(Integer.TYPE, "num").addParam(Object.class, "und");
        this.makeGetValue(getValueMethod, classScope);
        CodegenStackGenerator.recursiveBuildStack(getValueMethod, "getValue", methods);
        CodegenMethod setValueMethod = CodegenMethod.makeParentNode(Void.TYPE, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(Integer.TYPE, "num").addParam(Object.class, "value").addParam(Object.class, "und");
        this.makeSetValue(setValueMethod, classScope);
        CodegenStackGenerator.recursiveBuildStack(setValueMethod, "setValue", methods);
        CodegenMethod newUnderlyingMethod = CodegenMethod.makeParentNode(Object.class, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
        this.makeNewUnderlyingMethod(newUnderlyingMethod);
        CodegenStackGenerator.recursiveBuildStack(newUnderlyingMethod, "newUnderlying", methods);
        CodegenClass clazz = new CodegenClass(this.classType, this.className, classScope, Collections.emptyList(), null, methods, Collections.emptyList());
        clazz.getSupers().addInterfaceImplemented(JsonDelegateFactory.class);
        return clazz;
    }

    private void makeNewUnderlyingMethod(CodegenMethod method) {
        method.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(this.underlyingClassName, new CodegenExpression[0]));
    }

    private void makeGetValue(CodegenMethod method, CodegenClassScope classScope) {
        if (this.desc.getNumFieldsSupertype() > 0) {
            method.getBlock().ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("num"), CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.constant(this.desc.getNumFieldsSupertype()))).blockReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(JsonEventObjectBase.class, (CodegenExpression)CodegenExpressionBuilder.ref("und")), "getNativeValue", CodegenExpressionBuilder.ref("num")));
        }
        method.getBlock().declareVar(this.underlyingClassName, "src", CodegenExpressionBuilder.cast(this.underlyingClassName, (CodegenExpression)CodegenExpressionBuilder.ref("und")));
        CodegenExpression[] cases = StmtClassForgeableJsonUtil.getCasesNumberNtoM(this.desc);
        CodegenStatementSwitch switchStmt = method.getBlock().switchBlockExpressions(CodegenExpressionBuilder.ref("num"), cases, true, false);
        StmtClassForgeableJsonUtil.makeNoSuchElementDefault(switchStmt, CodegenExpressionBuilder.ref("num"));
        int index = 0;
        for (Map.Entry<String, Object> property : this.desc.getPropertiesThisType().entrySet()) {
            JsonUnderlyingField field = this.desc.getFieldDescriptorsInclSupertype().get(property.getKey());
            switchStmt.getBlocks()[index].blockReturn(CodegenExpressionBuilder.ref("src." + field.getFieldName()));
            ++index;
        }
    }

    private void makeCopy(CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().declareVar(this.underlyingClassName, "copy", CodegenExpressionBuilder.newInstance(this.underlyingClassName, new CodegenExpression[0])).declareVar(this.underlyingClassName, "src", CodegenExpressionBuilder.cast(this.underlyingClassName, (CodegenExpression)CodegenExpressionBuilder.ref("und")));
        for (Map.Entry<String, JsonUnderlyingField> field : this.desc.getFieldDescriptorsInclSupertype().entrySet()) {
            CodegenExpression rhs;
            String fieldName = field.getValue().getFieldName();
            Class fieldType = field.getValue().getPropertyType();
            CodegenExpressionRef sourceField = CodegenExpressionBuilder.ref("src." + fieldName);
            if (fieldType.isArray()) {
                CodegenMethod arrayCopy = method.makeChild(fieldType, this.getClass(), (CodegenScope)classScope).addParam(fieldType, "src");
                rhs = CodegenExpressionBuilder.localMethod(arrayCopy, sourceField);
                arrayCopy.getBlock().ifRefNullReturnNull("src").declareVar(fieldType, "copy", CodegenExpressionBuilder.newArrayByLength(fieldType.getComponentType(), CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("src")))).staticMethod(System.class, "arraycopy", CodegenExpressionBuilder.ref("src"), CodegenExpressionBuilder.constant(0), CodegenExpressionBuilder.ref("copy"), CodegenExpressionBuilder.constant(0), CodegenExpressionBuilder.constant(0)).methodReturn(CodegenExpressionBuilder.ref("copy"));
            } else if (fieldType == Map.class) {
                CodegenMethod mapCopy = method.makeChild(Map.class, this.getClass(), (CodegenScope)classScope).addParam(fieldType, "src");
                rhs = CodegenExpressionBuilder.localMethod(mapCopy, sourceField);
                mapCopy.getBlock().ifRefNullReturnNull("src").methodReturn(CodegenExpressionBuilder.newInstance(HashMap.class, CodegenExpressionBuilder.ref("src")));
            } else {
                rhs = sourceField;
            }
            method.getBlock().assignRef(CodegenExpressionBuilder.ref("copy." + fieldName), rhs);
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("copy"));
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public StmtClassForgeableType getForgeableType() {
        return StmtClassForgeableType.JSONDELEGATEFACTORY;
    }

    private void makeNativeWrite(CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().declareVar(this.underlyingClassName, "und", CodegenExpressionBuilder.cast(this.underlyingClassName, (CodegenExpression)CodegenExpressionBuilder.ref("underlying"))).ifRefNull("und").exprDotMethod(CodegenExpressionBuilder.ref("writer"), "writeLiteral", CodegenExpressionBuilder.constant("null")).blockReturnNoValue().exprDotMethod(CodegenExpressionBuilder.ref("writer"), "writeObjectOpen", new CodegenExpression[0]);
        boolean first = true;
        for (Map.Entry<String, Object> property : this.desc.getPropertiesThisType().entrySet()) {
            JsonUnderlyingField field = this.desc.getFieldDescriptorsInclSupertype().get(property.getKey());
            JsonForgeDesc forge = this.desc.getForges().get(property.getKey());
            String fieldName = field.getFieldName();
            if (!first) {
                method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("writer"), "writeObjectSeparator", new CodegenExpression[0]);
            }
            first = false;
            CodegenExpression write = forge.getWriteForge().codegenWrite(new JsonWriteForgeRefs(CodegenExpressionBuilder.ref("writer"), CodegenExpressionBuilder.ref("und." + fieldName), CodegenExpressionBuilder.constant(property.getKey())), method, classScope);
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("writer"), "writeMemberName", CodegenExpressionBuilder.constant(property.getKey())).exprDotMethod(CodegenExpressionBuilder.ref("writer"), "writeMemberSeparator", new CodegenExpression[0]).expression(write);
        }
        method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("writer"), "writeObjectClose", new CodegenExpression[0]);
    }

    private void makeSetValue(CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().declareVar(this.underlyingClassName, "bean", CodegenExpressionBuilder.cast(this.underlyingClassName, (CodegenExpression)CodegenExpressionBuilder.ref("und")));
        CodegenExpression[] cases = StmtClassForgeableJsonUtil.getCasesNumberNtoM(this.desc);
        CodegenStatementSwitch switchStmt = method.getBlock().switchBlockExpressions(CodegenExpressionBuilder.ref("num"), cases, false, false);
        StmtClassForgeableJsonUtil.makeNoSuchElementDefault(switchStmt, CodegenExpressionBuilder.ref("num"));
        CodegenBlock[] blocks = switchStmt.getBlocks();
        int index = 0;
        for (Map.Entry<String, Object> property : this.desc.getPropertiesThisType().entrySet()) {
            JsonUnderlyingField field = this.desc.getFieldDescriptorsInclSupertype().get(property.getKey());
            String fieldName = "bean." + field.getFieldName();
            Object type = this.desc.getPropertiesThisType().get(property.getKey());
            if (type != null) {
                if (type instanceof Class) {
                    Class classType = (Class)type;
                    if (classType.isPrimitive()) {
                        blocks[index].ifRefNotNull("value").assignRef(fieldName, CodegenExpressionBuilder.cast(JavaClassHelper.getBoxedType(classType), (CodegenExpression)CodegenExpressionBuilder.ref("value")));
                    } else {
                        blocks[index].assignRef(fieldName, CodegenExpressionBuilder.cast(classType, (CodegenExpression)CodegenExpressionBuilder.ref("value")));
                    }
                } else if (type instanceof TypeBeanOrUnderlying) {
                    EventType eventType = ((TypeBeanOrUnderlying)type).getEventType();
                    if (eventType instanceof JsonEventType) {
                        JsonEventType jsonEventType = (JsonEventType)eventType;
                        CodegenExpression castAsBean = CodegenExpressionBuilder.castUnderlying(jsonEventType.getDetail().getUnderlyingClassName(), CodegenExpressionBuilder.cast(EventBean.class, (CodegenExpression)CodegenExpressionBuilder.ref("value")));
                        CodegenExpression castUnd = CodegenExpressionBuilder.cast(jsonEventType.getDetail().getUnderlyingClassName(), (CodegenExpression)CodegenExpressionBuilder.ref("value"));
                        blocks[index].assignRef(fieldName, CodegenExpressionBuilder.conditional(CodegenExpressionBuilder.instanceOf(CodegenExpressionBuilder.ref("value"), EventBean.class), castAsBean, castUnd));
                    } else {
                        CodegenExpression castAsBean = CodegenExpressionBuilder.castUnderlying(Map.class, CodegenExpressionBuilder.cast(EventBean.class, (CodegenExpression)CodegenExpressionBuilder.ref("value")));
                        CodegenExpression castUnd = CodegenExpressionBuilder.cast(Map.class, (CodegenExpression)CodegenExpressionBuilder.ref("value"));
                        blocks[index].assignRef(fieldName, CodegenExpressionBuilder.conditional(CodegenExpressionBuilder.instanceOf(CodegenExpressionBuilder.ref("value"), EventBean.class), castAsBean, castUnd));
                    }
                } else if (type instanceof TypeBeanOrUnderlying[]) {
                    TypeBeanOrUnderlying[] typeDef = (TypeBeanOrUnderlying[])type;
                    EventType eventType = typeDef[0].getEventType();
                    Class arrayType = JavaClassHelper.getArrayType(eventType.getUnderlyingType());
                    blocks[index].ifRefNull("value").assignRef(fieldName, CodegenExpressionBuilder.constantNull()).blockReturnNoValue().ifCondition(CodegenExpressionBuilder.instanceOf(CodegenExpressionBuilder.ref("value"), arrayType)).assignRef(fieldName, CodegenExpressionBuilder.cast(arrayType, (CodegenExpression)CodegenExpressionBuilder.ref("value"))).blockReturnNoValue().declareVar(EventBean[].class, "events", CodegenExpressionBuilder.cast(EventBean[].class, (CodegenExpression)CodegenExpressionBuilder.ref("value"))).declareVar(arrayType, "array", CodegenExpressionBuilder.newArrayByLength(eventType.getUnderlyingType(), CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("events")))).forLoopIntSimple("i", CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("events"))).assignArrayElement("array", (CodegenExpression)CodegenExpressionBuilder.ref("i"), CodegenExpressionBuilder.castUnderlying(eventType.getUnderlyingType(), CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("events"), CodegenExpressionBuilder.ref("i")))).blockEnd().assignRef(fieldName, (CodegenExpression)CodegenExpressionBuilder.ref("array"));
                } else {
                    throw new UnsupportedOperationException("Unrecognized type " + type);
                }
            }
            ++index;
        }
    }
}

