/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.parser.core;

import com.espertech.esper.common.client.json.minimaljson.JsonHandler;
import com.espertech.esper.common.internal.event.json.parser.core.JsonDelegateBase;
import com.espertech.esper.common.internal.event.json.parser.core.JsonDelegateUnknown;
import com.espertech.esper.common.internal.event.json.parser.core.JsonValueType;

public class JsonHandlerDelegator
extends JsonHandler<Object, Object> {
    private JsonDelegateBase currentDelegate;
    private String currentName;

    public void setDelegate(JsonDelegateBase top) {
        this.currentDelegate = top;
    }

    @Override
    public void startObjectValue(Object object, String name) {
        this.currentName = name;
    }

    @Override
    public Object startObject() {
        if (this.currentName != null) {
            this.currentDelegate.valueType = JsonValueType.OBJECT;
            JsonDelegateBase next = this.currentDelegate.startObject(this.currentName);
            if (next == null) {
                next = new JsonDelegateUnknown(this, this.currentDelegate);
            }
            this.currentDelegate = next;
        }
        return null;
    }

    @Override
    public Object startArray() {
        if (this.currentName != null) {
            this.currentDelegate.valueType = JsonValueType.ARRAY;
            JsonDelegateBase next = this.currentDelegate.startArray(this.currentName);
            if (next == null) {
                next = new JsonDelegateUnknown(this, this.currentDelegate);
            }
            this.currentDelegate = next;
        }
        return null;
    }

    @Override
    public void endString(String string) {
        this.currentDelegate.endString(string);
    }

    @Override
    public void endNumber(String string) {
        this.currentDelegate.endNumber(string);
    }

    @Override
    public void endNull() {
        this.currentDelegate.endNull();
    }

    @Override
    public void endBoolean(boolean value) {
        this.currentDelegate.endBoolean(value);
    }

    @Override
    public void endObjectValue(Object object, String name) {
        this.currentDelegate.endObjectValue(name);
    }

    @Override
    public void endArrayValue(Object array) {
        this.currentDelegate.endArrayValue(this.currentName);
    }

    @Override
    public void endArray(Object array) {
        Object result = this.currentDelegate.getResult();
        this.currentDelegate = this.currentDelegate.getParent();
        if (this.currentDelegate != null) {
            this.currentDelegate.setObjectValue(result);
        }
    }

    @Override
    public void endObject(Object object) {
        Object result = this.currentDelegate.getResult();
        this.currentDelegate = this.currentDelegate.getParent();
        if (this.currentDelegate != null) {
            this.currentDelegate.setObjectValue(result);
        }
    }
}

