/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.parser.delegates.endvalue;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.event.json.parser.delegates.endvalue.JsonEndValueForge;
import com.espertech.esper.common.internal.event.json.parser.delegates.endvalue.JsonEndValueForgeUtil;
import com.espertech.esper.common.internal.event.json.parser.delegates.endvalue.JsonEndValueRefs;

public class JsonEndValueForgeDouble
implements JsonEndValueForge {
    public static final JsonEndValueForgeDouble INSTANCE = new JsonEndValueForgeDouble();

    private JsonEndValueForgeDouble() {
    }

    @Override
    public CodegenExpression captureValue(JsonEndValueRefs refs, CodegenMethod method, CodegenClassScope classScope) {
        return CodegenExpressionBuilder.staticMethod(JsonEndValueForgeDouble.class, "jsonToDouble", refs.getValueString(), refs.getName());
    }

    public static Double jsonToDouble(String value, String name) {
        return value == null ? null : Double.valueOf(JsonEndValueForgeDouble.jsonToDoubleNonNull(value, name));
    }

    public static double jsonToDoubleNonNull(String stringValue, String name) {
        try {
            return Double.parseDouble(stringValue);
        }
        catch (NumberFormatException ex) {
            throw JsonEndValueForgeUtil.handleNumberException(name, Double.class, stringValue, ex);
        }
    }
}

