/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.parser.delegates.endvalue;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.event.json.parser.delegates.endvalue.JsonEndValueForge;
import com.espertech.esper.common.internal.event.json.parser.delegates.endvalue.JsonEndValueForgeUtil;
import com.espertech.esper.common.internal.event.json.parser.delegates.endvalue.JsonEndValueRefs;

public class JsonEndValueForgeFloat
implements JsonEndValueForge {
    public static final JsonEndValueForgeFloat INSTANCE = new JsonEndValueForgeFloat();

    private JsonEndValueForgeFloat() {
    }

    @Override
    public CodegenExpression captureValue(JsonEndValueRefs refs, CodegenMethod method, CodegenClassScope classScope) {
        return CodegenExpressionBuilder.staticMethod(JsonEndValueForgeFloat.class, "jsonToFloat", refs.getValueString(), refs.getName());
    }

    public static Float jsonToFloat(String value, String name) {
        return value == null ? null : Float.valueOf(JsonEndValueForgeFloat.jsonToFloatNonNull(value, name));
    }

    public static float jsonToFloatNonNull(String stringValue, String name) {
        try {
            return Float.parseFloat(stringValue);
        }
        catch (NumberFormatException ex) {
            throw JsonEndValueForgeUtil.handleNumberException(name, Float.class, stringValue, ex);
        }
    }
}

